/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.ui.internal.providers;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ElementTypeIconProvider
extends AbstractProvider
implements IIconProvider {
    private ImageRegistry imageRegistry;

    public Image getIcon(IAdaptable hint, int flags) {
        IElementType type = this.getType(hint);
        if (type != null) {
            URL url;
            Image image = this.getImageRegistry().get(type.getId());
            if (image == null && (url = type.getIconURL()) != null) {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                this.getImageRegistry().put(type.getId(), descriptor);
                image = this.getImageRegistry().get(type.getId());
            }
            return image;
        }
        return null;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetIconOperation) {
            IIconOperation getIconOperation = (IIconOperation)operation;
            IAdaptable hint = getIconOperation.getHint();
            return this.getType(hint) != null;
        }
        return false;
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    private IElementType getType(IAdaptable hint) {
        IElementType type = (IElementType)hint.getAdapter(IElementType.class);
        if (type == null) {
            IElementType[] types;
            EObject eObject = (EObject)hint.getAdapter(EObject.class);
            if (eObject != null && (types = ElementTypeRegistry.getInstance().getAllTypesMatching(eObject)).length > 0) {
                type = types[0];
            }
        } else if (ElementTypeRegistry.getInstance().getType(type.getId()) == null) {
            type = null;
        }
        return type;
    }
}

