/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibrary;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jst.common.project.facet.core.internal.ClasspathUtil;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLibraryProviderInstallOperationConfig
extends LibraryProviderInstallOperationConfig {
    private static final String CLASS_NAME = UserLibraryProviderInstallOperationConfig.class.getName();
    public static final String PREFS_LAST_USED_LIBRARIES = "user.library.provider/last.used.libraries";
    public static final String PROP_LIBRARY_NAMES = String.valueOf(CLASS_NAME) + ".LIBRARY_NAMES";
    private static final String PARAM_VALIDATOR = "validator";
    private static final String PARAM_VALIDATOR_PARAM = "validator.param";
    private List<String> libraryNames = Collections.emptyList();
    private List<String> libraryNamesReadOnly = Collections.emptyList();
    private UserLibraryValidator validator = null;

    @Override
    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fproj, fv, provider);
        Map<String, String> params = provider.getParams();
        String validatorClassName = params.get(PARAM_VALIDATOR);
        if (validatorClassName != null) {
            this.validator = (UserLibraryValidator)PluginUtil.instantiate((String)provider.getPluginId(), (String)validatorClassName, UserLibraryValidator.class);
            if (this.validator != null) {
                ArrayList<String> keyClassNames = new ArrayList<String>();
                int i = 0;
                String paramName = "validator.param." + String.valueOf(i);
                String paramValue = params.get(paramName);
                while (paramValue != null) {
                    keyClassNames.add(paramValue);
                    paramName = "validator.param." + String.valueOf(++i);
                    paramValue = params.get(paramName);
                }
                try {
                    this.validator.init(keyClassNames);
                }
                catch (Exception e) {
                    FacetedProjectFrameworkJavaPlugin.log(e);
                    this.validator = null;
                }
            }
        }
        this.reset();
    }

    public final synchronized List<String> getLibraryNames() {
        return this.libraryNamesReadOnly;
    }

    public final synchronized void setLibraryNames(List<String> libraryNames) {
        List<String> oldLibraryNames = this.libraryNamesReadOnly;
        this.libraryNames = new ArrayList<String>(libraryNames);
        this.libraryNamesReadOnly = Collections.unmodifiableList(this.libraryNames);
        this.notifyListeners(PROP_LIBRARY_NAMES, oldLibraryNames, this.libraryNamesReadOnly);
    }

    public final synchronized void addLibraryName(String libraryName) {
        if (!this.libraryNamesReadOnly.contains(libraryName)) {
            List<String> oldLibraryNames = this.libraryNamesReadOnly;
            this.libraryNames = new ArrayList<String>(oldLibraryNames);
            this.libraryNamesReadOnly = Collections.unmodifiableList(this.libraryNames);
            this.libraryNames.add(libraryName);
            this.notifyListeners(PROP_LIBRARY_NAMES, oldLibraryNames, this.libraryNamesReadOnly);
        }
    }

    public synchronized Collection<IClasspathEntry> resolve() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        UserLibraryManager userLibraryManager = JavaModelManager.getUserLibraryManager();
        for (String libraryName : this.libraryNames) {
            UserLibrary userLibrary = userLibraryManager.getUserLibrary(libraryName);
            if (userLibrary == null) continue;
            IClasspathEntry[] iClasspathEntryArray = userLibrary.getEntries();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                entries.add(cpe);
                ++n2;
            }
        }
        return Collections.unmodifiableCollection(entries);
    }

    @Override
    public synchronized IStatus validate() {
        IStatus st = Status.OK_STATUS;
        if (this.libraryNames.size() == 0) {
            st = FacetedProjectFrameworkJavaPlugin.createErrorStatus(Resources.libraryNeedsToBeSelected);
        } else if (this.validator != null) {
            try {
                st = this.validator.validate(this);
            }
            catch (Exception e) {
                FacetedProjectFrameworkJavaPlugin.log(e);
                this.validator = null;
            }
        }
        return st;
    }

    @Override
    public synchronized void reset() {
        ILibraryProvider currentProvider;
        IProject project = this.getFacetedProject().getProject();
        IProjectFacet f = this.getProjectFacet();
        IProjectFacetVersion fv = this.getProjectFacetVersion();
        ArrayList<String> newLibraryNames = null;
        if (project != null && (currentProvider = LibraryProviderFramework.getCurrentProvider(project, f)) == this.getLibraryProvider()) {
            List<IClasspathEntry> entries;
            try {
                entries = ClasspathUtil.getClasspathEntries(project, f);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            ArrayList<String> libraryNamesList = new ArrayList<String>();
            for (IClasspathEntry cpe : entries) {
                IPath path;
                if (cpe.getEntryKind() != 5 || (path = cpe.getPath()).segmentCount() < 2 || !path.segment(0).equals("org.eclipse.jdt.USER_LIBRARY")) continue;
                libraryNamesList.add(path.segment(1));
            }
            newLibraryNames = libraryNamesList;
        }
        if (newLibraryNames == null) {
            newLibraryNames = new ArrayList<String>();
            try {
                Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)f);
                if (prefs.nodeExists(PREFS_LAST_USED_LIBRARIES) && (prefs = prefs.node(PREFS_LAST_USED_LIBRARIES)).nodeExists(fv.getVersionString())) {
                    prefs = prefs.node(fv.getVersionString());
                    String[] stringArray = prefs.childrenNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String libraryName = stringArray[n2];
                        newLibraryNames.add(libraryName);
                        ++n2;
                    }
                }
            }
            catch (BackingStoreException e) {
                FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
            }
        }
        this.setLibraryNames(newLibraryNames);
    }

    private static final class Resources
    extends NLS {
        public static String libraryNeedsToBeSelected;

        static {
            Resources.initializeMessages((String)UserLibraryProviderInstallOperationConfig.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

