(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "dockerfile-ast"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) Remy Suen. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var dockerfile_ast_1 = require("dockerfile-ast");
    var DockerLinks = /** @class */ (function () {
        function DockerLinks() {
        }
        DockerLinks.prototype.getLinks = function (content) {
            var dockerfile = dockerfile_ast_1.DockerfileParser.parse(content);
            var links = [];
            var stages = dockerfile.getFROMs().reduce(function (accumulator, from) {
                var stage = from.getBuildStage();
                if (stage !== null) {
                    accumulator.push(stage);
                }
                return accumulator;
            }, []);
            for (var _i = 0, _a = dockerfile.getFROMs(); _i < _a.length; _i++) {
                var from = _a[_i];
                var name = from.getImageName();
                if (name !== null && stages.indexOf(name) === -1) {
                    if (name.indexOf('/') === -1) {
                        links.push({
                            range: from.getImageNameRange(),
                            data: "_/" + name + '/'
                        });
                    }
                    else {
                        links.push({
                            range: from.getImageNameRange(),
                            data: "r/" + name + '/'
                        });
                    }
                }
            }
            return links;
        };
        DockerLinks.prototype.resolveLink = function (link) {
            if (link.data) {
                link.target = "https://hub.docker.com/" + link.data;
            }
            return link;
        };
        return DockerLinks;
    }());
    exports.DockerLinks = DockerLinks;
});
