/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.launch;

import java.io.File;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gcov.launch.GcovLaunchMessages;
import org.eclipse.linuxtools.internal.gcov.parser.CovManager;
import org.eclipse.linuxtools.internal.gcov.view.CovView;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModelTracker;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.profiling.ui.CProjectBuildHelpers;
import org.eclipse.linuxtools.profiling.ui.MessageDialogSyncedRunnable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GcovLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    protected ILaunchConfiguration config;
    protected IProject project;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        this.project = this.getProject();
        IPath exePath = GcovLaunchConfigurationDelegate.getExePath(config);
        if (!this.preRequisiteCheck()) {
            return;
        }
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.getProject());
        File workDir = this.getWorkingDirectory(config);
        if (workDir == null) {
            workDir = new File(System.getProperty("user.home", "."));
        }
        String[] arguments = this.getProgramArgumentsArray(config);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, exePath));
        Process process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)new Path(workDir.getAbsolutePath()), monitor);
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
    }

    private boolean preRequisiteCheck() {
        CProjectBuildHelpers.ProjectBuildType projectBuildType = CProjectBuildHelpers.getProjectType((IProject)this.project);
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            return this.preRequisiteCheckAutotools(projectBuildType);
        }
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            return this.preRequisiteCheckManagedBuild(projectBuildType);
        }
        return true;
    }

    private boolean preRequisiteCheckAutotools(CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String optionId = "cflags-gcov";
        if (CProjectBuildHelpers.isOptionCheckedInAutotoolsPrefStore((IProject)this.project, (String)optionId)) {
            return true;
        }
        return this.askUserAboutFlag(optionId, projectBuildType);
    }

    private boolean preRequisiteCheckManagedBuild(CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String optionId = null;
        if (CProjectBuildHelpers.isCppType((IProject)this.project)) {
            optionId = "gnu.cpp.compiler.option.debugging.codecov";
        } else if (CProjectBuildHelpers.isCType((IProject)this.project)) {
            optionId = "gnu.c.compiler.option.debugging.codecov";
        }
        if (CProjectBuildHelpers.isOptionCheckedInCDT((IProject)this.project, (String)optionId)) {
            return true;
        }
        return this.askUserAboutFlag(optionId, projectBuildType);
    }

    private boolean askUserAboutFlag(String optionId, CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String title = GcovLaunchMessages.GcovMissingFlag_Title;
        String msg = GcovLaunchMessages.GcovMissingFlag_MainMsg;
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            msg = String.valueOf(msg) + GcovLaunchMessages.GcovMissingFlag_AutotoolsInfo;
        } else if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            msg = String.valueOf(msg) + GcovLaunchMessages.GcovMissingFlag_CDTInfo;
        }
        msg = String.valueOf(msg) + GcovLaunchMessages.GcovMissingFlag_PostQuestion;
        boolean okPressed = MessageDialogSyncedRunnable.openQuestionSyncedRunnable((String)title, (String)msg);
        if (okPressed) {
            this.enableOption(optionId, projectBuildType);
            CProjectBuildHelpers.rebuildProject((IProject)this.project);
            return true;
        }
        return false;
    }

    private void enableOption(String optionId, CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            CProjectBuildHelpers.setOptionInCDT((IProject)this.project, (String)optionId, (boolean)true);
        } else if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            CProjectBuildHelpers.setOptionInAutotools((IProject)this.project, (String)optionId, (String)"true");
        }
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.gcov.launch";
    }

    private IProject getProject() {
        try {
            return CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IPath getExePath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private IPath exePath;

        public LaunchTerminationWatcher(ILaunch il, IPath exePath) {
            this.launch = il;
            this.exePath = exePath;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch)) {
                    String s = this.exePath.toOSString();
                    CovManager cvrgeMnger = new CovManager(s, GcovLaunchConfigurationDelegate.this.getProject());
                    try {
                        List gcdaPaths = cvrgeMnger.getGCDALocations();
                        if (gcdaPaths.isEmpty()) {
                            String title = GcovLaunchMessages.GcovCompilerOptions_msg;
                            String message = GcovLaunchMessages.GcovCompileAgain_msg;
                            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                                Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                            });
                        }
                        CovView.displayCovResults((String)s, null);
                        GcovAnnotationModelTracker.getInstance().addProject(GcovLaunchConfigurationDelegate.this.getProject(), this.exePath);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> GcovAnnotationModelTracker.getInstance().annotateAllCEditors());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

