/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.chart;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.internal.chart.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ChartCanvas
extends Canvas {
    IDeviceRenderer renderer = null;
    private Chart chart = null;
    private GeneratedChartState state = null;
    private Image cachedImage = null;
    private boolean needsGeneration = true;
    private boolean isDisabled = false;

    public ChartCanvas(Composite parent, int style) {
        super(parent, style);
        try {
            PluginSettings ps = PluginSettings.instance();
            this.renderer = ps.getDevice("dv.SWT");
        }
        catch (ChartException e) {
            throw new RuntimeException(e);
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ChartCanvas.this.isDisabled) {
                    return;
                }
                try {
                    Composite co = (Composite)e.getSource();
                    Rectangle rect = co.getClientArea();
                    if (ChartCanvas.this.needsGeneration) {
                        ChartCanvas.this.drawToCachedImage(rect);
                    }
                    e.gc.drawImage(ChartCanvas.this.cachedImage, 0, 0, ((ChartCanvas)ChartCanvas.this).cachedImage.getBounds().width, ((ChartCanvas)ChartCanvas.this).cachedImage.getBounds().height, 0, 0, rect.width, rect.height);
                }
                catch (LinkageError t) {
                    this.handleError(t);
                }
                catch (ChartException t) {
                    this.handleError(t);
                }
            }

            private void handleError(Throwable t) {
                ChartCanvas.this.isDisabled = true;
                MemoryAnalyserPlugin.log((Throwable)t, (String)MessageUtil.format((String)Messages.ChartCanvas_Error_DisableChartRendering, (Object[])new Object[]{t.getMessage()}));
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ChartCanvas.this.needsGeneration = true;
            }
        });
    }

    private void generateChartState() throws ChartException {
        Point size = this.getSize();
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)size.x, (double)size.y);
        int resolution = this.renderer.getDisplayServer().getDpiResolution();
        bo.scale(72.0 / (double)resolution);
        Generator gr = Generator.instance();
        RunTimeContext rtc = new RunTimeContext();
        rtc.setScriptClassLoader(new IScriptClassLoader(){

            public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                return this.getClass().getClassLoader().loadClass(className);
            }
        });
        this.state = gr.build(this.renderer.getDisplayServer(), this.chart, bo, null, rtc, null);
        this.needsGeneration = false;
    }

    private void drawToCachedImage(Rectangle size) throws ChartException {
        GC gc = null;
        try {
            if (this.cachedImage != null) {
                this.cachedImage.dispose();
            }
            this.cachedImage = new Image((Device)Display.getCurrent(), size.width, size.height);
            gc = new GC((Drawable)this.cachedImage);
            this.renderer.setProperty("device.output.context", (Object)gc);
            if (this.chart != null) {
                this.generateChartState();
                Generator gr = Generator.instance();
                gr.render(this.renderer, this.state);
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.needsGeneration = true;
        this.chart = chart;
    }

    public void dispose() {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
        }
        super.dispose();
    }

    public Chart getRunTimeModel() {
        return this.state.getChartModel();
    }
}

