/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.ui.runtime.SectionDiscriminator;

class TabModel<V> {
    private final Map<Path, V> model = new HashMap<Path, V>();

    TabModel() {
    }

    public Set<String> tabIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Path next : this.model.keySet()) {
            result.add(next.tabID);
        }
        return Collections.unmodifiableSet(result);
    }

    public V get(Section section) {
        return this.model.get(new Path(section));
    }

    public V get(String tabID, String sectionID) {
        return this.model.get(new Path(tabID, sectionID));
    }

    public Collection<V> get(String tabID) {
        ArrayList<V> result = new ArrayList<V>(4);
        Path key = new Path(tabID);
        for (Map.Entry<Path, V> next : this.model.entrySet()) {
            if (!next.getKey().equals(key)) continue;
            result.add(next.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public V put(Section section, V value) {
        return this.model.put(new Path(section), value);
    }

    public V put(String tabID, String sectionID, V value) {
        return this.model.put(new Path(tabID, sectionID), value);
    }

    public V remove(Section section) {
        return this.model.remove(new Path(section));
    }

    public V remove(String tabID, String sectionID) {
        return this.model.remove(new Path(tabID, sectionID));
    }

    public Collection<V> remove(String tabID) {
        ArrayList<V> result = new ArrayList<V>(4);
        Path key = new Path(tabID);
        V next = this.model.remove(key);
        while (next != null) {
            result.add(next);
            next = this.model.remove(key);
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<V> clear() {
        ArrayList<V> result = new ArrayList<V>(this.model.values());
        this.model.clear();
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return String.format("TabModel%s", this.model.toString());
    }

    static final class Path {
        private static final String WILDCARD = new String("*");
        final String tabID;
        final String sectionID;
        final Object discriminator;

        Path(String tabID, String sectionID, Object discriminator) {
            Path.checkWildcard(tabID);
            Path.checkWildcard(sectionID);
            this.tabID = tabID;
            this.sectionID = sectionID;
            this.discriminator = discriminator == null ? WILDCARD : discriminator;
        }

        Path(String tabID, String sectionID) {
            this(tabID, sectionID, WILDCARD);
        }

        Path(String tabID) {
            Path.checkWildcard(tabID);
            this.tabID = tabID;
            this.sectionID = WILDCARD;
            this.discriminator = WILDCARD;
        }

        Path(Section section) {
            this(section.getTab().getId(), section.getName(), SectionDiscriminator.getDiscriminator(section));
        }

        static void checkWildcard(String id) {
            if (id == null || id == WILDCARD) {
                throw new IllegalArgumentException("Attempt to create a wildcard path explicitly");
            }
        }

        public String toString() {
            return String.format("(%s, %s)", this.tabID, this.sectionID);
        }

        public int hashCode() {
            return this.tabID.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Path)) {
                return false;
            }
            Path other = (Path)obj;
            return Path.equals(this.tabID, other.tabID) && Path.equals(this.sectionID, other.sectionID) && Path.equals(this.discriminator, other.discriminator);
        }

        private static boolean equals(Object anID, Object anotherID) {
            return anID == WILDCARD || anotherID == WILDCARD || anID.equals(anotherID);
        }
    }
}

