/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.psf.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.psf.Activator;
import org.eclipse.papyrus.infra.psf.runtime.ImportResult;
import org.eclipse.papyrus.infra.psf.ui.FilterProjectsDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.TeamCapabilityHelper;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSetImporter {
    public static ImportResult importProjectSetFromString(String psfContents, String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        XMLMemento xmlMemento = ProjectSetImporter.stringToXMLMemento(psfContents);
        return ProjectSetImporter.importProjectSet(xmlMemento, filename, shell, monitor);
    }

    public static ImportResult importProjectSet(String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        XMLMemento xmlMemento = ProjectSetImporter.filenameToXMLMemento(filename);
        return ProjectSetImporter.importProjectSet(xmlMemento, filename, shell, monitor);
    }

    private static ImportResult importProjectSet(XMLMemento xmlMemento, String filename, Shell shell, IProgressMonitor mainMonitor) throws InvocationTargetException {
        ImportResult result = new ImportResult();
        final List<IStatus> diagnostic = result.getDiagnostic();
        Map<String, List<String>> providersToProjects = ProjectSetImporter.filterProjects(xmlMemento, shell);
        if (providersToProjects == null) {
            mainMonitor.setCanceled(true);
            return result;
        }
        try {
            String version = xmlMemento.getString("version");
            ArrayList<Object> newProjects = new ArrayList<Object>();
            if (version.equals("1.0")) {
                IProject[] projects;
                IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)"versionOneSerializer");
                if (serializer != null && (projects = serializer.addToWorkspace(new String[0], filename, (Object)shell, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    newProjects.addAll(Arrays.asList(projects));
                }
            } else {
                final ProjectSetSerializationContext context = new ProjectSetSerializationContext(filename);
                int nbProjects = 0;
                for (List<String> projects : providersToProjects.values()) {
                    nbProjects += projects.size();
                }
                int nbWorkingSets = xmlMemento.getChildren("workingSets").length;
                int totalWork = nbProjects + nbWorkingSets;
                mainMonitor.beginTask(String.format("Importing %s projects", nbProjects), totalWork);
                for (Map.Entry<String, List<String>> providerToProjects : providersToProjects.entrySet()) {
                    if (mainMonitor.isCanceled()) {
                        return result;
                    }
                    List<String> projects = providerToProjects.getValue();
                    String id = providerToProjects.getKey();
                    TeamCapabilityHelper.getInstance().processRepositoryId(id, PlatformUI.getWorkbench().getActivitySupport());
                    RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                    if (providerType == null) {
                        providerType = TeamPlugin.getAliasType((String)id);
                    }
                    if (providerType == null) {
                        diagnostic.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.psf", String.format("Unknown team provider: %s", id)));
                        mainMonitor.worked(projects.size());
                        continue;
                    }
                    final ProjectSetCapability serializer = providerType.getProjectSetCapability();
                    ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                    if (serializer == null) continue;
                    for (final String ref : projects) {
                        if (mainMonitor.isCanceled()) {
                            return result;
                        }
                        try {
                            SubProgressMonitor monitor = new SubProgressMonitor(mainMonitor, 1);
                            final String projectName = ProjectSetImporter.getProjectName(serializer, ref);
                            mainMonitor.subTask(String.format("Importing %s...", projectName));
                            final LinkedList importedProjects = new LinkedList();
                            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                    try {
                                        IProject[] allProjects = serializer.addToWorkspace(new String[]{ref}, context, monitor);
                                        if (allProjects != null) {
                                            importedProjects.addAll(Arrays.asList(allProjects));
                                        }
                                    }
                                    catch (Exception ex) {
                                        diagnostic.add(new Status(4, "org.eclipse.papyrus.infra.psf", String.format("An error occurred when importing %s", projectName), (Throwable)ex));
                                    }
                                }
                            };
                            operation.run((IProgressMonitor)monitor);
                            for (IProject project : importedProjects) {
                                if (project == null) continue;
                                try {
                                    project.refreshLocal(2, null);
                                }
                                catch (CoreException ex) {
                                    Activator.log.error((Throwable)ex);
                                }
                                catch (OperationCanceledException ex) {
                                    // empty catch block
                                }
                            }
                            newProjects.addAll(importedProjects);
                        }
                        catch (InterruptedException ex) {
                            mainMonitor.setCanceled(true);
                        }
                        catch (Exception ex) {
                            diagnostic.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.psf", "An error occurred when importing a project", (Throwable)ex));
                        }
                    }
                }
                IMemento[] sets = xmlMemento.getChildren("workingSets");
                IWorkingSetManager wsManager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
                boolean replaceAll = false;
                boolean mergeAll = false;
                boolean skipAll = false;
                mainMonitor.setTaskName(String.format("Creating %s working sets...", nbWorkingSets));
                IMemento[] iMementoArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento set = iMementoArray[n2];
                    if (mainMonitor.isCanceled()) {
                        return result;
                    }
                    mainMonitor.subTask(String.format("Working set %s", set.getString("label")));
                    IWorkingSet newWs = wsManager.createWorkingSet(set);
                    if (newWs != null) {
                        IWorkingSet oldWs = wsManager.getWorkingSet(newWs.getName());
                        if (oldWs == null) {
                            wsManager.addWorkingSet(newWs);
                        } else if (replaceAll) {
                            ProjectSetImporter.replaceWorkingSet(wsManager, newWs, oldWs);
                        } else if (mergeAll) {
                            ProjectSetImporter.mergeWorkingSets(newWs, oldWs);
                        } else if (!skipAll) {
                            String title = TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_title;
                            String msg = NLS.bind((String)TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_message, (Object)newWs.getName());
                            String[] buttons = new String[]{TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_replace, TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_merge, TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_skip, IDialogConstants.CANCEL_LABEL};
                            final AdviceDialog dialog = new AdviceDialog(shell, title, null, msg, 3, buttons, 0);
                            shell.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    dialog.open();
                                }
                            });
                            switch (dialog.getReturnCode()) {
                                case 0: {
                                    ProjectSetImporter.replaceWorkingSet(wsManager, newWs, oldWs);
                                    replaceAll = dialog.applyToAll;
                                    break;
                                }
                                case 1: {
                                    ProjectSetImporter.mergeWorkingSets(newWs, oldWs);
                                    mergeAll = dialog.applyToAll;
                                    break;
                                }
                                case 2: {
                                    skipAll = dialog.applyToAll;
                                    break;
                                }
                                default: {
                                    mainMonitor.setCanceled(true);
                                }
                            }
                        }
                    }
                    mainMonitor.worked(1);
                    ++n2;
                }
            }
            result.setImportedProjects(newProjects.toArray(new IProject[newProjects.size()]));
            return result;
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static Map<String, List<String>> filterProjects(XMLMemento xmlMemento, Shell shell) {
        IMemento[] providers;
        LinkedHashMap<String, List<String>> providersToProjects = new LinkedHashMap<String, List<String>>();
        IMemento[] iMementoArray = providers = xmlMemento.getChildren("provider");
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento provider = iMementoArray[n2];
            IMemento[] projects = provider.getChildren("project");
            List<String> references = ProjectSetImporter.getReferences(providersToProjects, provider.getString("id"));
            IMemento[] iMementoArray2 = projects;
            int n3 = projects.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento project = iMementoArray2[n4];
                references.add(project.getString("reference"));
                ++n4;
            }
            ++n2;
        }
        final FilterProjectsDialog dialog = new FilterProjectsDialog(shell, providersToProjects);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        if (dialog.getReturnCode() == 0) {
            return dialog.getFilteredProjects();
        }
        return null;
    }

    private static List<String> getReferences(Map<String, List<String>> providersToReferences, String provider) {
        if (!providersToReferences.containsKey(provider)) {
            providersToReferences.put(provider, new LinkedList());
        }
        return providersToReferences.get(provider);
    }

    private static String getProjectName(ProjectSetCapability serializer, String ref) {
        String projectName = serializer.getProject(ref);
        if (projectName == null) {
            int lastIndex = Math.max(ref.lastIndexOf(47), Math.max(ref.lastIndexOf(44), ref.lastIndexOf(92)));
            if (lastIndex == -1) {
                return ref;
            }
            return ref.substring(lastIndex + 1);
        }
        return projectName;
    }

    private static XMLMemento filenameToXMLMemento(String filename) throws InvocationTargetException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)reader);
            return xMLMemento;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvocationTargetException(e);
        }
        catch (FileNotFoundException e) {
            throw new InvocationTargetException(e);
        }
        catch (WorkbenchException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    private static XMLMemento stringToXMLMemento(String stringContents) throws InvocationTargetException {
        StringReader reader = null;
        try {
            reader = new StringReader(stringContents);
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)reader);
            return xMLMemento;
        }
        catch (WorkbenchException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean isValidProjectSetFile(String filename) {
        try {
            return ProjectSetImporter.filenameToXMLMemento(filename).getString("version") != null;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isValidProjectSetString(String psfContent) {
        if (psfContent == null) {
            return false;
        }
        try {
            return ProjectSetImporter.stringToXMLMemento(psfContent).getString("version") != null;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    private static void mergeWorkingSets(IWorkingSet newWs, IWorkingSet oldWs) {
        IAdaptable[] oldElements = oldWs.getElements();
        IAdaptable[] newElements = newWs.getElements();
        HashSet<IAdaptable> combinedElements = new HashSet<IAdaptable>();
        combinedElements.addAll(Arrays.asList(oldElements));
        combinedElements.addAll(Arrays.asList(newElements));
        oldWs.setElements(combinedElements.toArray(new IAdaptable[0]));
    }

    private static void replaceWorkingSet(IWorkingSetManager wsManager, IWorkingSet newWs, IWorkingSet oldWs) {
        if (oldWs != null) {
            wsManager.removeWorkingSet(oldWs);
        }
        wsManager.addWorkingSet(newWs);
    }

    private static class AdviceDialog
    extends MessageDialog {
        boolean applyToAll;

        public AdviceDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Control createCustomArea(Composite parent) {
            final Button checkBox = new Button(parent, 32);
            checkBox.setText(TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_applyToAll);
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdviceDialog.this.applyToAll = checkBox.getSelection();
                }
            });
            return checkBox;
        }
    }
}

