/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.actions.AnalysisDropdownHandler;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class RunAnalyseHandler
extends AbstractHandler {
    protected IStructuredSelection selection;

    public IStructuredSelection getSelection(ExecutionEvent event) {
        ISelection curSel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSel instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)curSel;
        }
        if (this.selection == null) {
            this.selection = AnalysisDropdownHandler.getInstance().getLastSelection();
        }
        if (this.selection == null) {
            this.selection = AnalysisDropdownHandler.getLastAnalysisSelection();
        }
        return this.selection;
    }

    protected int countFilesSelected() {
        int count = 0;
        for (Object obj : this.selection) {
            if (!(obj instanceof IAdaptable)) continue;
            IResource res = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            count += this.countFiles(res);
        }
        return count;
    }

    protected int countFiles(IResource res) {
        if (res instanceof IFile) {
            return 1;
        }
        if (res instanceof IContainer) {
            int count = 0;
            try {
                IResource[] kids = ((IContainer)res).members();
                int i = 0;
                while (i < kids.length) {
                    IResource child = kids[i];
                    count += this.countFiles(child);
                    ++i;
                }
                return count;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    protected int countFilesSelected(String[] exts) {
        int count = 0;
        for (Object obj : this.selection) {
            if (!(obj instanceof IAdaptable)) continue;
            IResource res = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
            count += this.countFiles(res, exts);
        }
        return count;
    }

    protected int countFiles(IResource res, String[] exts) {
        if (res instanceof IFile) {
            IFile file = (IFile)res;
            String filename = file.getName();
            int i = 0;
            while (i < exts.length) {
                String ext = exts[i];
                if (filename.endsWith(ext)) {
                    System.out.println("found " + ext + " in file: " + file.getName() + "  count+1");
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (res instanceof IContainer) {
            int count = 0;
            try {
                IResource[] kids = ((IContainer)res).members();
                int i = 0;
                while (i < kids.length) {
                    IResource child = kids[i];
                    count += this.countFiles(child, exts);
                    ++i;
                }
                return count;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

