/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.core.nature.RcpttNature;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class SelectProjectComponent {
    private Label label;
    private Combo projectCombo;
    private IProject[] projects;
    private IProject project;
    private IStructuredSelection selection;

    public SelectProjectComponent(IStructuredSelection selection) {
        this.selection = selection;
        if (selection == null) {
            this.selection = new StructuredSelection();
        }
    }

    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.projectCombo.setEnabled(enabled);
    }

    public void create(Composite parent) {
        this.label = new Label(parent, 16384);
        this.label.setText(Messages.SelectProjectComponent_ProjectLabel);
        this.label.setLayoutData((Object)this.getLabelData());
        this.projectCombo = new Combo(parent, 8);
        this.projectCombo.setLayoutData((Object)this.getComboData());
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> list = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (RcpttNature.isRcpttProject((IProject)project)) {
                    list.add(project);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        this.projects = list.toArray(new IProject[list.size()]);
        int index = this.getInitalProject();
        int i = 0;
        while (i < this.projects.length) {
            IProject prj = this.projects[i];
            this.projectCombo.add(prj.getName());
            ++i;
        }
        this.projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SelectProjectComponent.this.projectCombo.getSelectionIndex();
                IProject newProject = null;
                if (index >= 0 && index < SelectProjectComponent.this.projects.length) {
                    newProject = SelectProjectComponent.this.projects[index];
                }
                if (newProject != SelectProjectComponent.this.project) {
                    SelectProjectComponent.this.project = newProject;
                    SelectProjectComponent.this.projectChanged();
                }
            }
        });
        if (index >= 0) {
            this.projectCombo.select(index);
            this.project = this.projects[index];
        } else if (this.projects.length > 0) {
            this.projectCombo.select(0);
            this.project = this.projects[0];
        } else {
            this.projectCombo.setText(Messages.SelectProjectComponent_NoQ7ProjectsComboText);
        }
    }

    public void setProject(String name) {
        int i = 0;
        while (i < this.projects.length) {
            if (this.projects[i].getName().equals(name)) {
                this.projectCombo.select(i);
                this.project = this.projects[i];
                return;
            }
            ++i;
        }
    }

    protected GridData getLabelData() {
        return null;
    }

    protected GridData getComboData() {
        return new GridData(768);
    }

    private int getInitalProject() {
        Iterator it = this.selection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                IProject project = selectedResource.getProject();
                int i = 0;
                while (i < this.projects.length) {
                    IProject prj = this.projects[i];
                    if (project.equals((Object)prj)) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    protected abstract void projectChanged();

    public String validate() {
        if (this.projects.length == 0) {
            return Messages.SelectProjectComponent_NoQ7ProjectsExistMsg;
        }
        if (this.project == null) {
            return Messages.SelectProjectComponent_NoQ7ProjectSelectedMsg;
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }
}

