/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.reddeer.common.context.ExecutionSetting;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.LogLevel;

public class Logger {
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String error = "ERROR";
    private static final String warning = "WARNING";
    private static final String debug = "DEBUG";
    private static final String trace = "TRACE";
    private static final String info = "INFO";
    private static final String dump = "DUMP";
    private static final String fatal = "FATAL";
    private static final String step = "STEP";
    private Class<?> loggerClass;

    public static Logger getLogger(Class<?> c) {
        return new Logger(c);
    }

    public Logger(Class<?> c) {
        this.loggerClass = c;
    }

    public void debug(String msg) {
        this.print(debug, msg, 4);
    }

    public void debug(String fmtString, Object ... args) {
        this.debug(String.format(fmtString, args));
    }

    public void trace(String msg) {
        this.print(trace, msg, 2);
    }

    public void trace(String fmtString, Object ... args) {
        this.trace(String.format(fmtString, args));
    }

    public void warn(String msg) {
        this.print(warning, msg, 16);
    }

    public void warn(String fmtString, Object ... args) {
        this.warn(String.format(fmtString, args));
    }

    public void error(String msg) {
        this.print(error, msg, 32);
    }

    public void error(String fmtString, Object ... args) {
        this.error(String.format(fmtString, args));
    }

    public void error(String msg, Throwable t) {
        this.print(error, msg, 32);
        this.printStackTraceRecursive(t);
    }

    public void error(String fmtString, Throwable t, Object ... args) {
        this.error(String.format(fmtString, args), t);
    }

    public void info(String msg) {
        this.print(info, msg, 8);
    }

    public void info(String fmtString, Object ... args) {
        this.info(String.format(fmtString, args));
    }

    public void dump(String msg) {
        this.print(dump, msg, 1);
    }

    public void dump(String fmtString, Object ... args) {
        this.dump(String.format(fmtString, args));
    }

    public void fatal(String msg) {
        this.print(fatal, msg, 64);
    }

    public void step(String fmtString, Object ... args) {
        this.step(String.format(fmtString, args));
    }

    public void step(String msg) {
        this.print(step, msg, 128);
    }

    public void fatal(String fmtString, Object ... args) {
        this.fatal(String.format(fmtString, args));
    }

    private void print(String severity, String msg, int type) {
        if ((type & ExecutionSetting.getInstance().getLogMessageFilter()) != type) {
            return;
        }
        int logLevel = ExecutionSetting.getInstance().getLogLevel();
        if (logLevel < this.getLevelFromMsgType(type).getValue()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.dateFormat.format(new Date())) + " ");
        sb.append(severity);
        sb.append(" [");
        sb.append(this.getThreadName());
        sb.append("]");
        sb.append("[");
        sb.append(this.loggerClass.getSimpleName());
        sb.append("] ");
        sb.append(msg);
        System.out.println(sb.toString());
    }

    private LogLevel getLevelFromMsgType(int msgType) {
        LogLevel ret = LogLevel.ALL;
        switch (msgType) {
            case 0: {
                ret = LogLevel.OFF;
                break;
            }
            case 64: {
                ret = LogLevel.FATAL;
                break;
            }
            case 1: {
                ret = LogLevel.DUMP;
                break;
            }
            case 32: {
                ret = LogLevel.ERROR;
                break;
            }
            case 128: {
                ret = LogLevel.STEP;
                break;
            }
            case 8: {
                ret = LogLevel.INFO;
                break;
            }
            case 16: {
                ret = LogLevel.WARN;
                break;
            }
            case 4: {
                ret = LogLevel.DEBUG;
                break;
            }
            case 2: {
                ret = LogLevel.TRACE;
                break;
            }
            case 255: {
                ret = LogLevel.ALL;
                break;
            }
            default: {
                throw new RedDeerException("Unsupported log level:" + msgType);
            }
        }
        return ret;
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }

    private void printStackTraceRecursive(Throwable t) {
        if (t != null && t.getStackTrace() != null) {
            t.printStackTrace();
            this.printStackTraceRecursive(t.getCause());
        }
    }
}

