/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ConfigFilterAction
extends Action {
    private AbstractTreeControl treeControl;

    public ConfigFilterAction(AbstractTreeControl treeControl) {
        super(null, 1);
        this.treeControl = treeControl;
        this.setToolTipText(Messages.ConfigFilterAction_TooltipText);
        ImageDescriptor image = UIPlugin.getImageDescriptor("ViewerFilterConfig_enabled");
        this.setImageDescriptor(image);
        image = UIPlugin.getImageDescriptor("ViewerFilterConfig_disabled");
        this.setDisabledImageDescriptor(image);
        this.updateEnablement();
    }

    public void run() {
        FilterDescriptor[] filterDescriptors = this.getVisibleFilters();
        Assert.isNotNull((Object)filterDescriptors);
        if (filterDescriptors.length == 0) {
            return;
        }
        ILabelProvider filterLabelProvider = this.createFilterLabelProvider();
        Shell parent = this.treeControl.getViewer().getControl().getShell();
        String message = Messages.ConfigFilterAction_PromptMessage;
        ListSelectionDialog dialog = new ListSelectionDialog(parent, (Object)filterDescriptors, (IStructuredContentProvider)ArrayContentProvider.getInstance(), filterLabelProvider, message);
        dialog.setTitle(Messages.ConfigFilterAction_Title);
        ArrayList<FilterDescriptor> initialSelection = new ArrayList<FilterDescriptor>();
        FilterDescriptor[] filterDescriptorArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDescriptor descriptor = filterDescriptorArray[n2];
            if (descriptor.isEnabled()) {
                initialSelection.add(descriptor);
            }
            ++n2;
        }
        dialog.setInitialElementSelections(initialSelection);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            Object[] objectArray = filterDescriptors;
            int n3 = filterDescriptors.length;
            n = 0;
            while (n < n3) {
                FilterDescriptor descriptor = objectArray[n];
                if (descriptor.isVisible()) {
                    descriptor.setEnabled(false);
                }
                ++n;
            }
            objectArray = elements;
            n3 = elements.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray[n];
                if (element instanceof FilterDescriptor) {
                    FilterDescriptor descriptor = (FilterDescriptor)element;
                    descriptor.setEnabled(true);
                }
                ++n;
            }
            this.treeControl.updateFilters();
            this.treeControl.updateFilterState();
        }
    }

    private FilterDescriptor[] getVisibleFilters() {
        FilterDescriptor[] filterDescriptors = this.treeControl.getFilterDescriptors();
        Assert.isNotNull((Object)filterDescriptors);
        if (filterDescriptors.length > 0) {
            ArrayList<FilterDescriptor> visibleList = new ArrayList<FilterDescriptor>();
            FilterDescriptor[] filterDescriptorArray = filterDescriptors;
            int n = filterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                FilterDescriptor filterDescriptor = filterDescriptorArray[n2];
                if (filterDescriptor.isVisible()) {
                    visibleList.add(filterDescriptor);
                }
                ++n2;
            }
            return visibleList.toArray(new FilterDescriptor[visibleList.size()]);
        }
        return filterDescriptors;
    }

    private ILabelProvider createFilterLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilterDescriptor) {
                    return ((FilterDescriptor)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof FilterDescriptor) {
                    return ((FilterDescriptor)element).getImage();
                }
                return super.getImage(element);
            }
        };
    }

    public void updateEnablement() {
        FilterDescriptor[] filterDescriptors = this.treeControl.getFilterDescriptors();
        Assert.isNotNull((Object)filterDescriptors);
        boolean enabled = false;
        if (filterDescriptors.length > 0) {
            FilterDescriptor[] filterDescriptorArray = filterDescriptors;
            int n = filterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                FilterDescriptor filterDescriptor = filterDescriptorArray[n2];
                if (filterDescriptor.isVisible()) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        this.setEnabled(enabled);
    }
}

