/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSRepositoryLocationMatcher;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class CVSProjectSetCapability
extends ProjectSetCapability {
    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] result = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            result[i] = this.asReference(projects[i]);
            ++i;
        }
        return result;
    }

    private String asReference(IProject project) throws TeamException {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
        CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString(root.getRemoteLocation().getLocation(false));
        location.setUserMuteable(true);
        ICVSFolder folder = root.getLocalRoot();
        return this.asReference(location, folder, project);
    }

    private String asReference(CVSRepositoryLocation location, ICVSFolder folder, IProject project) throws TeamException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("1.0,");
        String repoLocation = location.getLocation();
        buffer.append(repoLocation);
        buffer.append(",");
        FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
        String module = syncInfo.getRepository();
        buffer.append(module);
        buffer.append(",");
        String projectName = project.getName();
        buffer.append(projectName);
        CVSEntryLineTag tag = syncInfo.getTag();
        if (tag != null && ((CVSTag)tag).getType() != 3) {
            buffer.append(",");
            String tagName = ((CVSTag)tag).getName();
            buffer.append(tagName);
        }
        return buffer.toString();
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        Policy.checkCanceled(monitor);
        HashMap<IProject, LoadInfo> infoMap = new HashMap<IProject, LoadInfo>(referenceStrings.length);
        IProject[] projects = CVSProjectSetCapability.asProjects(referenceStrings, infoMap);
        projects = this.confirmOverwrite(context, projects);
        if (projects == null || projects.length == 0) {
            return new IProject[0];
        }
        Map<IProject, List<ICVSRepositoryLocation>> suggestedRepositoryLocations = CVSRepositoryLocationMatcher.prepareSuggestedRepositoryLocations(projects, infoMap);
        this.applySinglePerfectMatchesToInfoMap(suggestedRepositoryLocations, infoMap);
        if (CVSRepositoryLocationMatcher.isPromptRequired(suggestedRepositoryLocations)) {
            Map userSelectedRepositoryLocations = this.promptForAdditionRepositoryInformation(suggestedRepositoryLocations);
            if (userSelectedRepositoryLocations != null) {
                this.applyUserSelectionToInfoMap(userSelectedRepositoryLocations, infoMap);
            } else {
                return new IProject[0];
            }
        }
        return this.checkout(projects, infoMap, monitor);
    }

    private void applySinglePerfectMatchesToInfoMap(Map suggestedRepositoryLocations, Map infoMap) throws CVSException {
        for (LoadInfo loadInfoForProject : infoMap.values()) {
            ICVSRepositoryLocation key = loadInfoForProject.repositoryLocation;
            List suggestedList = (List)suggestedRepositoryLocations.get(key);
            if (suggestedList == null || suggestedList.size() != 1 || !CVSRepositoryLocationMatcher.isMatching((ICVSRepositoryLocation)suggestedList.get(0), loadInfoForProject.repositoryLocation)) continue;
            loadInfoForProject.repositoryLocation = CVSProjectSetCapability.getRepositoryLocationFromString(loadInfoForProject.repositoryLocation.getLocation(true), true, false);
            suggestedRepositoryLocations.remove(key);
        }
    }

    private void applyUserSelectionToInfoMap(Map userSelectedRepositoryLocations, Map infoMap) throws CVSException {
        for (LoadInfo loadInfoForProject : infoMap.values()) {
            ICVSRepositoryLocation userSelectedRepository = (ICVSRepositoryLocation)userSelectedRepositoryLocations.get(loadInfoForProject.repositoryLocation);
            if (userSelectedRepository == null) continue;
            loadInfoForProject.repositoryLocation = userSelectedRepository;
        }
    }

    public static IProject[] asProjects(String[] referenceStrings, Map infoMap) throws CVSException {
        ArrayList<IProject> result = new ArrayList<IProject>();
        String[] stringArray = referenceStrings;
        int n = referenceStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceString = stringArray[n2];
            StringTokenizer tokenizer = new StringTokenizer(referenceString, ",");
            String version = tokenizer.nextToken();
            if (version.equals("1.0")) {
                LoadInfo info = new LoadInfo(tokenizer, false, false);
                IProject proj = info.getProject();
                result.add(proj);
                infoMap.put(proj, info);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private IProject[] checkout(IProject[] projects, Map infoMap, IProgressMonitor monitor) throws TeamException {
        ArrayList result = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(monitor1 -> {
                monitor1.beginTask("", 1000 * projects.length);
                try {
                    int i = 0;
                    while (i < projects.length) {
                        if (monitor1.isCanceled()) {
                            break;
                        }
                        IProject project = projects[i];
                        LoadInfo info = (LoadInfo)infoMap.get(project);
                        if (info != null && info.checkout((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor1, (int)1000))) {
                            result.add(project);
                        }
                        ++i;
                    }
                }
                finally {
                    monitor1.done();
                }
            }, CVSProjectSetCapability.getCheckoutRule(projects), 0, monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        return result.toArray(new IProject[result.size()]);
    }

    private static ICVSRepositoryLocation getRepositoryLocationFromString(String repo, boolean useKnown, boolean addIfNotFound) throws CVSException {
        CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString(repo);
        if (useKnown && (newLocation.getUsername() == null || newLocation.getUsername().length() == 0)) {
            ICVSRepositoryLocation[] locations;
            ICVSRepositoryLocation[] iCVSRepositoryLocationArray = locations = CVSProviderPlugin.getPlugin().getKnownRepositories();
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSRepositoryLocation location = iCVSRepositoryLocationArray[n2];
                if (CVSRepositoryLocationMatcher.isMatching(newLocation, location)) {
                    return location;
                }
                ++n2;
            }
        }
        if (addIfNotFound) {
            KnownRepositories.getInstance().addRepository(newLocation, true);
        }
        return newLocation;
    }

    public static void checkout(ICVSRepositoryLocation repository, IProject project, String sourceModule, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        if (sourceModule == null) {
            sourceModule = project.getName();
        }
        CVSProjectSetCapability.checkout(new ICVSRemoteFolder[]{new RemoteFolder(null, repository, sourceModule, tag)}, new IProject[]{project}, monitor);
    }

    public static void checkout(ICVSRemoteFolder[] resources, IProject[] projects, IProgressMonitor monitor) throws TeamException {
        TeamException[] eHolder = new TeamException[1];
        try {
            try {
                IWorkspaceRunnable workspaceRunnable = pm -> {
                    try {
                        try {
                            pm.beginTask(null, 1000 * resources.length);
                            ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                            int i = 0;
                            while (i < resources.length) {
                                IProject project = null;
                                RemoteFolder resource = (RemoteFolder)resources[i];
                                if (projects != null) {
                                    project = projects[i];
                                }
                                String moduleName = resource instanceof RemoteModule ? ((RemoteModule)resource).getName() : resource.getRepositoryRelativePath();
                                ICVSRepositoryLocation repository = resource.getRepository();
                                try (Session session = new Session(repository, root);){
                                    CVSTag tag;
                                    session.open(Policy.subMonitorFor(pm, 50), false);
                                    HashSet<IProject> targetProjects = new HashSet<IProject>();
                                    if (project == null) {
                                        IStatus status1 = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, Policy.subMonitorFor(pm, 50));
                                        if (status1.getCode() == -10) {
                                            throw new CVSServerException(status1);
                                        }
                                        String[] expansions = session.getModuleExpansions();
                                        int j = 0;
                                        while (j < expansions.length) {
                                            targetProjects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(null, expansions[j]).segment(0)));
                                            ++j;
                                        }
                                    } else {
                                        targetProjects.add(project);
                                    }
                                    root.run(monitor1 -> CVSProjectSetCapability.scrubProjects(targetProjects.toArray(new IProject[targetProjects.size()]), monitor1), Policy.subMonitorFor(pm, 100));
                                    ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                                    if (project != null) {
                                        localOptions.add(Checkout.makeDirectoryNameOption(project.getName()));
                                    }
                                    if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                                        localOptions.add(Command.PRUNE_EMPTY_DIRECTORIES);
                                    }
                                    if ((tag = resource.getTag()) == null) {
                                        tag = CVSTag.DEFAULT;
                                    }
                                    localOptions.add(Update.makeTagOption(tag));
                                    IStatus status2 = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{moduleName}, null, Policy.subMonitorFor(pm, 800));
                                    if (status2.getCode() == -10) {
                                        throw new CVSServerException(status2);
                                    }
                                    CVSProjectSetCapability.refreshProjects(targetProjects.toArray(new IProject[targetProjects.size()]), Policy.subMonitorFor(pm, 100));
                                }
                                ++i;
                            }
                        }
                        catch (TeamException e) {
                            teamExceptionArray[0] = e;
                            pm.done();
                        }
                    }
                    finally {
                        pm.done();
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceRunnable, CVSProjectSetCapability.getCheckoutRule(projects), 0, monitor);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
        if (eHolder[0] != null) {
            throw eHolder[0];
        }
    }

    private static ISchedulingRule getCheckoutRule(IProject[] projects) {
        if (projects.length == 1) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projects[0]);
        }
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ISchedulingRule modifyRule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
            if (modifyRule instanceof IResource && ((IResource)modifyRule).getType() == 8) {
                return modifyRule;
            }
            rules.add(modifyRule);
            ++n2;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    static void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException, TeamException {
        monitor.beginTask(CVSMessages.CVSProvider_Creating_projects_2, projects.length * 100);
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    static void scrubProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        if (projects == null) {
            monitor.done();
            return;
        }
        monitor.beginTask(CVSMessages.CVSProvider_Scrubbing_projects_1, projects.length * 100);
        try {
            try {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    File location;
                    IProject project = iProjectArray[n2];
                    if (project != null && project.exists()) {
                        if (!project.isOpen()) {
                            project.open(Policy.subMonitorFor(monitor, 10));
                        }
                        monitor.subTask(CVSMessages.CVSProvider_Scrubbing_local_project_1);
                        if (RepositoryProvider.getProvider((IProject)project) != null) {
                            RepositoryProvider.unmap((IProject)project);
                        }
                        IResource[] children = project.members(2);
                        IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 80);
                        subMonitor.beginTask(null, children.length * 100);
                        try {
                            IResource[] iResourceArray = children;
                            int n3 = children.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource c = iResourceArray[n4];
                                if (!c.getName().equals(".project")) {
                                    c.delete(true, Policy.subMonitorFor(subMonitor, 100));
                                }
                                ++n4;
                            }
                        }
                        finally {
                            subMonitor.done();
                        }
                    } else if (project != null && (location = new File(project.getParent().getLocation().toFile(), project.getName())).exists()) {
                        CVSProjectSetCapability.deepDelete(location);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void deepDelete(File resource) throws CVSException {
        if (resource.isDirectory()) {
            File[] fileList = resource.listFiles();
            if (fileList == null) {
                throw new CVSException("Content from directory '" + resource.getAbsolutePath() + "' can not be listed.");
            }
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                CVSProjectSetCapability.deepDelete(f);
                ++n2;
            }
        }
        resource.delete();
    }

    public String getProject(String referenceString) {
        StringTokenizer tokenizer = new StringTokenizer(referenceString, ",");
        String version = tokenizer.nextToken();
        if (!version.equals("1.0")) {
            return null;
        }
        try {
            LoadInfo info = new LoadInfo(tokenizer);
            return info.getProject().getName();
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    public URI getURI(String referenceString) {
        StringTokenizer tokenizer = new StringTokenizer(referenceString, ",");
        String version = tokenizer.nextToken();
        if (!version.equals("1.0")) {
            return null;
        }
        try {
            LoadInfo info = new LoadInfo(tokenizer);
            CVSURI cvsURI = new CVSURI(info.repositoryLocation, (IPath)new Path(info.module), info.tag);
            return cvsURI.toURI();
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    public String asReference(URI uri, String projectName) {
        ICVSRemoteFolder folder;
        ICVSRepositoryLocation location;
        block4: {
            try {
                CVSURI cvsURI = CVSURI.fromUri(uri);
                location = cvsURI.getRepository();
                folder = cvsURI.toFolder();
                if (projectName != null) break block4;
                projectName = cvsURI.getProjectName();
                if (projectName == null) {
                    projectName = cvsURI.getLastSegment();
                }
                if (projectName != null) break block4;
                return null;
            }
            catch (TeamException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return null;
            }
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return this.asReference((CVSRepositoryLocation)location, folder, project);
    }

    private Map promptForAdditionRepositoryInformation(Map alternativeMap) {
        IUserAuthenticator authenticator = CVSRepositoryLocation.getAuthenticator();
        return authenticator.promptToConfigureRepositoryLocations(alternativeMap);
    }

    static class LoadInfo {
        ICVSRepositoryLocation repositoryLocation;
        private final String module;
        private final IProject project;
        private final CVSTag tag;

        LoadInfo(StringTokenizer tokenizer, boolean useKnown, boolean addIfNotFound) throws CVSException {
            String repo = tokenizer.nextToken();
            this.repositoryLocation = CVSProjectSetCapability.getRepositoryLocationFromString(repo, useKnown, addIfNotFound);
            this.module = tokenizer.nextToken();
            String projectName = tokenizer.nextToken();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (tokenizer.hasMoreTokens()) {
                String tagName = tokenizer.nextToken();
                this.tag = new CVSTag(tagName, 1);
            } else {
                this.tag = null;
            }
        }

        LoadInfo(StringTokenizer tokenizer) throws CVSException {
            this(tokenizer, true, true);
        }

        private IProject getProject() {
            return this.project;
        }

        boolean checkout(IProgressMonitor monitor) throws TeamException {
            if (this.repositoryLocation == null) {
                return false;
            }
            CVSProjectSetCapability.checkout(this.repositoryLocation, this.project, this.module, this.tag, monitor);
            return true;
        }
    }
}

