/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class CVSTagElement
extends CVSModelElement
implements IDeferredWorkbenchAdapter {
    CVSTag tag;
    ICVSRepositoryLocation root;
    private static final String REPO_VIEW_LONG_FORAMT = "dd MMM yyyy HH:mm:ss";
    private static final String REPO_VIEW_SHORT_FORMAT = "dd MMM yyyy";
    private static final String TIME_ONLY_COLUMN_FORMAT = "HH:mm:ss";
    private static SimpleDateFormat localLongFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.getDefault());
    private static SimpleDateFormat localShortFormat = new SimpleDateFormat("dd MMM yyyy", Locale.getDefault());
    private static DateFormat localLongDateFormat = DateFormat.getDateTimeInstance((int)2, (int)2);
    private static DateFormat localShortDateFormat = DateFormat.getDateInstance((int)2);
    private static DateFormat localYearDateFormat = DateFormat.getInstanceForSkeleton((String)"y");
    private static SimpleDateFormat timeColumnFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());

    public static synchronized String toDisplayString(Date date) {
        String year = localYearDateFormat.format(date);
        boolean permitSimpleDateFormat = true;
        try {
            Integer.parseInt(year);
        }
        catch (NumberFormatException numberFormatException) {
            permitSimpleDateFormat = false;
        }
        Object selectedFormat = localLongFormat;
        if (!permitSimpleDateFormat) {
            selectedFormat = localLongDateFormat;
        }
        String localTime = timeColumnFormat.format(date);
        timeColumnFormat.setTimeZone(TimeZone.getDefault());
        if (localTime.equals("00:00:00")) {
            selectedFormat = permitSimpleDateFormat ? localShortFormat : localShortDateFormat;
        }
        return selectedFormat.format(date);
    }

    public CVSTagElement(CVSTag tag, ICVSRepositoryLocation root) {
        this.tag = tag;
        this.root = root;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return false;
        }
        CVSTagElement t = (CVSTagElement)o;
        if (!this.tag.equals((Object)t.tag)) {
            return false;
        }
        return this.root.equals(t.root);
    }

    public int hashCode() {
        return this.root.hashCode() ^ this.tag.hashCode();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (!(object instanceof CVSTagElement)) {
            return null;
        }
        if (this.tag.getType() == 1 || this.tag.getType() == 0) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/tag.gif");
        }
        if (this.tag.getType() == 2) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif");
        }
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/date.gif");
    }

    public String getLabel(Object o) {
        Date date;
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        CVSTag aTag = ((CVSTagElement)o).tag;
        if (aTag.getType() == 3 && (date = this.tag.asDate()) != null) {
            return CVSTagElement.toDisplayString(date);
        }
        return aTag.getName();
    }

    public String toString() {
        return this.tag.getName();
    }

    public Object getParent(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        return ((CVSTagElement)o).root;
    }

    @Override
    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        Object[] children = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(this.root, this.tag, monitor);
        if (this.getWorkingSet() != null) {
            children = CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(this.getWorkingSet(), (ICVSRemoteResource[])children);
        }
        return children;
    }

    /*
     * Exception decompiling
     */
    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ISchedulingRule getRule(Object element) {
        return new RepositoryLocationSchedulingRule(this.root);
    }

    public boolean isContainer() {
        return true;
    }
}

