/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class ConstructorAccessor
extends ExpressionAccessor {
    private final int m_index;
    private final String m_defaultSource;

    public ConstructorAccessor(int index, String defaultSource) {
        this.m_index = index;
        this.m_defaultSource = defaultSource;
    }

    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        ClassInstanceCreation creation = ((ConstructorCreationSupport)javaInfo.getCreationSupport()).getCreation();
        return DomGenerics.arguments(creation).get(this.m_index);
    }

    public boolean setExpression(final JavaInfo javaInfo, String source) throws Exception {
        Expression oldExpression;
        AstEditor editor;
        final String newSource = source != null ? source : this.m_defaultSource;
        if (newSource != null && !(editor = javaInfo.getEditor()).getSource((ASTNode)(oldExpression = this.getExpression(javaInfo))).equals(source)) {
            ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    javaInfo.replaceExpression(oldExpression, newSource);
                }
            });
            return true;
        }
        return false;
    }
}

