/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.tools;

import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.requests.SelectionRequest;
import org.eclipse.wb.gef.core.tools.TargetingTool;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.tools.MarqueeDragTracker;
import org.eclipse.wb.internal.gef.core.IRootContainer;

public class SelectionTool
extends TargetingTool {
    private Tool m_dragTracker;

    public void setDragTrackerTool(Tool dragTracker) {
        if (this.m_dragTracker != dragTracker) {
            if (this.m_dragTracker != null) {
                this.m_dragTracker.deactivate();
            }
            this.m_dragTracker = dragTracker;
            this.refreshCursor();
            if (this.m_dragTracker != null) {
                this.m_dragTracker.setDomain(this.getDomain());
                this.m_dragTracker.setViewer(this.getViewer());
                this.m_dragTracker.activate();
            }
        }
    }

    @Override
    public void deactivate() {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.deactivate();
            this.m_dragTracker = null;
        }
        super.deactivate();
    }

    @Override
    public void refreshCursor() {
        if (this.m_dragTracker == null) {
            super.refreshCursor();
        }
    }

    @Override
    protected void handleButtonDown(int button) {
        if (this.m_state == 1) {
            this.m_state = 2;
            if (this.m_dragTracker != null) {
                this.m_dragTracker.deactivate();
            }
            if ((this.m_stateMask & 0x10000) != 0) {
                this.setDragTrackerTool(new MarqueeDragTracker());
                return;
            }
            Handle handle = this.getViewer().findTargetHandle(this.m_currentScreenX, this.m_currentScreenY);
            if (handle != null) {
                this.setDragTrackerTool(handle.getDragTrackerTool());
                return;
            }
            this.updateTargetRequest();
            ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(button);
            this.updateTargetUnderMouse();
            EditPart editPart = this.getTargetEditPart();
            if (editPart == null) {
                this.setDragTrackerTool(null);
                this.getViewer().deselectAll();
            } else {
                this.setDragTrackerTool(editPart.getDragTrackerTool(this.getTargetRequest()));
                this.lockTargetEditPart(editPart);
            }
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(0);
        this.setDragTrackerTool(null);
        this.m_state = 1;
        this.unlockTargetEditPart();
    }

    @Override
    protected void handleMove() {
        if (this.m_state == 2) {
            this.m_state = 1;
            this.setDragTrackerTool(null);
        }
        if (this.m_state == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
        }
    }

    @Override
    protected void handleViewerExited() {
        if (this.m_state == 2 || this.m_state == 3) {
            Event event = new Event();
            event.x = this.m_currentScreenX;
            event.y = this.m_currentScreenY;
            event.stateMask = this.m_stateMask;
            event.button = this.m_button;
            event.widget = this.getViewer().getControl();
            this.mouseUp(new MouseEvent(event), this.getViewer());
        }
        super.handleViewerExited();
    }

    @Override
    protected Request createTargetRequest() {
        return new SelectionRequest("selection");
    }

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        SelectionRequest request = (SelectionRequest)this.getTargetRequest();
        request.setLocation(this.getLocation());
    }

    @Override
    protected IEditPartViewer.IConditional getTargetingConditional() {
        return new IEditPartViewer.IConditional(){

            @Override
            public boolean evaluate(EditPart editPart) {
                return editPart.isSelectable();
            }
        };
    }

    @Override
    public void mouseDown(MouseEvent event, IEditPartViewer viewer) {
        super.mouseDown(event, viewer);
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDown(event, viewer);
        }
    }

    @Override
    public void mouseUp(MouseEvent event, IEditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseUp(event, viewer);
        }
        super.mouseUp(event, viewer);
    }

    @Override
    public void mouseDrag(MouseEvent event, IEditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDrag(event, viewer);
        }
        super.mouseDrag(event, viewer);
    }

    @Override
    public void mouseMove(MouseEvent event, IEditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseMove(event, viewer);
        }
        super.mouseMove(event, viewer);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event, IEditPartViewer viewer) {
        super.mouseDoubleClick(event, viewer);
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDoubleClick(event, viewer);
        }
    }

    @Override
    public void keyPressed(KeyEvent event, IEditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.keyPressed(event, viewer);
        } else {
            List<EditPart> selection = viewer.getSelectedEditParts();
            if (event.keyCode == 27) {
                EditPart part;
                EditPart parent;
                if (!selection.isEmpty() && (parent = (part = selection.get(0)).getParent()) != null && !(parent instanceof IRootContainer)) {
                    viewer.select(parent);
                }
            } else {
                SelectionTool.handleKeyEvent(true, event, selection);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event, IEditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.keyReleased(event, viewer);
        } else if (event.keyCode != 27) {
            SelectionTool.handleKeyEvent(false, event, viewer.getSelectedEditParts());
        }
    }

    private static void handleKeyEvent(boolean pressed, KeyEvent event, List<EditPart> selection) {
        KeyRequest request = new KeyRequest(pressed, event);
        for (EditPart part : selection) {
            part.performRequest(request);
        }
    }
}

