/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Endpoint;
import org.mandas.docker.client.messages.swarm.EndpointSpec;
import org.mandas.docker.client.messages.swarm.EndpointVirtualIp;
import org.mandas.docker.client.messages.swarm.PortConfig;

final class ImmutableEndpoint
implements Endpoint {
    private final EndpointSpec spec;
    @Nullable
    private final List<PortConfig> exposedPorts;
    @Nullable
    private final List<PortConfig> ports;
    @Nullable
    private final List<EndpointVirtualIp> virtualIps;

    private ImmutableEndpoint(EndpointSpec spec, @Nullable List<PortConfig> exposedPorts, @Nullable List<PortConfig> ports, @Nullable List<EndpointVirtualIp> virtualIps) {
        this.spec = spec;
        this.exposedPorts = exposedPorts;
        this.ports = ports;
        this.virtualIps = virtualIps;
    }

    @Override
    @JsonProperty(value="Spec")
    public EndpointSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="ExposedPorts")
    @Nullable
    public List<PortConfig> exposedPorts() {
        return this.exposedPorts;
    }

    @Override
    @JsonProperty(value="Ports")
    @Nullable
    public List<PortConfig> ports() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="VirtualIPs")
    @Nullable
    public List<EndpointVirtualIp> virtualIps() {
        return this.virtualIps;
    }

    public final ImmutableEndpoint withSpec(EndpointSpec value) {
        if (this.spec == value) {
            return this;
        }
        EndpointSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableEndpoint(newValue, this.exposedPorts, this.ports, this.virtualIps);
    }

    public final ImmutableEndpoint withExposedPorts(PortConfig ... elements) {
        if (elements == null) {
            return new ImmutableEndpoint(this.spec, null, this.ports, this.virtualIps);
        }
        List<PortConfig> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpoint(this.spec, newValue, this.ports, this.virtualIps);
    }

    public final ImmutableEndpoint withExposedPorts(@Nullable Iterable<? extends PortConfig> elements) {
        if (this.exposedPorts == elements) {
            return this;
        }
        List<PortConfig> newValue = elements == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(elements, true, false));
        return new ImmutableEndpoint(this.spec, newValue, this.ports, this.virtualIps);
    }

    public final ImmutableEndpoint withPorts(PortConfig ... elements) {
        if (elements == null) {
            return new ImmutableEndpoint(this.spec, this.exposedPorts, null, this.virtualIps);
        }
        List<PortConfig> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpoint(this.spec, this.exposedPorts, newValue, this.virtualIps);
    }

    public final ImmutableEndpoint withPorts(@Nullable Iterable<? extends PortConfig> elements) {
        if (this.ports == elements) {
            return this;
        }
        List<PortConfig> newValue = elements == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(elements, true, false));
        return new ImmutableEndpoint(this.spec, this.exposedPorts, newValue, this.virtualIps);
    }

    public final ImmutableEndpoint withVirtualIps(EndpointVirtualIp ... elements) {
        if (elements == null) {
            return new ImmutableEndpoint(this.spec, this.exposedPorts, this.ports, null);
        }
        List<EndpointVirtualIp> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpoint(this.spec, this.exposedPorts, this.ports, newValue);
    }

    public final ImmutableEndpoint withVirtualIps(@Nullable Iterable<? extends EndpointVirtualIp> elements) {
        if (this.virtualIps == elements) {
            return this;
        }
        List<EndpointVirtualIp> newValue = elements == null ? null : ImmutableEndpoint.createUnmodifiableList(false, ImmutableEndpoint.createSafeList(elements, true, false));
        return new ImmutableEndpoint(this.spec, this.exposedPorts, this.ports, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEndpoint && this.equalTo((ImmutableEndpoint)another);
    }

    private boolean equalTo(ImmutableEndpoint another) {
        return this.spec.equals(another.spec) && Objects.equals(this.exposedPorts, another.exposedPorts) && Objects.equals(this.ports, another.ports) && Objects.equals(this.virtualIps, another.virtualIps);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + Objects.hashCode(this.exposedPorts);
        h += (h << 5) + Objects.hashCode(this.ports);
        h += (h << 5) + Objects.hashCode(this.virtualIps);
        return h;
    }

    public String toString() {
        return "Endpoint{spec=" + this.spec + ", exposedPorts=" + this.exposedPorts + ", ports=" + this.ports + ", virtualIps=" + this.virtualIps + "}";
    }

    public static ImmutableEndpoint copyOf(Endpoint instance) {
        if (instance instanceof ImmutableEndpoint) {
            return (ImmutableEndpoint)instance;
        }
        return ImmutableEndpoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_SPEC = 1L;
        private long initBits = 1L;
        private EndpointSpec spec;
        private List<PortConfig> exposedPorts = null;
        private List<PortConfig> ports = null;
        private List<EndpointVirtualIp> virtualIps = null;

        private Builder() {
        }

        public final Builder from(Endpoint instance) {
            List<EndpointVirtualIp> virtualIpsValue;
            List<PortConfig> portsValue;
            Objects.requireNonNull(instance, "instance");
            this.spec(instance.spec());
            List<PortConfig> exposedPortsValue = instance.exposedPorts();
            if (exposedPortsValue != null) {
                this.addAllExposedPorts(exposedPortsValue);
            }
            if ((portsValue = instance.ports()) != null) {
                this.addAllPorts(portsValue);
            }
            if ((virtualIpsValue = instance.virtualIps()) != null) {
                this.addAllVirtualIps(virtualIpsValue);
            }
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(EndpointSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder exposedPort(PortConfig element) {
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<PortConfig>();
            }
            this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
            return this;
        }

        public final Builder exposedPorts(PortConfig ... elements) {
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<PortConfig>();
            }
            for (PortConfig element : elements) {
                this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
            }
            return this;
        }

        @JsonProperty(value="ExposedPorts")
        public final Builder exposedPorts(@Nullable Iterable<? extends PortConfig> elements) {
            if (elements == null) {
                this.exposedPorts = null;
                return this;
            }
            this.exposedPorts = new ArrayList<PortConfig>();
            return this.addAllExposedPorts(elements);
        }

        public final Builder addAllExposedPorts(Iterable<? extends PortConfig> elements) {
            Objects.requireNonNull(elements, "exposedPorts element");
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<PortConfig>();
            }
            for (PortConfig portConfig : elements) {
                this.exposedPorts.add(Objects.requireNonNull(portConfig, "exposedPorts element"));
            }
            return this;
        }

        public final Builder port(PortConfig element) {
            if (this.ports == null) {
                this.ports = new ArrayList<PortConfig>();
            }
            this.ports.add(Objects.requireNonNull(element, "ports element"));
            return this;
        }

        public final Builder ports(PortConfig ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<PortConfig>();
            }
            for (PortConfig element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        @JsonProperty(value="Ports")
        public final Builder ports(@Nullable Iterable<? extends PortConfig> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<PortConfig>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<? extends PortConfig> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<PortConfig>();
            }
            for (PortConfig portConfig : elements) {
                this.ports.add(Objects.requireNonNull(portConfig, "ports element"));
            }
            return this;
        }

        public final Builder virtualIp(EndpointVirtualIp element) {
            if (this.virtualIps == null) {
                this.virtualIps = new ArrayList<EndpointVirtualIp>();
            }
            this.virtualIps.add(Objects.requireNonNull(element, "virtualIps element"));
            return this;
        }

        public final Builder virtualIps(EndpointVirtualIp ... elements) {
            if (this.virtualIps == null) {
                this.virtualIps = new ArrayList<EndpointVirtualIp>();
            }
            for (EndpointVirtualIp element : elements) {
                this.virtualIps.add(Objects.requireNonNull(element, "virtualIps element"));
            }
            return this;
        }

        @JsonProperty(value="VirtualIPs")
        public final Builder virtualIps(@Nullable Iterable<? extends EndpointVirtualIp> elements) {
            if (elements == null) {
                this.virtualIps = null;
                return this;
            }
            this.virtualIps = new ArrayList<EndpointVirtualIp>();
            return this.addAllVirtualIps(elements);
        }

        public final Builder addAllVirtualIps(Iterable<? extends EndpointVirtualIp> elements) {
            Objects.requireNonNull(elements, "virtualIps element");
            if (this.virtualIps == null) {
                this.virtualIps = new ArrayList<EndpointVirtualIp>();
            }
            for (EndpointVirtualIp endpointVirtualIp : elements) {
                this.virtualIps.add(Objects.requireNonNull(endpointVirtualIp, "virtualIps element"));
            }
            return this;
        }

        public ImmutableEndpoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEndpoint(this.spec, this.exposedPorts == null ? null : ImmutableEndpoint.createUnmodifiableList(true, this.exposedPorts), this.ports == null ? null : ImmutableEndpoint.createUnmodifiableList(true, this.ports), this.virtualIps == null ? null : ImmutableEndpoint.createUnmodifiableList(true, this.virtualIps));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spec");
            }
            return "Cannot build Endpoint, some of required attributes are not set " + attributes;
        }
    }
}

