/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.EnginePlugin;

final class ImmutableEnginePlugin
implements EnginePlugin {
    private final String type;
    private final String name;

    private ImmutableEnginePlugin(String type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    @JsonProperty(value="Type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    public final ImmutableEnginePlugin withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableEnginePlugin(newValue, this.name);
    }

    public final ImmutableEnginePlugin withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableEnginePlugin(this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEnginePlugin && this.equalTo((ImmutableEnginePlugin)another);
    }

    private boolean equalTo(ImmutableEnginePlugin another) {
        return this.type.equals(another.type) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "EnginePlugin{type=" + this.type + ", name=" + this.name + "}";
    }

    public static ImmutableEnginePlugin copyOf(EnginePlugin instance) {
        if (instance instanceof ImmutableEnginePlugin) {
            return (ImmutableEnginePlugin)instance;
        }
        return ImmutableEnginePlugin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private String type;
        private String name;

        private Builder() {
        }

        public final Builder from(EnginePlugin instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.name(instance.name());
            return this;
        }

        @JsonProperty(value="Type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEnginePlugin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEnginePlugin(this.type, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build EnginePlugin, some of required attributes are not set " + attributes;
        }
    }
}

