/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;

public interface SftpFileSystemAccessor {
    public static final List<String> DEFAULT_UNIX_VIEW = Collections.singletonList("unix:*");
    public static final NavigableMap<String, FileInfoExtractor<?>> FILEATTRS_RESOLVERS = MapEntryUtils.NavigableMapBuilder.builder((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)"isRegularFile", (Object)FileInfoExtractor.ISREG).put((Object)"isDirectory", (Object)FileInfoExtractor.ISDIR).put((Object)"isSymbolicLink", (Object)FileInfoExtractor.ISSYMLINK).put((Object)"permissions", (Object)FileInfoExtractor.PERMISSIONS).put((Object)"size", (Object)FileInfoExtractor.SIZE).put((Object)"lastModifiedTime", (Object)FileInfoExtractor.LASTMODIFIED).immutable();
    public static final String PROP_AUTO_SYNC_FILE_ON_CLOSE = "sftp-auto-fsync-on-close";
    public static final boolean DEFAULT_AUTO_SYNC_FILE_ON_CLOSE = true;
    public static final SftpFileSystemAccessor DEFAULT = new SftpFileSystemAccessor(){

        public String toString() {
            return SftpFileSystemAccessor.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public SeekableByteChannel openFile(ServerSession session, SftpEventListenerManager subsystem, FileHandle fileHandle, Path file, String handle, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            attrs = IoUtils.EMPTY_FILE_ATTRIBUTES;
        }
        return FileChannel.open(file, options, attrs);
    }

    default public FileLock tryLock(ServerSession session, SftpEventListenerManager subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, long position, long size, boolean shared) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to lock: " + channel);
        }
        return ((FileChannel)channel).lock(position, size, shared);
    }

    default public void syncFileData(ServerSession session, SftpEventListenerManager subsystem, FileHandle fileHandle, Path file, String handle, Channel channel) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to sync: " + channel);
        }
        ((FileChannel)channel).force(true);
    }

    default public void closeFile(ServerSession session, SftpEventListenerManager subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, Set<? extends OpenOption> options) throws IOException {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (channel instanceof FileChannel && GenericUtils.containsAny(options, (Iterable)IoUtils.WRITEABLE_OPEN_OPTIONS) && PropertyResolverUtils.getBooleanProperty((PropertyResolver)session, (String)PROP_AUTO_SYNC_FILE_ON_CLOSE, (boolean)true)) {
            ((FileChannel)channel).force(true);
        }
        channel.close();
    }

    default public DirectoryStream<Path> openDirectory(ServerSession session, SftpEventListenerManager subsystem, DirectoryHandle dirHandle, Path dir, String handle) throws IOException {
        return Files.newDirectoryStream(dir);
    }

    default public void closeDirectory(ServerSession session, SftpEventListenerManager subsystem, DirectoryHandle dirHandle, Path dir, String handle, DirectoryStream<Path> ds) throws IOException {
        if (ds == null) {
            return;
        }
        ds.close();
    }
}

