/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.bpel.ui.editparts.CollapsableEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.events.KeyEvent;

public class BPELGraphicalKeyHandler
extends KeyHandler {
    int counter;
    private WeakReference<GraphicalEditPart> cachedNode;
    private GraphicalViewer viewer;

    public BPELGraphicalKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    private boolean acceptConnection(KeyEvent event) {
        return event.character == '/' || event.character == '?' || event.character == '\\' || event.character == '\u001c' || event.character == '|';
    }

    private boolean acceptIntoContainer(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000002;
    }

    private boolean acceptLeaveConnection(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocus() instanceof ConnectionEditPart && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    private boolean acceptLeaveContents(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocus() == this.getViewer().getContents() && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    private boolean acceptOutOf(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001;
    }

    private ConnectionEditPart findConnection(GraphicalEditPart node, ConnectionEditPart current, boolean forward) {
        ArrayList connections = new ArrayList(node.getSourceConnections());
        connections.addAll(node.getTargetConnections());
        if (connections.isEmpty()) {
            return null;
        }
        this.counter = forward ? ++this.counter : --this.counter;
        while (this.counter < 0) {
            this.counter += connections.size();
        }
        this.counter %= connections.size();
        return (ConnectionEditPart)connections.get(this.counter % connections.size());
    }

    private GraphicalEditPart findSibling(List<GraphicalEditPart> siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        int distance = Integer.MAX_VALUE;
        for (GraphicalEditPart epCurrent : siblings) {
            int d;
            if (epCurrent == exclude || !epCurrent.isSelectable()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction || (d = pCurrent.getDistanceOrthogonal(pStart)) >= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        return epFinal;
    }

    Point getInterestingPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    private GraphicalEditPart getCachedNode() {
        if (this.cachedNode == null) {
            return null;
        }
        if (this.cachedNode.isEnqueued()) {
            return null;
        }
        return (GraphicalEditPart)this.cachedNode.get();
    }

    protected GraphicalEditPart getFocus() {
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.character == ' ') {
            this.processSelect(event);
            return true;
        }
        if (this.acceptIntoContainer(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (this.acceptOutOf(event)) {
            this.navigateOut(event);
            return true;
        }
        if (this.acceptConnection(event)) {
            this.navigateConnections(event);
            return true;
        }
        if (this.acceptScroll(event)) {
            this.scrollViewer(event);
            return true;
        }
        if (this.acceptLeaveConnection(event)) {
            this.navigateOutOfConnection(event);
            return true;
        }
        if (this.acceptLeaveContents(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (event.character == '[') {
            int found = -1;
            List<GraphicalEditPart> list = this.getProcessNavigationList();
            int i = 0;
            while (i < list.size()) {
                if (this.getFocus() == list.get(i)) {
                    found = i;
                    break;
                }
                ++i;
            }
            if (found >= 0) {
                --found;
            }
            if (found >= 0) {
                EditPart navigateTo = (EditPart)list.get(found);
                this.navigateTo(navigateTo, event);
            }
        } else if (event.character == ']') {
            int found = -1;
            List<GraphicalEditPart> list = this.getProcessNavigationList();
            int i = 0;
            while (i < list.size()) {
                if (this.getFocus() == list.get(i)) {
                    found = i;
                    break;
                }
                ++i;
            }
            if (found >= 0) {
                ++found;
            }
            if (found < list.size()) {
                EditPart navigateTo = (EditPart)list.get(found);
                this.navigateTo(navigateTo, event);
            }
        } else if (event.character == '+' || event.character == '=') {
            this.expand(event);
        } else if (event.character == '-') {
            this.collapse(event);
        }
        switch (event.keyCode) {
            case 0x1000003: {
                if (!this.navigateNextSibling(event, 8)) break;
                return true;
            }
            case 0x1000004: {
                if (!this.navigateNextSibling(event, 16)) break;
                return true;
            }
            case 0x1000001: {
                if (!this.navigateNextSibling(event, 1)) break;
                return true;
            }
            case 0x1000002: {
                if (!this.navigateNextSibling(event, 4)) break;
                return true;
            }
            case 0x1000007: {
                if (!this.navigateJumpSibling(event, 8)) break;
                return true;
            }
            case 0x1000008: {
                if (!this.navigateJumpSibling(event, 16)) break;
                return true;
            }
            case 0x1000006: {
                if (!this.navigateJumpSibling(event, 4)) break;
                return true;
            }
            case 0x1000005: {
                if (!this.navigateJumpSibling(event, 1)) break;
                return true;
            }
            case 9: {
                return true;
            }
            case 0x100000B: {
                this.activateDirectEdit(event);
            }
        }
        return super.keyPressed(event);
    }

    private void navigateConnections(KeyEvent event) {
        GraphicalEditPart focus = this.getFocus();
        ConnectionEditPart current = null;
        GraphicalEditPart node = this.getCachedNode();
        if (focus instanceof ConnectionEditPart) {
            current = (ConnectionEditPart)focus;
            if (node == null || node != current.getSource() && node != current.getTarget()) {
                node = (GraphicalEditPart)current.getSource();
                this.counter = 0;
            }
        } else {
            node = focus;
        }
        this.setCachedNode(node);
        boolean forward = event.character == '/' || event.character == '?';
        ConnectionEditPart next = this.findConnection(node, current, forward);
        this.navigateTo((EditPart)next, event);
    }

    private void navigateIntoContainer(KeyEvent event) {
        GraphicalEditPart focus = this.getFocus();
        List<GraphicalEditPart> childList = this.getNavigationChildren((EditPart)focus);
        Point tl = focus.getContentPane().getBounds().getTopLeft();
        int minimum = Integer.MAX_VALUE;
        GraphicalEditPart closestPart = null;
        int i = 0;
        while (i < childList.size()) {
            GraphicalEditPart ged = childList.get(i);
            if (ged.isSelectable()) {
                Rectangle childBounds = ged.getFigure().getBounds();
                int current = childBounds.x - tl.x + (childBounds.y - tl.y);
                if (current < minimum) {
                    minimum = current;
                    closestPart = ged;
                }
            }
            ++i;
        }
        if (closestPart != null) {
            this.navigateTo((EditPart)closestPart, event);
        }
    }

    private boolean navigateJumpSibling(KeyEvent event, int direction) {
        return false;
    }

    private boolean navigateNextSibling(KeyEvent event, int direction) {
        return this.navigateNextSibling(event, direction, this.getNavigationSiblings());
    }

    boolean navigateNextSibling(KeyEvent event, int direction, List<GraphicalEditPart> list) {
        GraphicalEditPart epStart = this.getFocus();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart next = this.findSibling(list, pStart, direction, (EditPart)epStart);
        if (next == null) {
            return false;
        }
        this.navigateTo((EditPart)next, event);
        return true;
    }

    private void navigateOut(KeyEvent event) {
        EditPart parent = this.getNavigationParent((EditPart)this.getFocus());
        if (this.getFocus() == null || this.getFocus() == this.getViewer().getContents() || this.getFocus().getParent() == this.getViewer().getContents()) {
            return;
        }
        this.navigateTo(parent, event);
    }

    private void navigateOutOfConnection(KeyEvent event) {
        GraphicalEditPart cached = this.getCachedNode();
        ConnectionEditPart conn = (ConnectionEditPart)this.getFocus();
        if (cached != null && (cached == conn.getSource() || cached == conn.getTarget())) {
            this.navigateTo((EditPart)cached, event);
        } else {
            this.navigateTo(conn.getSource(), event);
        }
    }

    void navigateTo(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
        this.getViewer().reveal(part);
    }

    private void processSelect(KeyEvent event) {
        EditPart part = this.getViewer().getFocusEditPart();
        if ((event.stateMask & 0x40000) != 0 && part.getSelected() != 0) {
            this.getViewer().deselect(part);
        } else {
            this.getViewer().appendSelection(part);
        }
        this.getViewer().setFocus(part);
    }

    private void expand(KeyEvent event) {
        EditPart part = this.getViewer().getFocusEditPart();
        if (part instanceof CollapsableEditPart) {
            ((CollapsableEditPart)part).setCollapsed(false);
        }
    }

    private void collapse(KeyEvent event) {
        EditPart part = this.getViewer().getFocusEditPart();
        if (part instanceof CollapsableEditPart) {
            ((CollapsableEditPart)part).setCollapsed(true);
        }
    }

    private void setCachedNode(GraphicalEditPart node) {
        this.cachedNode = node == null ? null : new WeakReference<GraphicalEditPart>(node);
    }

    protected List<GraphicalEditPart> getNavigationChildren(EditPart part) {
        return part.getChildren();
    }

    protected List<GraphicalEditPart> getNavigationSiblings() {
        EditPart focus = this.getFocus().getParent();
        return focus.getChildren();
    }

    protected EditPart getNavigationParent(EditPart part) {
        EditPart parent = part.getParent();
        if (parent instanceof ProcessEditPart) {
            return null;
        }
        return parent;
    }

    protected void addChildren(EditPart part, List<GraphicalEditPart> list) {
        List children = part.getChildren();
        int i = 0;
        while (i < children.size()) {
            list.add((GraphicalEditPart)children.get(i));
            this.addChildren((EditPart)children.get(i), list);
            ++i;
        }
    }

    protected List<GraphicalEditPart> getProcessNavigationList() {
        ProcessEditPart process = (ProcessEditPart)this.viewer.getContents();
        Vector<GraphicalEditPart> all = new Vector<GraphicalEditPart>();
        this.addChildren((EditPart)process, all);
        return all;
    }

    protected boolean activateDirectEdit(KeyEvent event) {
        GraphicalEditPart currentPart = (GraphicalEditPart)this.viewer.getFocusEditPart();
        currentPart.performRequest((Request)new DirectEditRequest());
        return true;
    }

    boolean acceptScroll(KeyEvent event) {
        return (event.stateMask & 0x40000) != 0 && (event.stateMask & 0x20000) != 0 && (event.keyCode == 0x1000002 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 0x1000001);
    }

    void scrollViewer(KeyEvent event) {
        if (!(this.getViewer().getControl() instanceof FigureCanvas)) {
            return;
        }
        FigureCanvas figCanvas = (FigureCanvas)this.getViewer().getControl();
        Point loc = figCanvas.getViewport().getViewLocation();
        Rectangle area = figCanvas.getViewport().getClientArea(Rectangle.SINGLETON).scale(0.1);
        switch (event.keyCode) {
            case 0x1000002: {
                figCanvas.scrollToY(loc.y + area.height);
                break;
            }
            case 0x1000001: {
                figCanvas.scrollToY(loc.y - area.height);
                break;
            }
            case 0x1000003: {
                figCanvas.scrollToX(loc.x - area.width);
                break;
            }
            case 0x1000004: {
                figCanvas.scrollToX(loc.x + area.width);
            }
        }
    }
}

