/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters;

import java.util.ArrayList;
import org.eclipse.bpel.model.adapters.AbstractStatefulAdapter;
import org.eclipse.bpel.ui.adapters.AdapterNotification;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;

public class MarkerHolderAdapter
extends AbstractStatefulAdapter
implements IMarkerHolder,
AdapterNotification {
    UniqueMarkers fMarkers = new UniqueMarkers();
    static IMarker[] EMPTY_MARKERS = new IMarker[0];

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getEventType()) {
            case 2100: {
                this.fMarkers.clear();
                break;
            }
            case 2102: {
                this.fMarkers.add((IMarker)notification.getNewValue());
                break;
            }
            case 2103: {
                this.fMarkers.remove(notification.getOldValue());
            }
        }
    }

    @Override
    public IMarker[] getMarkers(Object object) {
        if (this.fMarkers.size() == 0) {
            return EMPTY_MARKERS;
        }
        UniqueMarkers removed = new UniqueMarkers();
        for (IMarker m : this.fMarkers) {
            if (m.exists()) continue;
            removed.add(m);
        }
        this.fMarkers.removeAll(removed);
        return this.fMarkers.toArray(EMPTY_MARKERS);
    }

    private class UniqueMarkers
    extends ArrayList<IMarker> {
        private UniqueMarkers() {
        }

        @Override
        public boolean add(IMarker e) {
            int i = 0;
            while (i < this.size()) {
                IMarker m = (IMarker)this.get(i);
                if (m.getId() == e.getId()) {
                    return false;
                }
                ++i;
            }
            return super.add(e);
        }
    }
}

