/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.HashSet;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;

public class ReplaceInContainerCommand
extends AutoUndoCommand {
    IContainer container;
    protected boolean isExecuted;
    protected boolean isUndone;
    private Object parent;
    private Activity oldActivity;
    private Activity newActivity;

    public ReplaceInContainerCommand(Object parent, Object oldElement, Object newElement) {
        super(Messages.ReplaceInContainerCommand_Replace_1, (EObject)parent);
        this.parent = parent;
        this.container = BPELUtil.adapt(parent, IContainer.class);
        this.oldActivity = (Activity)oldElement;
        this.newActivity = (Activity)newElement;
    }

    private void copyAttributes() {
        try {
            this.newActivity.setName(this.oldActivity.getName());
        }
        catch (NullPointerException e) {
            BPELUIPlugin.log(e);
        }
        if (this.oldActivity.isSetSuppressJoinFailure()) {
            this.newActivity.setSuppressJoinFailure(this.oldActivity.getSuppressJoinFailure());
        }
        this.newActivity.setDocumentationElement(this.oldActivity.getDocumentationElement());
        this.newActivity.setEnclosingDefinition(this.oldActivity.getEnclosingDefinition());
        try {
            ModelHelper.setCreateInstance(this.newActivity, ModelHelper.getCreateInstance(this.oldActivity));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    public void doExecute() {
        Targets t;
        if (!this.canExecute()) {
            throw new IllegalStateException();
        }
        this.isExecuted = true;
        this.copyAttributes();
        Sources s = this.oldActivity.getSources();
        if (s != null) {
            Source[] sources = (Source[])s.getChildren().toArray((Object[])new Source[0]);
            int i = 0;
            while (i < sources.length) {
                sources[i].setActivity(this.newActivity);
                ++i;
            }
        }
        if ((t = this.oldActivity.getTargets()) != null) {
            Target[] targets = (Target[])t.getChildren().toArray((Object[])new Target[0]);
            int i = 0;
            while (i < targets.length) {
                targets[i].setActivity(this.newActivity);
                ++i;
            }
            Condition joinCondition = t.getJoinCondition();
            if (joinCondition != null) {
                this.newActivity.getTargets().setJoinCondition(joinCondition);
            }
        }
        this.container.replaceChild(this.parent, this.oldActivity, this.newActivity);
        if (ModelHelper.getExtension((EObject)this.oldActivity) != null) {
            ModelHelper.setLocation(this.newActivity, ModelHelper.getLocation(this.oldActivity));
            ModelHelper.setSize(this.newActivity, ModelHelper.getSize(this.oldActivity));
        }
        HashSet<Object> deletingSet = new HashSet<Object>();
        ModelHelper.addSubtreeToCollection(this.oldActivity, deletingSet);
    }
}

