/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class XPathCodeReader {
    public static final int EOF = -1;
    private boolean fSkipStrings = false;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipStrings) {
        this.fDocument = document;
        this.fOffset = offset;
        this.fSkipStrings = skipStrings;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + length);
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipStrings) throws IOException {
        this.fDocument = document;
        this.fOffset = offset;
        this.fSkipStrings = skipStrings;
        this.fForward = false;
        try {
            this.fDocument.getLineOfOffset(this.fOffset);
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    public void close() {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    private void gotoStringEnd(char delimiter) throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char current;
            if ((current = this.fDocument.getChar(this.fOffset++)) == '\\') {
                ++this.fOffset;
                continue;
            }
            if (current != delimiter) continue;
            return;
        }
    }

    private void gotoLineEnd() throws BadLocationException {
        int line = this.fDocument.getLineOfOffset(this.fOffset);
        this.fOffset = this.fDocument.getLineOffset(line + 1);
    }

    private int readForwards() throws BadLocationException {
        while (this.fOffset < this.fEnd) {
            char current = this.fDocument.getChar(this.fOffset++);
            switch (current) {
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        this.gotoStringEnd(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    private void gotoStringStart(char delimiter) throws BadLocationException {
        while (this.fOffset > 0) {
            char current = this.fDocument.getChar(this.fOffset);
            if (current == delimiter && (this.fOffset < 0 || this.fDocument.getChar(this.fOffset - 1) != '\\')) {
                return;
            }
            --this.fOffset;
        }
    }

    private int readBackwards() throws BadLocationException {
        while (this.fOffset > 0) {
            --this.fOffset;
            char current = this.fDocument.getChar(this.fOffset);
            switch (current) {
                case '\"': 
                case '\'': {
                    if (this.fSkipStrings) {
                        --this.fOffset;
                        this.gotoStringStart(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }
}

