/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CValidator;

public class CActivityValidator
extends CValidator {
    protected String ncName;
    protected String fSuppressJoinFailre;
    protected List<INode> fCorrelationSets;
    public static IFilter<INode> PARENTS = Filters.ACTIVITY_CONTAINER;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_TARGETS, 0, 1);
        this.checkChild(ND_SOURCES, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
        if (this.ncName == null) {
            this.ncName = "Unnamed";
        }
        this.fCorrelationSets = new ArrayList<INode>();
        this.setValue("correlation.sets", this.fCorrelationSets);
    }

    @ARule(date="10/05/2006", desc="Check the name of the activity which must be valid NCName", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_NAME);
    }

    @ARule(date="10/05/2006", desc="Check the supressJoinFailure attribute.  It checks if it is set and has a value of yes or no.", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckSuppressJoinFailure_1() {
        this.fSuppressJoinFailre = this.getAttribute(this.mNode, AT_SUPPRESS_JOIN_FAILURE, 1, Filters.BOOLEAN_FILTER, false);
        if (CActivityValidator.isEmpty(this.fSuppressJoinFailre)) {
            INode parent = this.fParentNode;
            while (parent != null && CActivityValidator.isEmpty(this.fSuppressJoinFailre)) {
                this.fSuppressJoinFailre = this.getValue(parent, AT_SUPPRESS_JOIN_FAILURE, null);
                parent = parent.parentNode();
            }
        }
        this.setValue(AT_SUPPRESS_JOIN_FAILURE, this.fSuppressJoinFailre);
    }

    public void checkStartActivityPositioning() {
        INode context = this.mNode;
        INode parent = context.parentNode();
        boolean bSequenceChecked = false;
        while (parent != null) {
            QName pnn = parent.nodeName();
            if (!ND_FLOW.equals(pnn) && !ND_SCOPE.equals(pnn)) {
                IProblem problem;
                if (ND_PROCESS.equals(pnn)) break;
                if (ND_SEQUENCE.equals(pnn)) {
                    if (!bSequenceChecked) {
                        List<INode> nodes = mSelector.selectNodes(parent, "*", Filters.ACTIVITIES);
                        int index = nodes.indexOf(context) + 1;
                        if (index != 1) {
                            problem = this.createError();
                            problem.fill("BPELC__START_ACTIVITY", this.toString(this.mNode.nodeName()), index);
                        }
                        bSequenceChecked = true;
                    }
                } else {
                    problem = this.createError();
                    problem.fill("BPELC__START_ACTIVITY", this.toString(this.mNode.nodeName()), -1);
                }
            }
            context = parent;
            parent = context.parentNode();
        }
    }
}

