/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.INamespaceMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jdt.core.IType;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class NamespaceUtil {
    public static Map<String, String> getXMLNSPrefixMap(Resource resource) {
        EList contents;
        if (resource != null && !(contents = resource.getContents()).isEmpty() && contents.get(0) instanceof DocumentRoot) {
            return ((DocumentRoot)contents.get(0)).getXMLNSPrefixMap();
        }
        return null;
    }

    public static String getNamespaceForPrefix(Resource resource, String prefix) {
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            return map.get(prefix);
        }
        return null;
    }

    public static String getPrefixForNamespace(Resource resource, String namespace) {
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                String value = e.getValue();
                if (value == null || !value.equals(namespace)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    public static String normalizeQName(Resource resource, QName qname) {
        String localPart = qname.getLocalPart();
        String namespace = qname.getNamespaceURI();
        String prefix = NamespaceUtil.getPrefixForNamespace(resource, namespace);
        if (prefix != null && !prefix.isEmpty()) {
            return String.valueOf(prefix) + ":" + localPart;
        }
        prefix = qname.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            return String.valueOf(prefix) + ":" + localPart;
        }
        return localPart;
    }

    public static boolean hasNamespace(Resource resource, String namespace) {
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                String value = e.getValue();
                if (value == null || !value.equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPrefix(Resource resource, String prefix) {
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            return map.containsKey(prefix);
        }
        return false;
    }

    public static String addNamespace(Resource resource, String namespace) {
        if (NamespaceUtil.hasNamespace(resource, namespace)) {
            return null;
        }
        String prefix = null;
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            prefix = NamespaceUtil.createUniquePrefix(map, "ns");
            NamespaceUtil.addNamespace(resource, prefix, namespace);
        }
        return prefix;
    }

    public static String createUniquePrefix(Map<String, String> map, String prefix) {
        if (map != null && map.containsKey(prefix)) {
            int index = 1;
            while (map.containsKey(String.valueOf(prefix) + index)) {
                ++index;
            }
            prefix = String.valueOf(prefix) + index;
        }
        return prefix;
    }

    public static String addNamespace(Resource resource, String prefix, String namespace) {
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            if (prefix == null) {
                prefix = "ns";
            }
            map.put(prefix, namespace);
            return prefix;
        }
        return null;
    }

    public static String removeNamespace(Resource resource, String namespace) {
        final Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            String prefix = null;
            for (Map.Entry<String, String> e : map.entrySet()) {
                String value = e.getValue();
                if (value == null || !value.equals(namespace)) continue;
                prefix = e.getKey();
                break;
            }
            if (prefix != null && map.containsKey(prefix)) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
                if (domain != null) {
                    final String p = prefix;
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            map.remove(p);
                        }
                    });
                }
                return prefix;
            }
        }
        return null;
    }

    public static String removeNamespaceForPrefix(Resource resource, final String prefix) {
        TransactionalEditingDomain domain;
        final Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null && map.containsKey(prefix) && (domain = TransactionUtil.getEditingDomain((Resource)resource)) != null) {
            String ns = map.get(prefix);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    map.remove(prefix);
                }
            });
            return ns;
        }
        return null;
    }

    public static INamespaceMap<String, String> getNamespaceMap(EObject eObject) {
        if (eObject == null) {
            throw new NullPointerException("eObject cannot be null in getNamespaceMap()");
        }
        INamespaceMap nsMap = null;
        while (nsMap == null && eObject != null) {
            nsMap = AdapterRegistry.INSTANCE.adapt((Object)eObject, INamespaceMap.class);
            if (nsMap != null) continue;
            eObject = eObject.eContainer();
        }
        if (nsMap == null) {
            throw new IllegalStateException("INamespaceMap cannot be attached to an eObject");
        }
        return nsMap;
    }

    public static String getNamespacePrefix(EObject eObject, String namespace) {
        EObject context = eObject;
        while (context != null) {
            List<String> pfxList = NamespaceUtil.getNamespaceMap(context).getReverse(namespace);
            if (pfxList.size() > 0) {
                return pfxList.get(0);
            }
            context = context.eContainer();
        }
        return null;
    }

    public static List<String> getAllPrefixesForNamespace(Resource resource, String namespace) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> map = NamespaceUtil.getXMLNSPrefixMap(resource);
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                String value = e.getValue();
                if (value == null || !value.equals(namespace)) continue;
                result.add(e.getKey());
            }
        }
        return result;
    }

    public static String getNamespaceForObject(Object object) {
        String namespace = null;
        if (object instanceof EObject) {
            EObject root = (EObject)object;
            while ((namespace == null || namespace.isEmpty()) && root != null) {
                if (root instanceof Definition) {
                    namespace = ((Definition)root).getTargetNamespace();
                } else if (root instanceof XSDNamedComponent) {
                    namespace = ((XSDNamedComponent)root).getTargetNamespace();
                } else if (root instanceof Definitions) {
                    namespace = ((Definitions)root).getTargetNamespace();
                } else if (root instanceof Message) {
                    namespace = ((Message)root).getQName().getNamespaceURI();
                }
                root = root.eContainer();
            }
        } else if (object instanceof IType) {
            namespace = "http://www.java.com/java";
        }
        return namespace == null || namespace.isEmpty() ? null : namespace;
    }

    public static String getQualifier(Object object) {
        String qualifier = null;
        if (object instanceof EObject) {
            EObject root = (EObject)object;
            while (qualifier == null && root != null) {
                if (root instanceof Definition) {
                    qualifier = "wsdl";
                } else if (root instanceof XSDSchema) {
                    qualifier = "xsd";
                } else if (root instanceof Definitions) {
                    qualifier = "bpmn2";
                }
                root = root.eContainer();
            }
        } else if (object instanceof IType) {
            qualifier = "java";
        }
        return qualifier;
    }

    public static String getPrefixForObject(Resource resource, Object object) {
        Map<String, String> map;
        String prefix = "";
        String namespace = NamespaceUtil.getNamespaceForObject(object);
        String qualifier = NamespaceUtil.getQualifier(object);
        if (namespace != null) {
            for (String s : NamespaceUtil.getAllPrefixesForNamespace(resource, namespace)) {
                if (!s.endsWith("." + qualifier)) continue;
                return s;
            }
        }
        if ((map = NamespaceUtil.getXMLNSPrefixMap(resource)) != null) {
            prefix = NamespaceUtil.createUniquePrefix(map, "ns");
        }
        if (prefix != null) {
            return String.valueOf(prefix) + "." + qualifier;
        }
        return prefix;
    }

    public static String addNamespaceForObject(Resource resource, Object object) {
        String namespace = NamespaceUtil.getNamespaceForObject(object);
        String prefix = NamespaceUtil.getPrefixForObject(resource, object);
        if (namespace == null || NamespaceUtil.hasPrefix(resource, prefix)) {
            return null;
        }
        NamespaceUtil.addNamespace(resource, prefix, namespace);
        return namespace;
    }
}

