/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.SearcherManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.core.search.indexing.IIndexThreadListener;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index.lucene.IndexContainer;
import org.eclipse.dltk.internal.core.index.lucene.IndexProperties;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.Utils;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;
import org.osgi.framework.Bundle;

public enum LuceneManager {
    INSTANCE;

    private static final String INDEX_DIR = "index";
    private static final String PROPERTIES_FILE = ".properties";
    private static final String MAPPINGS_FILE = ".mappings";
    private final String fIndexRoot;
    private final Properties fIndexProperties = new Properties();
    private final Map<String, String> fContainerMappings = new HashMap<String, String>();
    private final Map<String, IndexContainer> fIndexContainers = new HashMap<String, IndexContainer>();

    private void commit() {
        try {
            for (IndexContainer indexContainer : this.getDirtyContainers()) {
                indexContainer.commit();
                indexContainer.refresh();
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private LuceneManager() {
        this.fIndexRoot = Platform.getStateLocation((Bundle)LucenePlugin.getDefault().getBundle()).append(INDEX_DIR).toOSString();
        File indexRootDirectory = new File(this.fIndexRoot);
        if (!indexRootDirectory.exists()) {
            indexRootDirectory.mkdirs();
        }
        this.startup();
    }

    public final IndexWriter findIndexWriter(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexWriter(dataType, elementType);
    }

    public final SearcherManager findIndexSearcher(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexSearcher(dataType, elementType);
    }

    public final IndexWriter findTimestampsWriter(String container) {
        return this.getIndexContainer(container).getTimestampsWriter();
    }

    public final SearcherManager findTimestampsSearcher(String container) {
        return this.getIndexContainer(container).getTimestampsSearcher();
    }

    public final void delete(String container) {
        this.deleteIndexContainer(container, false);
    }

    public final void delete(String container, String sourceModule) {
        if (this.fContainerMappings.get(container) != null) {
            this.getIndexContainer(container).delete(sourceModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexContainer> getDirtyContainers() {
        ArrayList<IndexContainer> uncommittedContainers = new ArrayList<IndexContainer>();
        Map<String, IndexContainer> map = this.fIndexContainers;
        synchronized (map) {
            for (IndexContainer indexContainer : this.fIndexContainers.values()) {
                if (!indexContainer.hasChanges()) continue;
                uncommittedContainers.add(indexContainer);
            }
        }
        return uncommittedContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexContainer getIndexContainer(String container) {
        String containerId = this.fContainerMappings.get(container);
        if (containerId == null) {
            Map<String, String> map = this.fContainerMappings;
            synchronized (map) {
                containerId = this.fContainerMappings.get(container);
                if (containerId == null) {
                    while (this.fContainerMappings.containsValue(containerId = UUID.randomUUID().toString())) {
                    }
                    this.fContainerMappings.put(container, containerId);
                    this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
                    this.saveMappings();
                }
            }
        }
        return this.fIndexContainers.get(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexContainer(String container, boolean wait) {
        Map<String, String> map = this.fContainerMappings;
        synchronized (map) {
            String containerId = this.fContainerMappings.remove(container);
            if (containerId != null) {
                IndexContainer containerEntry = this.fIndexContainers.remove(containerId);
                this.saveMappings();
                containerEntry.delete(wait);
            }
        }
    }

    private void startup() {
        this.loadProperties();
        boolean purgeIndexRoot = false;
        boolean resetProperties = false;
        String modelVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.model.version");
        String luceneVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.lucene.version");
        if (!"1.0".equals(modelVersion) || !IndexProperties.LUCENE_VERSION.equals(luceneVersion)) {
            purgeIndexRoot = true;
            resetProperties = true;
        }
        if (purgeIndexRoot) {
            this.purge();
        }
        if (resetProperties) {
            this.resetProperties();
            this.saveProperties();
        }
        this.loadMappings();
        this.registerIndexContainers();
        ModelManager.getModelManager().getIndexManager().addIndexerThreadListener((IIndexThreadListener)new IndexerThreadListener());
        ModelManager.getModelManager().getIndexManager().addShutdownListener((IShutdownListener)new ShutdownListener());
    }

    private synchronized void shutdown() {
        for (IndexContainer entry : this.fIndexContainers.values()) {
            entry.close();
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndexContainers() {
        Map<String, String> map = this.fContainerMappings;
        synchronized (map) {
            for (String containerId : this.fContainerMappings.values()) {
                this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
            }
        }
    }

    private void loadProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                this.fIndexProperties.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        Map<String, String> map = this.fContainerMappings;
        synchronized (map) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    Properties p = new Properties();
                    p.load(fis);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        this.fContainerMappings.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
    }

    private void saveProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.fIndexProperties.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        Map<String, String> map = this.fContainerMappings;
        synchronized (map) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileOutputStream fos = new FileOutputStream(file);){
                    Properties p = new Properties();
                    for (Map.Entry<String, String> entry : this.fContainerMappings.entrySet()) {
                        p.setProperty(entry.getKey(), entry.getValue());
                    }
                    p.store(fos, "");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
    }

    private void resetProperties() {
        this.fIndexProperties.clear();
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.model.version", "1.0");
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.lucene.version", IndexProperties.LUCENE_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ArrayList<String> containers = new ArrayList<String>();
        IDLTKLanguageToolkit[] iDLTKLanguageToolkitArray = DLTKLanguageManager.getLanguageToolkits();
        int n = iDLTKLanguageToolkitArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDLTKLanguageToolkit toolkit = iDLTKLanguageToolkitArray[n2];
            DLTKWorkspaceScope scope = ModelManager.getModelManager().getWorkspaceScope(toolkit);
            IPath[] iPathArray = scope.enclosingProjectsAndZips();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                containers.add(path.toString());
                ++n4;
            }
            ++n2;
        }
        HashSet<String> toRemove = new HashSet<String>();
        Map<String, String> map = this.fContainerMappings;
        synchronized (map) {
            for (String mappedContainer : this.fContainerMappings.values()) {
                if (containers.contains(mappedContainer)) continue;
                toRemove.add(mappedContainer);
            }
        }
        if (!toRemove.isEmpty()) {
            for (String container : toRemove) {
                this.deleteIndexContainer(container, true);
            }
        }
        ArrayList<Path> toDelete = new ArrayList<Path>();
        Path indexRoot = Paths.get(this.fIndexRoot, new String[0]);
        File[] fileArray = indexRoot.toFile().listFiles();
        int path = fileArray.length;
        int n5 = 0;
        while (n5 < path) {
            File file = fileArray[n5];
            if (file.isDirectory() && !this.fContainerMappings.containsValue(file.getName())) {
                toDelete.add(Paths.get(file.getAbsolutePath(), new String[0]));
            }
            ++n5;
        }
        if (!toDelete.isEmpty()) {
            for (Path path2 : toDelete) {
                try {
                    Utils.delete(path2);
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
        }
    }

    private void purge() {
        Path indexRoot = Paths.get(this.fIndexRoot, new String[0]);
        try {
            Utils.delete(indexRoot);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        indexRoot.toFile().mkdir();
    }

    private final class IndexerThreadListener
    implements IIndexThreadListener {
        private IndexerThreadListener() {
        }

        public void aboutToBeIdle() {
            LuceneManager.this.commit();
        }

        public void aboutToBeRun(long idlingTime) {
        }
    }

    private final class ShutdownListener
    implements IShutdownListener {
        private ShutdownListener() {
        }

        public void shutdown() {
            INSTANCE.shutdown();
        }
    }
}

