/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositorySynchronizer;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ISynchronizableRepository;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.h2.jdbcx.JdbcDataSource;

public class CloneCDORepository
extends CDORepositoryImpl {
    public static final String PROP_CONNECTOR_TYPE = "connectorType";
    public static final String PROP_CONNECTOR_DESCRIPTION = "connectorDescription";
    public static final String PROP_RECONNECT_SECONDS = "reconnectSeconds";
    public static final String PROP_RECOMMIT_SECONDS = "recommitSeconds";
    public static final String PROP_RECOMMIT_ATTEMPTS = "recommitAttempts";
    private String connectorType;
    private String connectorDescription;
    private int reconnectSeconds;
    private int recommitSeconds;
    private int recommitAttempts;
    private ISynchronizableRepository repository;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isClone() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public final String getConnectorType() {
        return "jvm";
    }

    @Override
    public final String getConnectorDescription() {
        return "local";
    }

    @Override
    public String getURI() {
        return String.valueOf(this.connectorType) + "://" + this.connectorDescription + "/" + this.getName();
    }

    public final int getReconnectSeconds() {
        return this.reconnectSeconds;
    }

    public final int getRecommitSeconds() {
        return this.recommitSeconds;
    }

    public final int getRecommitAttempts() {
        return this.recommitAttempts;
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.connectorType = properties.getProperty(PROP_CONNECTOR_TYPE);
        this.connectorDescription = properties.getProperty(PROP_CONNECTOR_DESCRIPTION);
        this.reconnectSeconds = Integer.parseInt(properties.getProperty(PROP_RECONNECT_SECONDS));
        this.recommitSeconds = Integer.parseInt(properties.getProperty(PROP_RECOMMIT_SECONDS));
        this.recommitAttempts = Integer.parseInt(properties.getProperty(PROP_RECOMMIT_ATTEMPTS));
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_CONNECTOR_TYPE, this.connectorType);
        properties.setProperty(PROP_CONNECTOR_DESCRIPTION, this.connectorDescription);
        properties.setProperty(PROP_RECONNECT_SECONDS, Integer.toString(this.reconnectSeconds));
        properties.setProperty(PROP_RECOMMIT_SECONDS, Integer.toString(this.recommitSeconds));
        properties.setProperty(PROP_RECOMMIT_ATTEMPTS, Integer.toString(this.recommitAttempts));
    }

    @Override
    protected CDOSession openSession() {
        final String repositoryName = this.getName();
        File folder = new File(this.getFolder(), "db");
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + folder);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true, (boolean)false);
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", Boolean.toString(true));
        props.put("supportingBranches", Boolean.toString(true));
        props.put("idGenerationLocation", CDOCommonRepository.IDGenerationLocation.CLIENT.toString());
        final IManagedContainer container = this.getContainer();
        CDOSessionConfigurationFactory remoteSessionConfigurationFactory = new CDOSessionConfigurationFactory(){

            public CDOSessionConfiguration createSessionConfiguration() {
                IConnector connector = Net4jUtil.getConnector((IManagedContainer)container, (String)CloneCDORepository.this.connectorType, (String)CloneCDORepository.this.connectorDescription);
                CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
                config.setConnector(connector);
                config.setRepositoryName(repositoryName);
                config.setRevisionManager(CDORevisionUtil.createRevisionManager((CDORevisionCache)CDORevisionCache.NOOP));
                return config;
            }
        };
        IRepositorySynchronizer synchronizer = CDOServerUtil.createRepositorySynchronizer((CDOSessionConfigurationFactory)remoteSessionConfigurationFactory);
        this.repository = CDOServerUtil.createOfflineClone((String)(String.valueOf(repositoryName) + "-clone"), (IStore)store, props, (IRepositorySynchronizer)synchronizer);
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)this.repository);
        Net4jUtil.getAcceptor((IManagedContainer)container, (String)this.getConnectorType(), (String)this.getConnectorDescription());
        return super.openSession();
    }

    @Override
    protected void closeSession() {
        super.closeSession();
        if (this.repository != null) {
            this.repository.deactivate();
            this.repository = null;
        }
    }
}

