/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public final class StoreThreadLocal {
    private static final boolean DEBUG_SESSION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.server.StoreThreadLocal.DEBUG_SESSION");
    private static final ThreadLocal<InternalSession> SESSION = new ThreadLocal();
    private static final ThreadLocal<IStoreAccessor> ACCESSOR = new ThreadLocal();
    private static final ThreadLocal<IStoreAccessor.CommitContext> COMMIT_CONTEXT = new ThreadLocal();

    private StoreThreadLocal() {
    }

    public static Runnable wrap(ISession session, Runnable runnable) {
        return () -> {
            StoreThreadLocal.setSession((InternalSession)session);
            try {
                runnable.run();
            }
            finally {
                StoreThreadLocal.release();
            }
        };
    }

    public static <T> Callable<T> wrap(ISession session, Callable<T> callable) {
        return () -> {
            StoreThreadLocal.setSession((InternalSession)session);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                StoreThreadLocal.release();
            }
        };
    }

    public static void setSession(InternalSession session) {
        if (session == null) {
            StoreThreadLocal.REMOVE_SESSION();
        } else {
            StoreThreadLocal.SET_SESSION(session);
        }
        ACCESSOR.remove();
        COMMIT_CONTEXT.remove();
    }

    public static InternalSession getSession() throws NoSessionRegisteredException {
        InternalSession session = SESSION.get();
        if (session == null) {
            throw new NoSessionRegisteredException();
        }
        return session;
    }

    public static boolean hasSession() {
        return SESSION.get() != null;
    }

    public static void setAccessor(IStoreAccessor accessor) {
        if (accessor == null) {
            ACCESSOR.remove();
            StoreThreadLocal.REMOVE_SESSION();
        } else {
            ACCESSOR.set(accessor);
            StoreThreadLocal.SET_SESSION(accessor.getSession());
        }
    }

    public static IStoreAccessor getAccessor() throws NoSessionRegisteredException {
        IStoreAccessor accessor = ACCESSOR.get();
        if (accessor == null) {
            InternalSession session = StoreThreadLocal.getSession();
            IStore store = session.getManager().getRepository().getStore();
            accessor = store.getReader(session);
            ACCESSOR.set(accessor);
        }
        return accessor;
    }

    public static boolean hasAccessor() {
        return ACCESSOR.get() != null;
    }

    public static void setCommitContext(IStoreAccessor.CommitContext commitContext) {
        if (commitContext == null) {
            COMMIT_CONTEXT.remove();
        } else {
            COMMIT_CONTEXT.set(commitContext);
        }
    }

    public static IStoreAccessor.CommitContext getCommitContext() {
        return COMMIT_CONTEXT.get();
    }

    public static boolean hasCommitContext() {
        return COMMIT_CONTEXT.get() != null;
    }

    public static void release() {
        try {
            IStoreAccessor accessor = ACCESSOR.get();
            if (accessor != null && LifecycleUtil.isActive((Object)accessor)) {
                accessor.release();
            }
        }
        finally {
            StoreThreadLocal.remove();
        }
    }

    public static void remove() {
        ACCESSOR.remove();
        StoreThreadLocal.REMOVE_SESSION();
        COMMIT_CONTEXT.remove();
    }

    private static void SET_SESSION(InternalSession session) {
        if (session != null) {
            if (DEBUG_SESSION) {
                InternalSession oldSession = SESSION.get();
                if (oldSession != null) {
                    throw new IllegalStateException("Session already registered: " + oldSession);
                }
                IOUtil.OUT().println("Set        " + session + " --> " + Thread.currentThread().getName());
            }
            SESSION.set(session);
        }
    }

    private static void REMOVE_SESSION() {
        InternalSession session;
        if (DEBUG_SESSION && (session = SESSION.get()) != null) {
            IOUtil.OUT().println("    Remove " + session + " --> " + Thread.currentThread().getName());
        }
        SESSION.remove();
    }

    public static final class NoSessionRegisteredException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public NoSessionRegisteredException() {
            super("session == null");
        }
    }
}

