/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspaceBase;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler3;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOMerger2;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.properties.IPropertiesContainer;
import org.eclipse.net4j.util.registry.IRegistry;

public class CDOWorkspaceImpl
extends Notifier
implements InternalCDOWorkspace {
    private static final String PROP_BRANCH_ID = "org.eclipse.emf.cdo.workspace.branchID";
    private static final String PROP_BRANCH_PATH = "org.eclipse.emf.cdo.workspace.branchPath";
    private static final String PROP_TIME_STAMP = "org.eclipse.emf.cdo.workspace.timeStamp";
    private static final String PROP_FIXED = "org.eclipse.emf.cdo.workspace.fixed";
    private IManagedContainer container;
    private InternalCDOWorkspaceBase base;
    private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    private CDOIDGenerator idGenerator;
    private InternalRepository localRepository;
    private CDOBranchPoint localRepositoryHead;
    private InternalCDOSession localSession;
    private CDOBranchPoint localSessionHead;
    private int branchID = -1;
    private String branchPath;
    private long timeStamp;
    private boolean fixed;
    private boolean dirty;
    private CDOSessionConfigurationFactory remoteSessionConfigurationFactory;
    private Map<InternalCDOSession, Closeable> closeables = new ConcurrentHashMap<InternalCDOSession, Closeable>();
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();

    public CDOWorkspaceImpl(String localRepositoryName, IStore store, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote, int branchID, String branchPath, long timeStamp) {
        this.init(localRepositoryName, store, idGenerationLocation, idGenerator, base, remote);
        this.branchID = branchID;
        this.branchPath = branchPath;
        this.timeStamp = timeStamp;
        this.fixed = timeStamp != 0L;
        this.checkout();
        this.saveProperties();
    }

    public CDOWorkspaceImpl(String localRepositoryName, IStore store, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.init(localRepositoryName, store, idGenerationLocation, idGenerator, base, remote);
        this.loadProperties();
    }

    protected void checkout() {
        Monitor monitor = new Monitor();
        final IStoreAccessor.Raw accessor = this.beginRawAccess(null);
        try {
            InternalCDOSession remoteSession = this.openRemoteSession();
            try {
                InternalCDOBranch branch;
                InternalCDOPackageUnit[] remotePackageUnits;
                CDOID rootResourceID = remoteSession.getRepositoryInfo().getRootResourceID();
                this.localRepository.setRootResourceID(rootResourceID);
                InternalCDOPackageRegistry localPackageRegistry = this.localRepository.getPackageRegistry(false);
                InternalCDOPackageUnit[] internalCDOPackageUnitArray = remotePackageUnits = remoteSession.getPackageRegistry().getPackageUnits(false);
                int n = remotePackageUnits.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOPackageUnit remotePackageUnit = internalCDOPackageUnitArray[n2];
                    InternalCDOPackageUnit localPackageUnit = remotePackageUnit.copy();
                    localPackageRegistry.putPackageUnit(localPackageUnit);
                    ++n2;
                }
                accessor.rawStore(remotePackageUnits, (OMMonitor)monitor);
                CDORevisionHandler handler = new CDORevisionHandler((OMMonitor)monitor){
                    private final /* synthetic */ OMMonitor val$monitor;
                    {
                        this.val$monitor = oMMonitor;
                    }

                    public boolean handleRevision(CDORevision remoteRevision) {
                        InternalCDORevision repositoryRevision = (InternalCDORevision)remoteRevision;
                        long commitTime = repositoryRevision.getTimeStamp();
                        if (commitTime > CDOWorkspaceImpl.this.timeStamp) {
                            CDOWorkspaceImpl.this.timeStamp = commitTime;
                        }
                        repositoryRevision.setBranchPoint(CDOWorkspaceImpl.this.localRepositoryHead);
                        accessor.rawStore(repositoryRevision, this.val$monitor);
                        return true;
                    }
                };
                InternalCDOBranchManager branchManager = remoteSession.getBranchManager();
                if (this.branchID == -1) {
                    if (StringUtil.isEmpty((String)this.branchPath)) {
                        this.branchPath = "MAIN";
                    }
                    branch = branchManager.getBranch(this.branchPath);
                    this.branchID = branch.getID();
                } else {
                    branch = branchManager.getBranch(this.branchID);
                    this.branchPath = branch.getPathName();
                }
                remoteSession.getSessionProtocol().handleRevisions(null, (CDOBranch)branch, false, this.timeStamp, false, handler);
            }
            finally {
                this.closeRemoteSession(remoteSession);
            }
            accessor.rawCommit(1.0, (OMMonitor)monitor);
        }
        finally {
            StoreThreadLocal.release();
            monitor.done();
        }
    }

    protected void init(String localRepositoryName, IStore store, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.idGenerationLocation = idGenerationLocation;
        this.idGenerator = idGenerator;
        this.container = this.createContainer(store);
        this.remoteSessionConfigurationFactory = remote;
        try {
            this.localRepository = this.createLocalRepository(localRepositoryName, store);
            this.localRepositoryHead = this.localRepository.getBranchManager().getMainBranch().getHead();
            this.base = base;
            this.base.init(this);
            this.setDirtyFromBase();
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
        catch (Error ex) {
            this.close();
            throw ex;
        }
    }

    private void setDirtyFromBase() {
        this.setDirty(!this.base.isEmpty());
    }

    @Override
    public int getBranchID() {
        return this.branchID;
    }

    @Override
    public String getBranchPath() {
        return this.branchPath;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.fireEvent(new DirtyStateChangedEventImpl(this, dirty));
        }
    }

    protected void clearBase() {
        this.base.clear();
        this.setDirty(false);
    }

    public CDOState getState(Object object) {
        if (object instanceof CDOObject) {
            CDOObject cdoObject = (CDOObject)object;
            CDOID id = cdoObject.cdoID();
            if (this.base.containsID(id)) {
                if (this.base.isAddedObject(id)) {
                    return CDOState.NEW;
                }
                return CDOState.DIRTY;
            }
            return CDOState.CLEAN;
        }
        return null;
    }

    @Override
    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.idGenerationLocation;
    }

    public CDOIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public InternalCDOWorkspaceBase getBase() {
        return this.base;
    }

    public InternalCDOView openView() {
        CDOView view = this.getLocalSession().openView();
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOView openView(ResourceSet resourceSet) {
        CDOView view = this.getLocalSession().openView(resourceSet);
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOTransaction openTransaction() {
        CDOTransaction transaction = this.getLocalSession().openTransaction();
        this.initView((CDOView)transaction);
        this.initTransaction(transaction);
        return (InternalCDOTransaction)transaction;
    }

    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        CDOTransaction transaction = this.getLocalSession().openTransaction(resourceSet);
        this.initView((CDOView)transaction);
        this.initTransaction(transaction);
        return (InternalCDOTransaction)transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(CDOView view) {
        this.setWorkspaceProperty((IPropertiesContainer)view);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            this.views.add((InternalCDOView)view);
        }
        view.addListener((IListener)new ViewAdapter());
        if (view instanceof CDOTransaction) {
            if (this.fixed) {
                throw new ReadOnlyException("Workspace is fixed");
            }
            if (this.idGenerationLocation != CDOCommonRepository.IDGenerationLocation.CLIENT) {
                CDOTransaction transaction = (CDOTransaction)view;
                transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler1(){

                    public void attachingObject(CDOTransaction transaction, CDOObject object) {
                        throw new IllegalStateException("Attaching new objects is only supported for IDGenerationLocation.CLIENT");
                    }
                });
            }
        }
    }

    protected void initTransaction(CDOTransaction transaction) {
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                CDOID id;
                HashSet<CDOID> changedIDs = new HashSet<CDOID>();
                InternalCDOTransaction tx = (InternalCDOTransaction)transaction;
                InternalCDOSavepoint lastSavepoint = tx.getLastSavepoint();
                for (InternalCDORevision revision : tx.getCleanRevisions().values()) {
                    id = revision.getID();
                    changedIDs.add(id);
                    if (lastSavepoint.getDetachedObject(id) != null) {
                        if (CDOWorkspaceImpl.this.base.isAddedObject(id)) {
                            CDOWorkspaceImpl.this.base.registerAddedAndDetachedObject(revision);
                            continue;
                        }
                        CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject(revision);
                        continue;
                    }
                    if (lastSavepoint.getDirtyObject(id) == null) continue;
                    CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject(revision);
                }
                for (CDOObject object : tx.getNewObjects().values()) {
                    id = object.cdoID();
                    CDOWorkspaceImpl.this.base.registerAddedObject(id);
                    changedIDs.add(id);
                }
                CDOWorkspaceImpl.this.setDirtyFromBase();
                CDOWorkspaceImpl.this.fireEvent(new ObjectStatesChangedEventImpl(CDOWorkspaceImpl.this, changedIDs));
            }
        });
    }

    private void setWorkspaceProperty(IPropertiesContainer container) {
        IRegistry properties = container.properties();
        properties.put((Object)"org.eclipse.emf.cdo.workspace.CDOWorkspace", (Object)this);
    }

    public InternalCDOTransaction update(CDOMerger merger) {
        return this.merge(merger, this.branchPath);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath) {
        return this.merge(merger, branchPath, 0L);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath, long timeStamp) {
        return this.merge(merger, branchPath, 0L, false);
    }

    private InternalCDOTransaction merge(CDOMerger merger, String branchPath, long timeStamp, boolean saveBranchPoint) {
        InternalCDOSession remoteSession = this.openRemoteSession();
        try {
            InternalCDOTransaction transaction;
            if (timeStamp == 0L) {
                timeStamp = remoteSession.getLastUpdateTime();
            }
            long newTimeStamp = timeStamp;
            InternalCDOBranchManager branchManager = remoteSession.getBranchManager();
            CDOBranchPoint basePoint = branchManager.getBranch(this.branchPath).getPoint(this.timeStamp);
            CDOBranchPoint remotePoint = branchManager.getBranch(branchPath).getPoint(newTimeStamp);
            CDOBranchPointRange range = CDOBranchUtil.createRange((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint);
            CDOChangeSetData remoteData = remoteSession.getSessionProtocol().loadChangeSets(new CDOBranchPointRange[]{range})[0];
            CDOChangeSetData localData = this.getLocalChanges();
            if (merger instanceof CDOMerger2) {
                CDOMerger2 merger2 = (CDOMerger2)merger;
                HashSet<CDOID> affectedIDs = new HashSet<CDOID>();
                this.addIDs(affectedIDs, remoteData);
                this.addIDs(affectedIDs, localData);
                transaction = this.openLocalTransaction(remoteSession, remoteData, remotePoint, newTimeStamp);
                InternalCDOBranch remoteBranch = remoteSession.getBranchManager().getBranch(branchPath);
                CDOView remoteView = remoteSession.openView((CDOBranch)remoteBranch);
                merger2.merge((CDOTransaction)transaction, remoteView, affectedIDs);
            } else {
                CDOChangeSetData result = this.getMergeResult(merger, basePoint, remotePoint, localData, remoteData);
                transaction = this.openLocalTransaction(remoteSession, remoteData, remotePoint, newTimeStamp);
                transaction.applyChangeSet(result, (CDORevisionProvider)new BaseRevisionProvider(), (CDORevisionProvider)this, null, false);
            }
            if (saveBranchPoint) {
                CDOBranch branch = remotePoint.getBranch();
                this.branchID = branch.getID();
                this.branchPath = branch.getPathName();
                this.timeStamp = timeStamp;
                this.saveProperties();
            }
            return transaction;
        }
        catch (CDOMerger.ConflictException ex) {
            return this.handleMergeConflict(ex);
        }
        catch (RuntimeException ex) {
            this.closeRemoteSession(remoteSession);
            throw ex;
        }
        catch (Error ex) {
            this.closeRemoteSession(remoteSession);
            throw ex;
        }
    }

    private InternalCDOTransaction openLocalTransaction(final InternalCDOSession remoteSession, final CDOChangeSetData remoteData, final CDOBranchPoint remotePoint, final long newTimeStamp) {
        InternalCDOTransaction transaction = (InternalCDOTransaction)this.getLocalSession().openTransaction();
        this.initView((CDOView)transaction);
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler3(){

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext, CDOCommitInfo result) {
                Set<CDOID> affectedIDs = this.getAffectedIDs(commitContext, remoteData);
                CDOWorkspaceImpl local = CDOWorkspaceImpl.this;
                ManagedRevisionProvider remote = new ManagedRevisionProvider((CDORevisionManager)remoteSession.getRevisionManager(), remotePoint);
                this.updateBase(local, (CDORevisionProvider)remote, affectedIDs);
                CDOWorkspaceImpl.this.setDirtyFromBase();
                CDOWorkspaceImpl.this.setTimeStamp(newTimeStamp);
                CDOWorkspaceImpl.this.fireEvent(new ObjectStatesChangedEventImpl(CDOWorkspaceImpl.this, affectedIDs));
            }

            private void updateBase(CDORevisionProvider local, CDORevisionProvider remote, Set<CDOID> affectedIDs) {
                IStoreAccessor.Raw accessor = null;
                try {
                    for (CDOID id : affectedIDs) {
                        InternalCDORevision localRevision = this.getRevision(id, local);
                        InternalCDORevision remoteRevision = this.getRevision(id, remote);
                        accessor = this.updateBase(localRevision, remoteRevision, id, accessor);
                    }
                }
                finally {
                    CDOWorkspaceImpl.this.finishRawAccess(accessor);
                }
            }

            private IStoreAccessor.Raw updateBase(InternalCDORevision localRevision, InternalCDORevision remoteRevision, CDOID id, IStoreAccessor.Raw accessor) {
                if (localRevision == null) {
                    if (remoteRevision == null) {
                        CDOWorkspaceImpl.this.base.deregisterObject(id);
                    } else {
                        InternalCDORevision baseRevision = remoteRevision.copy();
                        baseRevision.setBranchPoint(CDOWorkspaceImpl.this.localSessionHead);
                        CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject(baseRevision);
                    }
                } else if (remoteRevision == null) {
                    CDOWorkspaceImpl.this.base.registerAddedObject(id);
                } else {
                    InternalCDORevision baseRevision = null;
                    if (localRevision.getVersion() != remoteRevision.getVersion()) {
                        baseRevision = (InternalCDORevision)CDOWorkspaceImpl.this.base.getRevision(id);
                    }
                    CDOWorkspaceImpl.this.base.deregisterObject(id);
                    InternalCDORevisionDelta delta = localRevision.compare((CDORevision)remoteRevision);
                    if (!delta.isEmpty()) {
                        baseRevision = remoteRevision.copy();
                        baseRevision.setBranchPoint(CDOWorkspaceImpl.this.localSessionHead);
                        CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject(baseRevision);
                    } else if (baseRevision != null) {
                        accessor = CDOWorkspaceImpl.this.beginRawAccess(accessor);
                        int version = Math.abs(localRevision.getVersion());
                        InternalCDOBranch branch = localRevision.getBranch();
                        EClass eClass = localRevision.getEClass();
                        int v = baseRevision.getVersion();
                        while (v <= version) {
                            accessor.rawDelete(id, v, (CDOBranch)branch, eClass, (OMMonitor)new Monitor());
                            ++v;
                        }
                        localRevision = remoteRevision.copy();
                        localRevision.setBranchPoint(CDOWorkspaceImpl.this.localRepositoryHead);
                        accessor.rawStore(localRevision, (OMMonitor)new Monitor());
                    }
                }
                return accessor;
            }

            private Set<CDOID> getAffectedIDs(CDOCommitContext commitContext, CDOChangeSetData remoteData2) {
                HashSet<CDOID> affectedIDs = new HashSet<CDOID>();
                CDOWorkspaceImpl.this.addIDs((Set<CDOID>)affectedIDs, CDOWorkspaceImpl.this.base.getIDs());
                CDOWorkspaceImpl.this.addIDs((Set<CDOID>)affectedIDs, remoteData2.getChangeKinds());
                CDOWorkspaceImpl.this.addIDs((Set<CDOID>)affectedIDs, commitContext);
                return affectedIDs;
            }

            private InternalCDORevision getRevision(CDOID id, CDORevisionProvider revisionProvider) {
                CDORevision revision = revisionProvider.getRevision(id);
                if (revision instanceof DetachedCDORevision) {
                    revision = null;
                }
                return (InternalCDORevision)revision;
            }
        });
        transaction.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                CDOWorkspaceImpl.this.closeRemoteSession(remoteSession);
            }
        });
        return transaction;
    }

    private InternalCDOTransaction handleMergeConflict(CDOMerger.ConflictException ex) {
        throw ex;
    }

    private CDOChangeSetData getMergeResult(CDOMerger merger, CDOBranchPoint basePoint, CDOBranchPoint remotePoint, CDOChangeSetData localData, CDOChangeSetData remoteData) {
        if (localData.isEmpty()) {
            return remoteData;
        }
        CDOChangeSet localChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, null, (CDOChangeSetData)localData);
        CDOChangeSet remoteChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint, (CDOChangeSetData)remoteData);
        return merger.merge(localChanges, remoteChanges);
    }

    @Override
    public void revert() {
        CDOChangeSetData revertData = this.getLocalChanges(false);
        this.revert(revertData);
    }

    @Override
    public void revert(CDOChangeSetData revertData) {
        CDOID id;
        final CDOBranch localBranch = this.localSessionHead.getBranch();
        IStoreAccessor.Raw accessor = this.beginRawAccess(null);
        final ArrayList<InternalCDORevision> changedRevisions = new ArrayList<InternalCDORevision>();
        for (CDORevisionKey key : revertData.getChangedObjects()) {
            CDOID id2 = key.getID();
            InternalCDORevision localRevision = (InternalCDORevision)this.getRevision(id2);
            InternalCDORevision baseRevision = (InternalCDORevision)this.base.getRevision(id2);
            changedRevisions.add(baseRevision);
            EClass eClass = baseRevision.getEClass();
            int version = Math.abs(localRevision.getVersion());
            int v = baseRevision.getVersion();
            while (v <= version) {
                accessor.rawDelete(id2, v, localBranch, eClass, (OMMonitor)new Monitor());
                ++v;
            }
            accessor.rawStore(baseRevision, (OMMonitor)new Monitor());
        }
        final ArrayList<CDORevisionKey> detachedRevisions = new ArrayList<CDORevisionKey>();
        for (CDOIDAndVersion key : revertData.getDetachedObjects()) {
            id = key.getID();
            int version = this.getRevision(id).getVersion();
            int v = 1;
            while (v <= version) {
                accessor.rawDelete(id, v, localBranch, null, (OMMonitor)new Monitor());
                ++v;
            }
            detachedRevisions.add(CDORevisionUtil.createRevisionKey((CDOID)id, (CDOBranch)localBranch, (int)version));
        }
        for (CDOIDAndVersion key : revertData.getNewObjects()) {
            id = key.getID();
            SyntheticCDORevision[] synthetics = new SyntheticCDORevision[1];
            InternalCDORevisionManager revisionManager = this.localSession.getRevisionManager();
            revisionManager.getRevision(id, this.localSessionHead, -1, 0, true, synthetics);
            int max = synthetics[0].getVersion();
            EClass eClass = synthetics[0].getEClass();
            InternalCDORevision baseRevision = (InternalCDORevision)this.base.getRevision(id);
            int v = baseRevision.getVersion();
            while (v <= max) {
                int version = v == max ? -max : v;
                accessor.rawDelete(id, version, localBranch, eClass, (OMMonitor)new Monitor());
                ++v;
            }
            accessor.rawStore(baseRevision, (OMMonitor)new Monitor());
        }
        this.base.deleteAddedAndDetachedObjects(accessor, localBranch);
        this.finishRawAccess(accessor);
        this.base.clear();
        this.localSession.refresh(new CDOSessionProtocol.RefreshSessionResult.Provider(){

            public CDOSessionProtocol.RefreshSessionResult getRefreshSessionResult(Map<CDOBranch, List<InternalCDOView>> views, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
                CDOSessionProtocol.RefreshSessionResult result = new CDOSessionProtocol.RefreshSessionResult(CDOWorkspaceImpl.this.timeStamp);
                Map<CDOID, InternalCDORevision> revisions = viewedRevisions.get(localBranch);
                if (revisions != null) {
                    for (InternalCDORevision baseRevision : changedRevisions) {
                        CDOID id = baseRevision.getID();
                        if (!revisions.containsKey(id)) continue;
                        InternalCDORevision newRevision = baseRevision.copy();
                        newRevision.setBranchPoint(CDOWorkspaceImpl.this.localSessionHead);
                        result.addChangedObject(newRevision);
                    }
                }
                for (CDORevisionKey key : detachedRevisions) {
                    result.addDetachedObject(key);
                }
                return result;
            }
        });
        this.setDirty(false);
    }

    @Override
    public void replace(String branchPath, long timeStamp) {
        CDOChangeSetData revertData = this.getLocalChanges(false);
        this.replace(branchPath, timeStamp, revertData);
    }

    @Override
    public void replace(String branchPath, long timeStamp, CDOChangeSetData revertData) {
        this.revert(revertData);
        try (InternalCDOTransaction transaction = this.merge((CDOMerger)new DefaultCDOMerger.PerFeature.ManyValued(), branchPath, timeStamp, true);){
            try {
                transaction.commit();
            }
            catch (ConcurrentAccessException ex) {
                throw new CDOException((Throwable)ex);
            }
            catch (CommitException ex) {
                throw new CDOException((Throwable)ex);
            }
        }
    }

    @Override
    public CDOCommitInfo checkin() throws CommitException {
        return this.checkin(null);
    }

    @Override
    public CDOCommitInfo checkin(String comment) throws CommitException {
        Set<CDOID> ids = null;
        InternalCDOSession remoteSession = this.openRemoteSession();
        try {
            CDOCommitInfo cDOCommitInfo;
            InternalCDOBranch remoteBranch = remoteSession.getBranchManager().getBranch(this.branchPath);
            InternalCDOTransaction remoteTransaction = (InternalCDOTransaction)remoteSession.openTransaction((CDOBranch)remoteBranch);
            try {
                CDOChangeSetData changes = this.getLocalChanges();
                try {
                    InternalCDOTransaction.ApplyChangeSetResult result = remoteTransaction.applyChangeSet(changes, (CDORevisionProvider)this.base, (CDORevisionProvider)this, this.localSessionHead, true);
                    if (!result.getIDMappings().isEmpty()) {
                        throw new IllegalStateException("Attaching new objects is only supported for IDGenerationLocation.CLIENT");
                    }
                }
                catch (InternalCDOTransaction.ChangeSetOutdatedException ex) {
                    throw new CommitException((Throwable)ex);
                }
                remoteTransaction.setCommitComment(comment);
                CDOCommitInfo info = remoteTransaction.commit();
                ids = this.checkinPostProcessing(remoteTransaction, info.getChangedObjects());
                this.clearBase();
                this.setTimeStamp(info.getTimeStamp());
                this.addIDs(ids, changes.getNewObjects());
                cDOCommitInfo = info;
            }
            catch (Throwable throwable) {
                remoteTransaction.close();
                throw throwable;
            }
            remoteTransaction.close();
            return cDOCommitInfo;
        }
        finally {
            this.closeRemoteSession(remoteSession);
            if (ids != null) {
                this.fireEvent(new ObjectStatesChangedEventImpl(this, ids));
            }
        }
    }

    protected Set<CDOID> checkinPostProcessing(InternalCDOTransaction remoteTransaction, List<CDORevisionKey> changedObjects) {
        HashSet<CDOID> ids = new HashSet<CDOID>();
        IStoreAccessor.Raw accessor = null;
        try {
            for (CDORevisionKey key : changedObjects) {
                CDOID id = key.getID();
                ids.add(id);
                InternalCDORevision localSessionRevision = (InternalCDORevision)this.getRevision(id);
                CDOBranch localSessionBranch = this.localSessionHead.getBranch();
                CDORevision baseRevision = this.base.getRevision(id);
                CDORevision remoteRevision = remoteTransaction.getObject(id).cdoRevision();
                EClass eClass = localSessionRevision.getEClass();
                int v = baseRevision.getVersion();
                while (v < localSessionRevision.getVersion()) {
                    accessor = this.beginRawAccess(accessor);
                    accessor.rawDelete(id, v, localSessionBranch, eClass, (OMMonitor)new Monitor());
                    ++v;
                }
                if (localSessionRevision.getVersion() == remoteRevision.getVersion()) continue;
                accessor = this.beginRawAccess(accessor);
                accessor.rawDelete(id, localSessionRevision.getVersion(), localSessionBranch, eClass, (OMMonitor)new Monitor());
                localSessionRevision.setBranchPoint(this.localRepositoryHead);
                localSessionRevision.setVersion(remoteRevision.getVersion());
                accessor.rawStore(localSessionRevision, (OMMonitor)new Monitor());
            }
        }
        finally {
            this.finishRawAccess(accessor);
        }
        return ids;
    }

    private IStoreAccessor.Raw beginRawAccess(IStoreAccessor.Raw accessor) {
        if (accessor == null) {
            accessor = this.getLocalWriter(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        }
        return accessor;
    }

    private void finishRawAccess(IStoreAccessor.Raw accessor) {
        if (accessor != null) {
            accessor.rawCommit(1.0, (OMMonitor)new Monitor());
            StoreThreadLocal.release();
            this.localRepository.getRevisionManager().getCache().clear();
        }
    }

    @Deprecated
    protected CDOIDMapper getIDMapper(InternalCDOTransaction transaction, final Map<CDOID, CDOID> idMappings) {
        if (idMappings.isEmpty()) {
            return null;
        }
        transaction.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOTransactionFinishedEvent) {
                    CDOTransactionFinishedEvent e = (CDOTransactionFinishedEvent)event;
                    Map remoteMappings = e.getIDMappings();
                    for (Map.Entry entry : idMappings.entrySet()) {
                        CDOID tempID = (CDOID)entry.getValue();
                        CDOID newID = (CDOID)remoteMappings.get(tempID);
                        entry.setValue(newID);
                    }
                }
            }
        });
        return new CDOIDMapper(idMappings);
    }

    @Deprecated
    protected void adjustLocalIDs(CDOIDMapper idMapper, List<CDOID> adjustedObjects) {
        Map idMappings = idMapper.getIDMappings();
        if (!idMappings.isEmpty()) {
            CDOTransaction transaction = null;
            Monitor monitor = new Monitor();
            try {
                transaction = this.localSession.openTransaction();
                InternalSession repoSession = this.localRepository.getSessionManager().getSession(this.localSession.getSessionID());
                ITransaction repoTransaction = (ITransaction)repoSession.getView(transaction.getViewID());
                IStoreAccessor.Raw accessor = this.getLocalWriter(repoTransaction);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                monitor.begin((double)(idMappings.size() * 2 + adjustedObjects.size() * 2 + 10));
                for (Map.Entry entry : idMappings.entrySet()) {
                    CDOID id = (CDOID)entry.getKey();
                    InternalCDORevision revision = accessor.readRevision(id, this.localSessionHead, -1, null);
                    int version = revision.getVersion();
                    InternalCDOBranch branch = revision.getBranch();
                    EClass eClass = revision.getEClass();
                    CDOID newID = (CDOID)entry.getValue();
                    revision.setID(newID);
                    revision.setVersion(1);
                    accessor.rawDelete(id, version, (CDOBranch)branch, eClass, monitor.fork());
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                    accessor.rawStore(revision, monitor.fork());
                }
                for (CDOID id : adjustedObjects) {
                    InternalCDORevision revision = accessor.readRevision(id, this.localSessionHead, -1, null);
                    int version = revision.getVersion();
                    InternalCDOBranch branch = revision.getBranch();
                    EClass eClass = revision.getEClass();
                    accessor.rawDelete(id, version, (CDOBranch)branch, eClass, monitor.fork());
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                    accessor.rawStore(revision, monitor.fork());
                }
                accessor.rawCommit(1.0, monitor.fork(10.0));
            }
            finally {
                monitor.done();
                StoreThreadLocal.release();
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    @Override
    public CDOChangeSetData compare(String branchPath) {
        return this.compare(branchPath, 0L);
    }

    @Override
    public CDOChangeSetData compare(String branchPath, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        LifecycleUtil.deactivate((Object)this.localSession);
        this.localSession = null;
        this.localSessionHead = null;
        LifecycleUtil.deactivate((Object)this.localRepository);
        this.localRepository = null;
        this.localRepositoryHead = null;
        LifecycleUtil.deactivate((Object)this.container);
        this.container = null;
    }

    public synchronized boolean isClosed() {
        return this.container == null;
    }

    public CDORevision getRevision(CDOID id) {
        InternalCDOSession session = this.getLocalSession();
        InternalCDORevisionManager revisionManager = session.getRevisionManager();
        return revisionManager.getRevision(id, this.localSessionHead, -1, 0, true);
    }

    @Override
    public InternalRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public synchronized InternalCDOSession getLocalSession() {
        if (this.localSession == null) {
            this.localSession = this.openLocalSession();
        }
        return this.localSession;
    }

    @Override
    public CDOChangeSetData getLocalChanges() {
        return this.getLocalChanges(true);
    }

    @Override
    public CDOChangeSetData getLocalChanges(boolean forward) {
        Set<CDOID> ids = this.base.getIDs();
        if (forward) {
            return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)this.base, (CDORevisionProvider)this, (boolean)true);
        }
        return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)this, (CDORevisionProvider)this.base, (boolean)true);
    }

    @Override
    public CDOSessionConfigurationFactory getRemoteSessionConfigurationFactory() {
        return this.remoteSessionConfigurationFactory;
    }

    @Override
    public IManagedContainer getContainer() {
        return this.container;
    }

    protected IManagedContainer createContainer(IStore store) {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        return container;
    }

    protected String getLocalAcceptorName() {
        return "acceptor-for-" + this.localRepository.getUUID();
    }

    protected IJVMAcceptor getLocalAcceptor() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getAcceptor((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected IJVMConnector getLocalConnector() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getConnector((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected IStoreAccessor.Raw getLocalWriter(ITransaction transaction) {
        return (IStoreAccessor.Raw)this.localRepository.getStore().getWriter(transaction);
    }

    protected InternalRepository createLocalRepository(String localRepositoryName, IStore store) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", "false");
        props.put("supportingBranches", "false");
        props.put("idGenerationLocation", this.idGenerationLocation.toString());
        Repository.Default repository = new Repository.Default(){

            public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
                if (CDOWorkspaceImpl.this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.STORE) {
                    branchManager.initMainBranch(true, timeStamp);
                } else {
                    super.initMainBranch(branchManager, timeStamp);
                }
            }

            protected void initRootResource() {
                this.setState(CDOCommonRepository.State.INITIAL);
            }
        };
        repository.setName(localRepositoryName);
        repository.setStore((InternalStore)store);
        repository.setProperties(props);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)repository);
        return repository;
    }

    protected InternalCDOSession openLocalSession() {
        this.getLocalAcceptor();
        IJVMConnector connector = this.getLocalConnector();
        String repositoryName = this.localRepository.getName();
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName(repositoryName);
        configuration.setIDGenerator(this.idGenerator);
        configuration.setRevisionManager(CDORevisionUtil.createRevisionManager((CDORevisionCache)CDORevisionCache.NOOP));
        if (this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.STORE) {
            ((InternalCDOSessionConfiguration)configuration).setMainBranchLocal(true);
        }
        InternalCDOSession session = (InternalCDOSession)configuration.openNet4jSession();
        this.setWorkspaceProperty((IPropertiesContainer)session);
        ISignalProtocol protocol = (ISignalProtocol)session.getSessionProtocol();
        protocol.setTimeout(-1L);
        this.localSessionHead = session.getBranchManager().getMainBranch().getHead();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    protected InternalCDOSession openRemoteSession() {
        InternalCDOBranch branch;
        CDORepositoryInfo repositoryInfo;
        CDOSessionConfiguration configuration = this.remoteSessionConfigurationFactory.createSessionConfiguration();
        InternalCDOSession remoteSession = (InternalCDOSession)configuration.openSession();
        if (configuration instanceof Closeable) {
            Closeable closeable = (Closeable)configuration;
            this.closeables.put(remoteSession, closeable);
        }
        if (!(repositoryInfo = remoteSession.getRepositoryInfo()).isSupportingAudits()) {
            remoteSession.close();
            throw new IllegalStateException("Remote repository does not support auditing");
        }
        CDOCommonRepository.IDGenerationLocation remoteLocation = repositoryInfo.getIDGenerationLocation();
        if (!remoteLocation.equals((Object)this.idGenerationLocation)) {
            remoteSession.close();
            throw new IllegalStateException("Remote repository uses different ID generation location: " + remoteLocation);
        }
        InternalCDOBranchManager branchManager = remoteSession.getBranchManager();
        boolean changed = false;
        if (this.branchID == -1) {
            branch = branchManager.getBranch(this.branchPath);
            this.branchID = branch.getID();
            changed = true;
        } else {
            branch = branchManager.getBranch(this.branchID);
        }
        String pathName = branch.getPathName();
        if (!ObjectUtil.equals((Object)pathName, (Object)this.branchPath)) {
            this.branchPath = pathName;
            changed = true;
        }
        if (changed) {
            this.saveProperties();
        }
        return remoteSession;
    }

    protected void closeRemoteSession(InternalCDOSession remoteSession) {
        Closeable closeable = this.closeables.remove(remoteSession);
        if (closeable != null) {
            closeable.close();
        } else {
            LifecycleUtil.deactivate((Object)remoteSession);
        }
    }

    protected void setTimeStamp(long timeStamp) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_TIME_STAMP, String.valueOf(timeStamp));
        this.localRepository.getStore().setPersistentProperties(props);
        this.timeStamp = timeStamp;
    }

    protected void saveProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_BRANCH_ID, String.valueOf(this.branchID));
        props.put(PROP_BRANCH_PATH, this.branchPath);
        props.put(PROP_TIME_STAMP, String.valueOf(this.timeStamp));
        props.put(PROP_FIXED, String.valueOf(this.fixed));
        this.localRepository.getStore().setPersistentProperties(props);
    }

    protected void loadProperties() {
        HashSet<String> names = new HashSet<String>(Arrays.asList(PROP_BRANCH_ID, PROP_BRANCH_PATH, PROP_TIME_STAMP, PROP_FIXED));
        Map props = this.localRepository.getStore().getPersistentProperties(names);
        String prop = (String)props.get(PROP_BRANCH_ID);
        this.branchID = prop == null ? -1 : Integer.parseInt(prop);
        this.branchPath = (String)props.get(PROP_BRANCH_PATH);
        this.timeStamp = Long.parseLong((String)props.get(PROP_TIME_STAMP));
        this.fixed = Boolean.parseBoolean((String)props.get(PROP_FIXED));
    }

    private void addIDs(Set<CDOID> result, Set<CDOID> ids) {
        result.addAll(ids);
    }

    private void addIDs(Set<CDOID> result, Map<CDOID, ?> map) {
        this.addIDs(result, map.keySet());
    }

    private void addIDs(Set<CDOID> ids, List<? extends CDOIDAndVersion> keys) {
        for (CDOIDAndVersion cDOIDAndVersion : keys) {
            ids.add(cDOIDAndVersion.getID());
        }
    }

    private void addIDs(Set<CDOID> ids, CDOChangeSetData changeSetData) {
        this.addIDs(ids, changeSetData.getNewObjects());
        this.addIDs(ids, changeSetData.getChangedObjects());
        this.addIDs(ids, changeSetData.getDetachedObjects());
    }

    private void addIDs(Set<CDOID> result, CDOCommitContext commitContext) {
        this.addIDs(result, commitContext.getNewObjects());
        this.addIDs(result, commitContext.getDirtyObjects());
        this.addIDs(result, commitContext.getDetachedObjects());
    }

    private class BaseRevisionProvider
    implements CDORevisionProvider {
        private BaseRevisionProvider() {
        }

        public CDORevision getRevision(CDOID id) {
            CDORevision revision = CDOWorkspaceImpl.this.base.getRevision(id);
            if (revision == null) {
                revision = CDOWorkspaceImpl.this.getRevision(id);
            }
            return revision;
        }
    }

    private static final class DirtyStateChangedEventImpl
    extends Event
    implements CDOWorkspace.DirtyStateChangedEvent {
        private static final long serialVersionUID = 1L;
        private final boolean dirty;

        public DirtyStateChangedEventImpl(CDOWorkspace workspace, boolean dirty) {
            super((INotifier)workspace);
            this.dirty = dirty;
        }

        @Override
        public CDOWorkspace getSource() {
            return (CDOWorkspace)super.getSource();
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }
    }

    private static final class ObjectStatesChangedEventImpl
    extends Event
    implements CDOWorkspace.ObjectStatesChangedEvent {
        private static final long serialVersionUID = 1L;
        private final Set<CDOID> changedIDs;

        public ObjectStatesChangedEventImpl(CDOWorkspace workspace, Set<CDOID> changedIDs) {
            super((INotifier)workspace);
            this.changedIDs = changedIDs;
        }

        @Override
        public CDOWorkspace getSource() {
            return (CDOWorkspace)super.getSource();
        }

        @Override
        public Set<CDOID> getChangedIDs() {
            return this.changedIDs;
        }
    }

    public final class ViewAdapter
    extends LifecycleEventAdapter {
        public CDOWorkspace getWorkspace() {
            return CDOWorkspaceImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle view) {
            Set set = CDOWorkspaceImpl.this.views;
            synchronized (set) {
                CDOWorkspaceImpl.this.views.remove(view);
            }
        }
    }
}

