/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace;

import java.io.File;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.workspace.CDOWorkspaceConfigurationImpl;
import org.eclipse.emf.cdo.internal.workspace.CDOWorkspaceImpl;
import org.eclipse.emf.cdo.internal.workspace.FolderCDOWorkspaceBase;
import org.eclipse.emf.cdo.internal.workspace.WorkspaceProperties;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase2;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.properties.IProperties;

public final class CDOWorkspaceUtil {
    private CDOWorkspaceUtil() {
    }

    public static IProperties<CDOWorkspace> getProperties() {
        return WorkspaceProperties.INSTANCE;
    }

    public static CDOWorkspace getWorkspace(EObject object) {
        CDOView view = CDOUtil.getCDOObject((EObject)object).cdoView();
        if (view == null || view.isClosed()) {
            return null;
        }
        IListener[] listeners = view.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                IListener listener = listeners[i];
                if (listener instanceof CDOWorkspaceImpl.ViewAdapter) {
                    CDOWorkspaceImpl.ViewAdapter adapter = (CDOWorkspaceImpl.ViewAdapter)listener;
                    return adapter.getWorkspace();
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isDirty(EObject object) {
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
        if (object == null) {
            return false;
        }
        CDOWorkspace workspace = CDOWorkspaceUtil.getWorkspace((EObject)cdoObject);
        CDOWorkspaceBase2 base = CDOWorkspaceUtil.getWorkspaceBase2(workspace.getBase());
        return base.containsID(cdoObject.cdoID());
    }

    public static CDOWorkspaceBase2 getWorkspaceBase2(CDOWorkspaceBase base) {
        if (base instanceof CDOWorkspaceBase2) {
            return (CDOWorkspaceBase2)base;
        }
        return new DelegatingWorkspaceBase2(base);
    }

    public static CDOWorkspaceBase createFolderWorkspaceBase(File folder) {
        return new FolderCDOWorkspaceBase(folder);
    }

    public static CDOWorkspaceConfiguration createWorkspaceConfiguration() {
        return new CDOWorkspaceConfigurationImpl();
    }

    @Deprecated
    public static CDOWorkspace open(IStore local, CDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        CDOWorkspaceConfiguration config = CDOWorkspaceUtil.createWorkspaceConfiguration();
        config.setStore(local);
        config.setBase(base);
        config.setRemote(remote);
        return config.open();
    }

    @Deprecated
    public static CDOWorkspace checkout(IStore local, CDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        return CDOWorkspaceUtil.checkout(local, base, remote, null);
    }

    @Deprecated
    public static CDOWorkspace checkout(IStore local, CDOWorkspaceBase base, CDOSessionConfigurationFactory remote, String branchPath) {
        return CDOWorkspaceUtil.checkout(local, base, remote, branchPath, 0L);
    }

    @Deprecated
    public static CDOWorkspace checkout(IStore local, CDOWorkspaceBase base, CDOSessionConfigurationFactory remote, long timeStamp) {
        return CDOWorkspaceUtil.checkout(local, base, remote, null, timeStamp);
    }

    @Deprecated
    public static CDOWorkspace checkout(IStore local, CDOWorkspaceBase base, CDOSessionConfigurationFactory remote, String branchPath, long timeStamp) {
        CDOWorkspaceConfiguration config = CDOWorkspaceUtil.createWorkspaceConfiguration();
        config.setStore(local);
        config.setBase(base);
        config.setRemote(remote);
        config.setBranchPath(branchPath);
        config.setTimeStamp(timeStamp);
        return config.checkout();
    }

    private static final class DelegatingWorkspaceBase2
    implements CDOWorkspaceBase2 {
        private final CDOWorkspaceBase delegate;

        private DelegatingWorkspaceBase2(CDOWorkspaceBase base) {
            this.delegate = base;
        }

        @Override
        public CDOWorkspace getWorkspace() {
            return this.delegate.getWorkspace();
        }

        @Override
        public Set<CDOID> getIDs() {
            return this.delegate.getIDs();
        }

        public CDORevision getRevision(CDOID id) {
            return this.delegate.getRevision(id);
        }

        @Override
        public boolean isEmpty() {
            return this.getIDs().isEmpty();
        }

        @Override
        public boolean containsID(CDOID id) {
            return this.getIDs().contains(id);
        }

        @Override
        public boolean isAddedObject(CDOID id) {
            return this.containsID(id) && this.getRevision(id) == null;
        }
    }
}

