/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.handles.RotateHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RotateTracker;
import org.eclipse.gmf.runtime.gef.ui.internal.requests.RotateShapeRequest;

public class RotatableShapeEditPolicy
extends ResizableShapeEditPolicy {
    private static final int DEFAULT_TOLERANCE = 6;

    protected List createSelectionHandles() {
        this.setResizeDirections(29);
        List selectionhandles = super.createSelectionHandles();
        GraphicalEditPart part = (GraphicalEditPart)this.getHost();
        selectionhandles.add(this.createRotationHandle(part, 20));
        selectionhandles.add(this.createRotationHandle(part, 12));
        selectionhandles.add(this.createRotationHandle(part, 9));
        selectionhandles.add(this.createRotationHandle(part, 17));
        return selectionhandles;
    }

    protected Handle createRotationHandle(GraphicalEditPart owner, int direction) {
        RotateHandle handle = new RotateHandle(owner, direction);
        handle.setDragTracker((DragTracker)new RotateTracker(owner, direction));
        return handle;
    }

    @Override
    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.isRotationRequired(request)) {
            IFigure feedback = this.getDragSourceFeedbackFigure();
            if (this.doRotation(request)) {
                PrecisionRectangle rect = this.getAbsoluteRotatedBounds();
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            } else {
                PrecisionRectangle initFigure = this.getAbsoluteInitialBounds();
                feedback.translateToRelative((Translatable)initFigure);
                feedback.setBounds((Rectangle)initFigure);
            }
        } else {
            super.showChangeBoundsFeedback(request);
        }
    }

    private PrecisionRectangle rotateRectangle(Rectangle r) {
        PrecisionRectangle rect = new PrecisionRectangle(r);
        if (this.isVertical(r)) {
            rect.setX(rect.preciseX - rect.preciseHeight / 2.0 + rect.preciseWidth / 2.0);
            rect.setY(rect.preciseY + rect.preciseHeight / 2.0 - rect.preciseWidth / 2.0);
        } else {
            rect.setX(rect.preciseX + rect.preciseWidth / 2.0 - rect.preciseHeight / 2.0);
            rect.setY(rect.preciseY - rect.preciseWidth / 2.0 + rect.preciseHeight / 2.0);
        }
        this.transposePrecisionRectangleSize(rect);
        return rect;
    }

    private boolean isVertical(Rectangle r) {
        return r.height > r.width;
    }

    private void transposePrecisionRectangleSize(PrecisionRectangle r) {
        double height = r.preciseHeight;
        r.setHeight(r.preciseWidth);
        r.setWidth(height);
    }

    private boolean isRotationRequired(ChangeBoundsRequest request) {
        return request instanceof RotateShapeRequest ? ((RotateShapeRequest)request).shouldRotate() : false;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        if (this.isRotationRequired(request)) {
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
            req.setEditParts(this.getHost());
            if (this.doRotation(request)) {
                PrecisionRectangle rect = this.getAbsoluteRotatedBounds();
                PrecisionRectangle initFigure = this.getAbsoluteInitialBounds();
                req.setMoveDelta(new Point(rect.preciseX - initFigure.preciseX, rect.preciseY - initFigure.preciseY));
                req.setSizeDelta(new Dimension(rect.width - initFigure.width, rect.height - initFigure.height));
            } else {
                req.setSizeDelta(new Dimension());
                req.setMoveDelta(new Point());
            }
            req.setLocation(request.getLocation());
            req.setExtendedData(request.getExtendedData());
            req.setResizeDirection(request.getResizeDirection());
            return this.getHost().getParent().getCommand((Request)req);
        }
        return super.getResizeCommand(request);
    }

    private boolean doRotation(ChangeBoundsRequest request) {
        return Math.abs(request.getSizeDelta().width) > 6 || Math.abs(request.getSizeDelta().height) > 6;
    }

    private PrecisionRectangle getAbsoluteInitialBounds() {
        PrecisionRectangle initFigure = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)initFigure);
        return initFigure;
    }

    private PrecisionRectangle getAbsoluteRotatedBounds() {
        PrecisionRectangle rect = new PrecisionRectangle((Rectangle)this.rotateRectangle(this.getInitialFeedbackBounds().getCopy()));
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }
}

