/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit5.runner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.internal.junit.runner.FailedComparison;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;
import org.eclipse.jdt.internal.junit5.runner.JUnit5Identifier;
import org.junit.ComparisonFailure;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.ValueWrapper;

public class JUnit5TestListener
implements TestExecutionListener {
    private final IListensToTestExecutions fNotified;
    private RemoteTestRunner fRemoteTestRunner;
    private TestPlan fTestPlan;

    public JUnit5TestListener(IListensToTestExecutions notified, RemoteTestRunner remoteTestRunner) {
        this.fNotified = notified;
        this.fRemoteTestRunner = remoteTestRunner;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.fTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.fTestPlan = null;
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.fNotified.notifyTestStarted(this.getIdentifier(testIdentifier, false, false));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.notifyIfNotSuccessful(testIdentifier, testExecutionResult);
        if (testIdentifier.isTest()) {
            this.fNotified.notifyTestEnded(this.getIdentifier(testIdentifier, false, false));
        }
    }

    private void notifyIfNotSuccessful(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status result = testExecutionResult.getStatus();
        if (result != TestExecutionResult.Status.SUCCESSFUL) {
            String trace = "";
            FailedComparison comparison = null;
            String status = "%FAILED ";
            boolean assumptionFailed = result == TestExecutionResult.Status.ABORTED;
            Optional throwableOp = testExecutionResult.getThrowable();
            if (throwableOp.isPresent()) {
                Throwable exception = (Throwable)throwableOp.get();
                trace = this.getTrace(exception);
                comparison = this.getFailedComparison(exception);
                status = assumptionFailed || exception instanceof AssertionError ? "%FAILED " : "%ERROR  ";
            }
            ITestIdentifier identifier = this.getIdentifier(testIdentifier, false, assumptionFailed);
            this.fNotified.notifyTestFailed(new TestReferenceFailure(identifier, status, trace, comparison));
        }
    }

    private String getTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    private FailedComparison getFailedComparison(Throwable exception) {
        if (exception instanceof AssertionFailedError) {
            AssertionFailedError assertionFailedError = (AssertionFailedError)exception;
            ValueWrapper expected = assertionFailedError.getExpected();
            ValueWrapper actual = assertionFailedError.getActual();
            if (expected == null || actual == null) {
                return null;
            }
            return new FailedComparison(expected.getStringRepresentation(), actual.getStringRepresentation());
        }
        if (exception instanceof MultipleFailuresError) {
            return this.getComparisonForMultipleFailures(exception);
        }
        String classname = exception.getClass().getName();
        if (classname.equals("junit.framework.ComparisonFailure")) {
            junit.framework.ComparisonFailure comparisonFailure = (junit.framework.ComparisonFailure)exception;
            return new FailedComparison(comparisonFailure.getExpected(), comparisonFailure.getActual());
        }
        if (classname.equals("org.junit.ComparisonFailure")) {
            ComparisonFailure comparisonFailure = (ComparisonFailure)exception;
            return new FailedComparison(comparisonFailure.getExpected(), comparisonFailure.getActual());
        }
        return null;
    }

    protected FailedComparison getComparisonForMultipleFailures(Throwable exception) {
        String expectedStr = "";
        String actualStr = "";
        String delimiter = "\n\n";
        List failures = ((MultipleFailuresError)exception).getFailures();
        for (Throwable assertionError : failures) {
            String actual;
            String expected;
            if (assertionError instanceof MultipleFailuresError) {
                FailedComparison failedComparison = this.getComparisonForMultipleFailures(assertionError);
                if (failedComparison == null) {
                    return null;
                }
                expected = failedComparison.getExpected();
                actual = failedComparison.getActual();
                if (expected == null || actual == null) {
                    return null;
                }
                expectedStr = String.valueOf(expectedStr) + expected;
                actualStr = String.valueOf(actualStr) + actual;
                continue;
            }
            if (assertionError instanceof AssertionFailedError) {
                AssertionFailedError assertionFailedError = (AssertionFailedError)assertionError;
                expected = assertionFailedError.getExpected();
                actual = assertionFailedError.getActual();
                if (expected == null || actual == null) {
                    return null;
                }
                expectedStr = String.valueOf(expectedStr) + expected.getStringRepresentation() + delimiter;
                actualStr = String.valueOf(actualStr) + actual.getStringRepresentation() + delimiter;
                continue;
            }
            return null;
        }
        return new FailedComparison(expectedStr, actualStr);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isContainer() && this.fTestPlan != null) {
            this.fTestPlan.getDescendants(testIdentifier).stream().filter(TestIdentifier::isTest).forEachOrdered(this::notifySkipped);
        } else {
            this.notifySkipped(testIdentifier);
        }
    }

    private void notifySkipped(TestIdentifier testIdentifier) {
        ITestIdentifier identifier = this.getIdentifier(testIdentifier, true, false);
        this.fNotified.notifyTestStarted(identifier);
        this.fNotified.notifyTestEnded(identifier);
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        if (this.fTestPlan != null) {
            int testCount;
            boolean hasChildren;
            JUnit5Identifier dynamicTestIdentifier = new JUnit5Identifier(testIdentifier);
            if (testIdentifier.isContainer()) {
                hasChildren = true;
                testCount = this.fTestPlan.getChildren(testIdentifier).size();
            } else {
                hasChildren = false;
                testCount = 1;
            }
            String parentId = this.getParentId(testIdentifier, this.fTestPlan);
            this.fRemoteTestRunner.visitTreeEntry((ITestIdentifier)dynamicTestIdentifier, hasChildren, testCount, true, parentId);
        }
    }

    private String getParentId(TestIdentifier testIdentifier, TestPlan testPlan) {
        return testPlan.getParent(testIdentifier).map(parent -> this.fRemoteTestRunner.getTestId((ITestIdentifier)new JUnit5Identifier((TestIdentifier)parent))).orElse("-1");
    }

    private ITestIdentifier getIdentifier(TestIdentifier testIdentifier, boolean ignored, boolean assumptionFailed) {
        if (ignored) {
            return new IgnoredTestIdentifier(testIdentifier);
        }
        if (assumptionFailed) {
            return new AssumptionFailedTestIdentifier(testIdentifier);
        }
        return new JUnit5Identifier(testIdentifier);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        System.out.println(String.valueOf(TestIdentifier.class.getSimpleName()) + " [" + testIdentifier.getDisplayName() + "]");
        System.out.println(entry);
    }

    private static class AssumptionFailedTestIdentifier
    extends JUnit5Identifier {
        public AssumptionFailedTestIdentifier(TestIdentifier description) {
            super(description);
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@AssumptionFailure: " + name;
            }
            return null;
        }
    }

    private static class IgnoredTestIdentifier
    extends JUnit5Identifier {
        public IgnoredTestIdentifier(TestIdentifier description) {
            super(description);
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@Ignore: " + name;
            }
            return null;
        }
    }
}

