/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.platform;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;

public class ResourceAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaPlatform.Config.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IResource) {
            return this.getAdapter((IResource)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IResource resource, Class<?> adapterType) {
        if (adapterType == JpaPlatform.Config.class) {
            return this.getJpaPlatformConfig(resource);
        }
        return null;
    }

    private JpaPlatform.Config getJpaPlatformConfig(IResource resource) {
        JpaPlatformManager jpaPlatformManager = this.getJpaPlatformManager(resource.getWorkspace());
        return jpaPlatformManager == null ? null : jpaPlatformManager.getJpaPlatformConfig(JpaPreferences.getJpaPlatformID(resource.getProject()));
    }

    private JpaPlatformManager getJpaPlatformManager(IWorkspace workspace) {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace(workspace);
        return jpaWorkspace == null ? null : jpaWorkspace.getJpaPlatformManager();
    }

    private JpaWorkspace getJpaWorkspace(IWorkspace workspace) {
        return (JpaWorkspace)workspace.getAdapter(JpaWorkspace.class);
    }
}

