/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.NodeTargetCalculator;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;

public class TCEditorDndSupport
extends AbstractEditorDndSupport {
    private static String reportMessage = "";

    private TCEditorDndSupport() {
    }

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        Iterator iter = selectedElements.iterator();
        while (iter.hasNext()) {
            IExecTestCasePO droppedNode = null;
            Object obj = iter.next();
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO node = (INodePO)obj;
            boolean exp = targetEditor.getTreeViewer().getExpandedState((Object)dropTarget);
            if (!(node instanceof ISpecTestCasePO)) {
                NodeTargetCalculator.NodeTarget tar = NodeTargetCalculator.calcNodeTarget(node, dropTarget, dropPosition, exp);
                if (tar != null) {
                    droppedNode = TCEditorDndSupport.moveNode(node, tar.getNode(), tar.getPos());
                }
            } else {
                droppedNode = TCEditorDndSupport.performDrop(targetEditor, dropTarget, dropPosition, (ISpecTestCasePO)node, exp);
                if (droppedNode == null) {
                    return false;
                }
            }
            TCEditorDndSupport.postDropAction((INodePO)droppedNode, targetEditor);
        }
        targetEditor.runLocalChecks();
        return true;
    }

    public static boolean copyPaste(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK || !(dropTarget.getSpecAncestor() instanceof ISpecTestCasePO)) {
            return false;
        }
        if (toDrop.isEmpty()) {
            return false;
        }
        ISpecTestCasePO targetSpecTC = (ISpecTestCasePO)dropTarget.getSpecAncestor();
        boolean noTCHandlers = false;
        INodePO last = null;
        for (Object obj : TCEditorDndSupport.getFullList(toDrop)) {
            IParamNodePO paramNode;
            if (!(obj instanceof INodePO)) {
                return false;
            }
            if (obj instanceof IEventExecTestCasePO) {
                last = TCEditorDndSupport.copyPasteEventExecTestCase(targetEditor, (IEventExecTestCasePO)obj, targetSpecTC);
                continue;
            }
            noTCHandlers = true;
            if (!(obj instanceof IParamNodePO) || targetSpecTC.equals((Object)(paramNode = (IParamNodePO)obj).getSpecAncestor()) || TCEditorDndSupport.checkParentParameters(targetSpecTC, paramNode, null, false)) continue;
            return false;
        }
        if (noTCHandlers) {
            NodeTargetCalculator.NodeTarget tar = NodeTargetCalculator.calcNodeTarget((INodePO)toDrop.getFirstElement(), dropTarget, 3, false);
            last = TCEditorDndSupport.copyPasteNodes(targetEditor, tar.getNode(), toDrop.toList(), tar.getPos());
        }
        TCEditorDndSupport.postDropAction(last, targetEditor);
        targetEditor.runLocalChecks();
        return true;
    }

    private static INodePO copyPasteNodes(AbstractTestCaseEditor editor, INodePO target, List<INodePO> nodes, int fromPos) {
        ParamNameBPDecorator pMapper = editor.getEditorHelper().getEditSupport().getParamMapper();
        int pos = fromPos;
        INodePO last = null;
        for (INodePO node : nodes) {
            if (node instanceof ICapPO) {
                last = TCEditorDndSupport.copyPasteCap(editor, (ICapPO)node, target, pos);
            } else if (node instanceof IExecTestCasePO) {
                last = TCEditorDndSupport.copyPasteExecTestCase(editor, (IExecTestCasePO)node, target, pos);
            } else if (node instanceof ICommentPO) {
                ICommentPO comm = NodeMaker.createCommentPO((String)((ICommentPO)node).getName());
                TCEditorDndSupport.fillNode(node, (INodePO)comm);
                target.addNode(pos, (INodePO)comm);
                last = comm;
            } else if (node instanceof IControllerPO) {
                IControllerPO controller = NodeMaker.createControllerPO((IControllerPO)((IControllerPO)node));
                List nodeList = node.getUnmodifiableNodeList();
                List contList = controller.getUnmodifiableNodeList();
                if (node instanceof IParamNodePO) {
                    TCEditorDndSupport.fillParamNode((IParamNodePO)node, (IParamNodePO)controller);
                    TCEditorDndSupport.checkParentParameters((ISpecTestCasePO)target.getSpecAncestor(), (IParamNodePO)controller, pMapper, true);
                } else {
                    TCEditorDndSupport.fillNode(node, (INodePO)controller);
                }
                target.addNode(pos, (INodePO)controller);
                int i = 0;
                while (i < nodeList.size()) {
                    TCEditorDndSupport.copyPasteNodes(editor, (INodePO)contList.get(i), ((INodePO)nodeList.get(i)).getUnmodifiableNodeList(), 0);
                    ++i;
                }
                last = controller;
            }
            ++pos;
        }
        return last;
    }

    public static INodePO copyPasteEventExecTestCase(AbstractTestCaseEditor targetEditor, IEventExecTestCasePO origEvent, ISpecTestCasePO targetNode) {
        IEventExecTestCasePO newEvent = null;
        if (targetNode.getEventExecTcMap().containsKey(origEvent.getEventType())) {
            boolean status = MessageDialog.openQuestion(null, (String)Messages.DoubleEventTypeTitle, (String)NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetailOverwrite, (Object[])new Object[]{targetNode.getName(), I18n.getString((String)origEvent.getEventType())}));
            if (status) {
                targetNode.getEventExecTcMap().remove(origEvent.getEventType());
            } else {
                return null;
            }
        }
        EditSupport editSupport = targetEditor.getEditorHelper().getEditSupport();
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        if (targetNode.equals((Object)origEvent.getParentNode()) || TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)origEvent, pMapper, false)) {
            try {
                newEvent = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)origEvent.getSpecTestCase(), (INodePO)targetNode);
                TCEditorDndSupport.fillExec((IExecTestCasePO)origEvent, (IExecTestCasePO)newEvent, false);
                TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)newEvent, pMapper, true);
                TestCaseBP.addEventHandler((EditSupport)editSupport, (ISpecTestCasePO)targetNode, (IEventExecTestCasePO)newEvent);
                targetEditor.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newEvent, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
            }
            catch (InvalidDataException invalidDataException) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DOUBLE_EVENT, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetail, (Object[])new Object[]{targetNode.getName(), I18n.getString((String)origEvent.getEventType())})});
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
        } else {
            return null;
        }
        return newEvent;
    }

    public static INodePO copyPasteExecTestCase(AbstractTestCaseEditor targetEditor, IExecTestCasePO execTestCase, INodePO targetNode, int dropPosition) {
        IExecTestCasePO newExecTestCase = NodeMaker.createExecTestCasePO((ISpecTestCasePO)execTestCase.getSpecTestCase());
        TCEditorDndSupport.fillExec(execTestCase, newExecTestCase, false);
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        TCEditorDndSupport.checkParentParameters((ISpecTestCasePO)targetNode.getSpecAncestor(), (IParamNodePO)newExecTestCase, pMapper, true);
        TestCaseBP.addReferencedTestCase((INodePO)targetNode, (IExecTestCasePO)newExecTestCase, (Integer)dropPosition);
        targetEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newExecTestCase, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        return newExecTestCase;
    }

    public static INodePO copyPasteCap(AbstractTestCaseEditor targetEditor, ICapPO cap, INodePO targetNode, int dropPosition) {
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        ICapPO newCap = CapBP.createCapWithDefaultParams((String)cap.getName(), (String)cap.getComponentName(), (String)cap.getComponentType(), (String)cap.getActionName());
        TCEditorDndSupport.fillCap(cap, newCap);
        newCap.setParentNode(targetNode);
        targetNode.addNode(dropPosition, (INodePO)newCap);
        TCEditorDndSupport.checkParentParameters((ISpecTestCasePO)targetNode.getSpecAncestor(), (IParamNodePO)newCap, pMapper, true);
        targetEditor.getTreeViewer().expandToLevel((Object)targetNode, 1);
        DataEventDispatcher.getInstance().fireParamChangedListener();
        return newCap;
    }

    private static IExecTestCasePO performDrop(AbstractTestCaseEditor targetEditor, INodePO dropTarget, int dropPosition, ISpecTestCasePO toDrop, boolean exp) {
        block9: {
            INodePO target = dropTarget;
            if (target != toDrop) {
                NodeTargetCalculator.NodeTarget tar;
                EditSupport editSupport;
                block8: {
                    editSupport = targetEditor.getEditorHelper().getEditSupport();
                    tar = NodeTargetCalculator.calcNodeTarget((INodePO)toDrop, dropTarget, dropPosition, exp);
                    if (tar != null) break block8;
                    return null;
                }
                try {
                    if (target instanceof ISpecTestCasePO) {
                        return TCEditorDndSupport.dropOnSpecTc(editSupport, (INodePO)toDrop, tar.getNode(), tar.getPos());
                    }
                    if (target instanceof ITestSuitePO) {
                        return TCEditorDndSupport.dropOnTestsuite(editSupport, (ITestSuitePO)target, toDrop, tar.getPos());
                    }
                    return TCEditorDndSupport.dropOnSgElse(editSupport, (INodePO)toDrop, tar.getNode(), tar.getPos());
                }
                catch (PMException e) {
                    NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                    INodePO inpNode = inp.getNode();
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    if (e instanceof PMAlreadyLockedException && ((PMAlreadyLockedException)((Object)e)).getLockedObject() != null && !((PMAlreadyLockedException)((Object)e)).getLockedObject().equals(inpNode) && targetEditor.isDirty()) break block9;
                    try {
                        targetEditor.reOpenEditor((IPersistentObject)inpNode);
                    }
                    catch (PMException pMException) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                    }
                }
            }
        }
        return null;
    }

    private static boolean checkParentParameters(ISpecTestCasePO targetNode, IParamNodePO paramNode, ParamNameBPDecorator pMapper, boolean create) {
        Iterator it = paramNode.getParamReferencesIterator();
        while (it.hasNext()) {
            TDCell cell = (TDCell)it.next();
            String guid = (String)paramNode.getDataManager().getUniqueIds().get(cell.getCol());
            IParamDescriptionPO childDesc = paramNode.getParameterForUniqueId(guid);
            if (childDesc == null) continue;
            ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), (IParameterInterfacePO)paramNode, childDesc);
            List refTokens = conv.getRefTokens();
            for (RefToken refToken : refTokens) {
                String oldGUID = RefToken.extractCore((String)refToken.getModelString());
                String paramName = ParamNameBP.getInstance().getName(oldGUID, childDesc.getParentProjectId());
                HashedMap oldToNewGuids = new HashedMap();
                IParamDescriptionPO parentParamDescr = targetNode.getParameterForName(paramName);
                if (parentParamDescr == null) {
                    if (create) {
                        targetNode.addParameter(childDesc.getType(), paramName, (IParamNameMapper)pMapper);
                        parentParamDescr = targetNode.getParameterForName(paramName);
                    }
                } else if (!parentParamDescr.getType().equals(childDesc.getType())) {
                    MessageDialog.openInformation(null, (String)Messages.ParameterConfligtDetectedTitle, (String)NLS.bind((String)Messages.ParameterConfligtDetected, (Object[])new Object[]{parentParamDescr.getName(), targetNode.getName()}));
                    return false;
                }
                if (!create) continue;
                if (parentParamDescr != null) {
                    String newGuid = parentParamDescr.getUniqueId();
                    oldToNewGuids.put(oldGUID, newGuid);
                }
                conv.replaceUuidsInReferences((Map)oldToNewGuids);
                cell.setTestData(conv.getModelString());
            }
        }
        return true;
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO dropTarget) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null || !(dropTarget.getSpecAncestor() instanceof ISpecTestCasePO)) {
            return false;
        }
        ISpecTestCasePO targSpecTC = (ISpecTestCasePO)dropTarget.getSpecAncestor();
        INodePO par = null;
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof INodePO)) {
                return false;
            }
            if (obj instanceof IControllerPO && !(dropTarget instanceof ISpecTestCasePO) && dropTarget.getParentNode() != targSpecTC) {
                return false;
            }
            INodePO dropNode = (INodePO)obj;
            if (par != null && !par.equals((Object)dropNode.getParentNode())) {
                return false;
            }
            ++n2;
        }
        for (Object obj : TCEditorDndSupport.getFullList(toDrop)) {
            INodePO dropNode = (INodePO)obj;
            par = dropNode.getParentNode();
            if (!(dropNode instanceof IExecTestCasePO) && !(dropNode instanceof ISpecTestCasePO) || targSpecTC.equals((Object)dropNode.getSpecAncestor())) continue;
            ISpecTestCasePO dropSpecTC = null;
            if (dropNode instanceof ISpecTestCasePO) {
                dropSpecTC = (ISpecTestCasePO)dropNode;
            } else if (dropNode instanceof IExecTestCasePO) {
                dropSpecTC = ((IExecTestCasePO)dropNode).getSpecTestCase();
            }
            if (!dropSpecTC.hasCircularDependencies((INodePO)targSpecTC)) continue;
            return false;
        }
        return true;
    }

    private static List getFullList(IStructuredSelection nodes) {
        ArrayList res = new ArrayList(nodes.size());
        for (Object next : nodes) {
            res.add(next);
            if (!(next instanceof IControllerPO)) continue;
            Iterator itC = ((INodePO)next).getAllNodeIter();
            while (itC.hasNext()) {
                res.add(itC.next());
            }
        }
        return res;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            boolean foundOne = false;
            for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                if (!sourceViewer.equals(tcb.getTreeViewer())) continue;
                foundOne = true;
            }
            if (!allowFromBrowser || !foundOne) {
                return false;
            }
        }
        for (Object obj : toDrop) {
            ISpecTestCasePO specTcGUI;
            if (!(obj instanceof INodePO) || obj instanceof IAbstractContainerPO) {
                return false;
            }
            if (obj instanceof IControllerPO && !(dropTarget instanceof ISpecTestCasePO) && !(dropTarget.getParentNode() instanceof ISpecTestCasePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)obj;
            if (!(transferGUI instanceof ISpecTestCasePO) && transferGUI.getSpecAncestor() != dropTarget.getSpecAncestor()) {
                return false;
            }
            if (!(transferGUI instanceof ISpecTestCasePO) || !transferGUI.hasCircularDependencies((INodePO)(specTcGUI = (ISpecTestCasePO)dropTarget.getSpecAncestor()))) continue;
            TCEditorDndSupport.reportCircularDependencies(transferGUI, specTcGUI);
            return false;
        }
        return true;
    }

    private static void reportCircularDependencies(INodePO transferGUI, ISpecTestCasePO specTcGUI) {
        Plugin plugin = Plugin.getDefault();
        if (transferGUI.getParentNode() != null) {
            String path = transferGUI.collectPathtoConflictNode((INodePO)specTcGUI);
            String message = "CIRCULAR DEPENDENCIES AT " + path + " FOUND TESTCASE NOT APPLIED";
            if (TCEditorDndSupport.getReportedMessage().equals(message)) {
                return;
            }
            TCEditorDndSupport.setReportedMessage(message);
            Status status = new Status(2, "org.eclipse.jubula.client.ui", message);
            plugin.writeStatus((IStatus)status, "org.eclipse.jubula.client.ui");
        }
    }

    private static IExecTestCasePO dropOnSpecTc(EditSupport editSupport, INodePO node, INodePO target, int pos) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)target, (ISpecTestCasePO)((ISpecTestCasePO)node), (Integer)pos);
    }

    private static IExecTestCasePO dropOnTestsuite(EditSupport editSupport, ITestSuitePO testSuite, ISpecTestCasePO testcase, int pos) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)testSuite, (ISpecTestCasePO)testcase, (Integer)pos);
    }

    private static IExecTestCasePO dropOnSgElse(EditSupport editSupport, INodePO node, INodePO target, int pos) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)target, (ISpecTestCasePO)((ISpecTestCasePO)node), (Integer)pos);
    }

    public static String getReportedMessage() {
        return reportMessage;
    }

    public static void setReportedMessage(String message) {
        reportMessage = message;
    }
}

