/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.swt.listener.BaseSwtEventListener;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusTracker
extends BaseSwtEventListener
implements BaseAUTListener {
    private static Logger log = LoggerFactory.getLogger(FocusTracker.class);
    private static Widget focusOwner = null;

    public long[] getEventMask() {
        return new long[]{15L, 16L};
    }

    public static Widget getFocusOwner() {
        if (focusOwner == null || focusOwner.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    focusOwner = (Widget)Display.getDefault().getFocusControl();
                }
            });
        }
        if (focusOwner == null || focusOwner.isDisposed()) {
            log.error("No Focus-Owner found!");
            throw new RobotException("No Focus-Owner found!", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        return focusOwner;
    }

    public void handleEvent(Event event) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Event: ", (Object)event);
                }
                switch (event.type) {
                    case 15: {
                        focusOwner = event.widget;
                        break;
                    }
                    case 16: {
                        focusOwner = null;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                log.error("exception during FocusTracker", t);
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }
}

