/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Random;
import org.eclipse.net4j.util.ReflectUtil;

public final class UUIDGenerator {
    public static final int NODE_ADDRESS_BYTES = 6;
    public static final UUIDGenerator DEFAULT = new UUIDGenerator();
    private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final byte[] BASE64_INDEX;
    private static final int BASE64_INDEX_OFFSET;
    private static final long EPOCH_ADJUSTMENT;
    private long lastTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
    private short clockSequence;
    private short timeAdjustment;
    private int sleepTime = 1;
    private final char[] buffer = this.createBuffer();
    private final byte[] uuid = this.createUUID();

    static {
        EPOCH_ADJUSTMENT = new GregorianCalendar(1970, 0, 1, 0, 0, 0).getTime().getTime() - new GregorianCalendar(1582, 9, 15, 0, 0, 0).getTime().getTime();
        byte[] index = new byte[256];
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < BASE64_DIGITS.length) {
            int digit = BASE64_DIGITS[i];
            if (digit < min) {
                min = digit;
            }
            if (digit > max) {
                max = digit;
            }
            index[digit] = i;
            i = (byte)(i + 1);
        }
        int length = max - min + 1;
        BASE64_INDEX = new byte[length];
        BASE64_INDEX_OFFSET = min;
        System.arraycopy(index, BASE64_INDEX_OFFSET, BASE64_INDEX, 0, length);
    }

    public UUIDGenerator(byte[] nodeAddress) {
        SecureRandom random = new SecureRandom();
        this.clockSequence = (short)random.nextInt(16384);
        this.updateClockSequence();
        if (nodeAddress == null) {
            try {
                nodeAddress = this.getHardwareAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (nodeAddress == null || nodeAddress.length != 6) {
                nodeAddress = new byte[6];
                ((Random)random).nextBytes(nodeAddress);
            }
        }
        this.setNodeAddress(nodeAddress);
    }

    public UUIDGenerator() {
        this(null);
    }

    public synchronized String generate() {
        this.updateCurrentTime();
        this.encode(this.uuid, this.buffer);
        return new String(this.buffer);
    }

    public synchronized void generate(byte[] uuid) {
        this.updateCurrentTime();
        int i = 0;
        while (i < 16) {
            uuid[i] = this.uuid[i];
            ++i;
        }
    }

    public String encode(byte[] uuid) {
        char[] buffer = this.createBuffer();
        this.encode(uuid, buffer);
        return new String(buffer);
    }

    public byte[] decode(String string) {
        byte i2;
        byte i1;
        char c2;
        char c1;
        byte[] uuid = this.createUUID();
        int i = 0;
        while (i < 5) {
            c1 = string.charAt(4 * i + 1);
            c2 = string.charAt(4 * i + 2);
            char c3 = string.charAt(4 * i + 3);
            char c4 = string.charAt(4 * i + 4);
            i1 = BASE64_INDEX[c1 - BASE64_INDEX_OFFSET];
            i2 = BASE64_INDEX[c2 - BASE64_INDEX_OFFSET];
            byte i3 = BASE64_INDEX[c3 - BASE64_INDEX_OFFSET];
            byte i4 = BASE64_INDEX[c4 - BASE64_INDEX_OFFSET];
            uuid[3 * i] = (byte)(i1 << 2 | i2 >>> 4);
            uuid[3 * i + 1] = (byte)((i2 & 0xF) << 4 | i3 >>> 2);
            uuid[3 * i + 2] = (byte)((i3 & 3) << 6 | i4);
            ++i;
        }
        c1 = string.charAt(21);
        c2 = string.charAt(22);
        i1 = BASE64_INDEX[c1 - BASE64_INDEX_OFFSET];
        i2 = BASE64_INDEX[c2 - BASE64_INDEX_OFFSET];
        uuid[15] = (byte)(i1 << 2 | i2 >>> 4);
        return uuid;
    }

    private byte[] getHardwareAddress() throws Throwable {
        Method method = ReflectUtil.getMethod(NetworkInterface.class, "getHardwareAddress", new Class[0]);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            try {
                byte[] nodeAddress = (byte[])ReflectUtil.invokeMethod(method, networkInterface, new Object[0]);
                if (nodeAddress == null || nodeAddress.length != 6) continue;
                return nodeAddress;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new SocketException("Hardware address could not be determined");
    }

    private void setNodeAddress(byte[] nodeAddress) {
        nodeAddress[0] = (byte)(nodeAddress[0] | 0xFFFFFF80);
        int i = 0;
        while (i < 6) {
            this.uuid[i + 10] = nodeAddress[i];
            ++i;
        }
    }

    private void updateClockSequence() {
        this.uuid[8] = (byte)(this.clockSequence >> 8 & 0x3F | 0x80);
        this.uuid[9] = (byte)(this.clockSequence & 0xFF);
    }

    private void updateCurrentTime() {
        long currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
        if (this.lastTime > currentTime) {
            this.clockSequence = (short)(this.clockSequence + 1);
            if (16384 == this.clockSequence) {
                this.clockSequence = 0;
            }
            this.updateClockSequence();
        } else if (this.lastTime == currentTime) {
            this.timeAdjustment = (short)(this.timeAdjustment + 1);
            if (this.timeAdjustment > 9999) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.timeAdjustment = 0;
                currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
                while (this.lastTime == currentTime) {
                    try {
                        ++this.sleepTime;
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
                }
            }
        } else {
            this.timeAdjustment = 0;
        }
        this.lastTime = currentTime;
        currentTime *= 10000L;
        currentTime += (long)this.timeAdjustment;
        currentTime |= 0x1000000000000000L;
        int i = 0;
        while (i < 4) {
            this.uuid[i] = (byte)(currentTime >> 8 * (3 - i) & 0xFFL);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.uuid[i + 4] = (byte)(currentTime >> 8 * (1 - i) + 32 & 0xFFL);
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.uuid[i + 6] = (byte)(currentTime >> 8 * (1 - i) + 48 & 0xFFL);
            ++i;
        }
    }

    private void encode(byte[] uuid, char[] buffer) {
        int i = 0;
        while (i < 5) {
            buffer[4 * i + 1] = BASE64_DIGITS[uuid[i * 3] >> 2 & 0x3F];
            buffer[4 * i + 2] = BASE64_DIGITS[uuid[i * 3] << 4 & 0x30 | uuid[i * 3 + 1] >> 4 & 0xF];
            buffer[4 * i + 3] = BASE64_DIGITS[uuid[i * 3 + 1] << 2 & 0x3C | uuid[i * 3 + 2] >> 6 & 3];
            buffer[4 * i + 4] = BASE64_DIGITS[uuid[i * 3 + 2] & 0x3F];
            ++i;
        }
        buffer[21] = BASE64_DIGITS[uuid[15] >> 2 & 0x3F];
        buffer[22] = BASE64_DIGITS[uuid[15] << 4 & 0x30];
    }

    private byte[] createUUID() {
        return new byte[16];
    }

    private char[] createBuffer() {
        char[] buffer = new char[23];
        buffer[0] = 95;
        return buffer;
    }
}

