/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativesSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedCurrentSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.CompositeSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtext.CompoundElement;

public class SequenceSerializationNode
extends CompositeSerializationNode {
    protected final @NonNull CompoundElement compoundElement;
    protected final @NonNull List<@NonNull SerializationNode> serializationNodes;

    public SequenceSerializationNode(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, @NonNull List<@NonNull SerializationNode> groupSerializationNodes) {
        super(grammarCardinality);
        this.compoundElement = compoundElement;
        this.serializationNodes = groupSerializationNodes;
        assert (!groupSerializationNodes.isEmpty());
        assert (grammarCardinality.isOne() || this.noAssignedCurrent(this));
        assert (this.noUnassignedParserRuleCall());
        assert (groupSerializationNodes.size() == new HashSet<SerializationNode>(groupSerializationNodes).size());
        assert (this.onlyRootUnassignedSerializationRuleCall(true));
    }

    @Override
    public @NonNull SerializationNode clone(@Nullable GrammarCardinality grammarCardinality) {
        ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>(this.serializationNodes.size());
        for (SerializationNode serializationNode : this.serializationNodes) {
            newList.add(serializationNode.clone(null));
        }
        if (grammarCardinality == null) {
            grammarCardinality = this.grammarCardinality;
        }
        return new SequenceSerializationNode(this.compoundElement, grammarCardinality, newList);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void gatherStepsAndSubIdioms(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull List<@NonNull SerializationStep> stepsList, @NonNull Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms) {
        int cardinalityVariableIndex;
        SerializationSegment[] serializationSegments = null;
        @NonNull List subIdioms = (List)SerializationUtils.maybeNull(serializationNode2subIdioms.get(this));
        if (subIdioms != null) {
            GrammarAnalysis grammarAnalysis = serializationRuleAnalysis.getGrammarAnalysis();
            serializationSegments = grammarAnalysis.getSerializationSegments(subIdioms, null);
        }
        if ((cardinalityVariableIndex = serializationRuleAnalysis.getCardinalityVariableIndex(this)) < 0) {
            if (stepsList.isEmpty() && serializationSegments != null) {
                SerializationStep.SerializationStepWrapper wrapperStep = new SerializationStep.SerializationStepWrapper(serializationSegments);
                stepsList.add((SerializationStep)wrapperStep);
            }
            for (SerializationNode serializationNode : this.serializationNodes) {
                serializationNode.gatherStepsAndSubIdioms(serializationRuleAnalysis, stepsList, serializationNode2subIdioms);
            }
        } else {
            SerializationStep.SerializationStepSequence sequenceStep = new SerializationStep.SerializationStepSequence(cardinalityVariableIndex, 0, this.grammarCardinality, null);
            stepsList.add((SerializationStep)sequenceStep);
            int loopStartIndex = stepsList.size();
            for (SerializationNode serializationNode : this.serializationNodes) {
                serializationNode.gatherStepsAndSubIdioms(serializationRuleAnalysis, stepsList, serializationNode2subIdioms);
            }
            sequenceStep.setStepsRange(stepsList.size() - loopStartIndex);
        }
    }

    public @NonNull List<@NonNull SerializationNode> getSerializationNodes() {
        return this.serializationNodes;
    }

    private boolean noAssignedCurrent(@NonNull SerializationNode serializationNode) {
        if (serializationNode instanceof AssignedCurrentSerializationNode) {
            return false;
        }
        if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                if (this.noAssignedCurrent(nestedSerializationNode)) continue;
                return false;
            }
        } else if (serializationNode.isList() || serializationNode.isListOfList() || serializationNode.isNull() || serializationNode instanceof AlternativesSerializationNode) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    @Override
    public boolean noUnassignedParserRuleCall() {
        for (SerializationNode serializationNode : this.serializationNodes) {
            if (serializationNode.noUnassignedParserRuleCall()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onlyRootUnassignedSerializationRuleCall(boolean isRootAlternative) {
        if (this.serializationNodes.size() > 1) {
            isRootAlternative = false;
        }
        for (SerializationNode serializationNode : this.serializationNodes) {
            if (serializationNode.onlyRootUnassignedSerializationRuleCall(isRootAlternative)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.append("{");
        for (SerializationNode serializationNode : this.serializationNodes) {
            s.appendIndentation(depth);
            s.append(depth >= 0 ? "+\t" : " ");
            serializationNode.toString(s, depth >= 0 ? depth + 1 : depth);
        }
        s.appendIndentation(depth);
        s.append(" }");
        this.appendCardinality(s, depth);
    }
}

