/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.toolopts.ToolApp;
import org.eclipse.ptp.etfw.toolopts.ToolIO;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolStep
extends Job
implements IToolLaunchConfigurationConstants {
    protected String projectLocation = null;
    protected String outputLocation = null;
    protected String projectBinary = null;
    protected String projectName = null;
    protected ICProject thisCProject = null;
    protected IProject thisProject = null;
    protected ILaunchConfiguration configuration = null;
    protected Map<String, String> IOMap = null;
    protected boolean isSyncProject = false;
    IBuildLaunchUtils utilBlob = null;

    protected static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(configuration.getAttribute("perf_project_name_tag_for_name_value", null), null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected ToolStep(ILaunchConfiguration conf, String name, IBuildLaunchUtils utilBlob) throws CoreException {
        super(name);
        this.configuration = conf;
        this.thisProject = ToolStep.getProject(this.configuration);
        this.thisCProject = CCorePlugin.getDefault().getCoreModel().create(this.thisProject);
        this.isSyncProject = RemoteSyncNature.hasNature((IProject)this.thisProject);
        this.projectLocation = this.isSyncProject ? SyncConfigManager.getActive((IProject)this.thisProject).getLocation() : this.thisCProject.getResource().getLocationURI().getPath();
        this.outputLocation = this.projectLocation;
        this.projectBinary = Messages.ToolStep_Unknown;
        this.projectName = Messages.ToolStep_Unknown;
        this.utilBlob = utilBlob;
        this.IOMap = new HashMap<String, String>();
    }

    private String createOutputPath(ToolIO IO) {
        String opath = String.valueOf(this.projectLocation) + File.separator + IO.ID + File.separator + BuildLaunchUtils.getNow();
        File ofile = new File(opath);
        ofile.mkdirs();
        this.IOMap.put(IO.ID, opath);
        return opath;
    }

    public ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    protected List<String> getToolArgumentList(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return null;
        }
        List allargs = app.getArguments(configuration);
        int i = 0;
        while (i < allargs.size()) {
            String tmp = this.insertProjectValues((String)allargs.get(i));
            allargs.set(i, tmp);
            ++i;
        }
        String io = this.parseInput(app).trim();
        if (io.length() > 0) {
            allargs.add(io);
        }
        if ((io = this.parseOutput(app).trim()).length() > 0) {
            allargs.add(io);
        }
        return allargs;
    }

    protected String getToolArguments(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        List<String> argList = this.getToolArgumentList(app, configuration);
        String args = "";
        if (argList == null) {
            return args;
        }
        for (String a : argList) {
            args = String.valueOf(args) + a + " ";
        }
        return args;
    }

    protected String getToolCommand(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        String command = this.getToolExecutable(app);
        if (command == null) {
            return null;
        }
        return String.valueOf(command) + " " + this.getToolArguments(app, configuration);
    }

    protected List<String> getToolCommandList(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        String exec = this.getToolExecutable(app);
        if (exec == null) {
            return null;
        }
        command.add(exec.trim());
        List<String> args = this.getToolArgumentList(app, configuration);
        if (args == null) {
            return command;
        }
        command.addAll(args);
        return command;
    }

    protected Map<String, String> getToolEnvVars(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return null;
        }
        Map map = app.getEnvVars(configuration);
        for (Map.Entry entry : map.entrySet()) {
            String tmp = this.insertProjectValues((String)entry.getValue());
            entry.setValue(tmp);
        }
        return map;
    }

    protected String getToolExecutable(ToolApp app) {
        String command = app.toolCommand;
        String toolPath = this.utilBlob.getToolPath(app.toolGroup);
        if (toolPath == null || toolPath.length() == 0) {
            toolPath = this.utilBlob.checkToolEnvPath(command);
        }
        if (toolPath != null && toolPath.length() > 0) {
            String fiSep = File.separator;
            if (toolPath.startsWith("/")) {
                fiSep = "/";
            }
            command = String.valueOf(toolPath) + fiSep + command;
        }
        return command;
    }

    private String insertProjectValues(String tmp) {
        tmp = tmp.replaceAll("%%REPLACE_WITH_BUILD_DIR%%", this.outputLocation);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_ROOT_DIR%%", this.projectLocation);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_BINARY%%", this.projectBinary);
        tmp = tmp.replaceAll("%%REPLACE_WITH_PROJECT_NAME%%", this.projectName);
        return tmp;
    }

    private String parseInput(ToolApp app) {
        String input = "";
        if (app.inputArgs != null) {
            ToolIO[] toolIOArray = app.inputArgs;
            int n = app.inputArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ToolIO inputArg = toolIOArray[n2];
                if (!this.IOMap.containsKey(inputArg.ID)) {
                    return "";
                }
                input = String.valueOf(input) + this.IOMap.get(inputArg.ID);
                ++n2;
            }
        }
        return input;
    }

    private String parseOutput(ToolApp app) {
        String output = "";
        if (app.outputArgs != null) {
            ToolIO[] toolIOArray = app.outputArgs;
            int n = app.outputArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ToolIO outputArg = toolIOArray[n2];
                if (outputArg.pathFlag != null) {
                    output = String.valueOf(output) + outputArg.pathFlag + " ";
                }
                output = this.IOMap.containsKey(outputArg.ID) ? String.valueOf(output) + this.IOMap.get(outputArg.ID) : String.valueOf(output) + this.createOutputPath(outputArg);
                ++n2;
            }
        }
        return output;
    }

    public void setConfiguration(ILaunchConfiguration conf) {
        this.configuration = conf;
    }
}

