/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.keyboard.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.reddeer.common.platform.RunningPlatform;
import org.eclipse.reddeer.swt.exception.SWTLayerException;

public class ModifierKeysBinding {
    private static String ALT = "alt";
    private static String CTRL = "ctrl";
    private static String SHIFT = "shift";
    private Map<String, Integer> modifierKeysMap = new HashMap<String, Integer>();

    public ModifierKeysBinding() {
        this.modifierKeysMap.put(ALT, 65536);
        if (RunningPlatform.isOSX()) {
            this.modifierKeysMap.put(CTRL, 0x400000);
        } else {
            this.modifierKeysMap.put(CTRL, 262144);
        }
        this.modifierKeysMap.put(SHIFT, 131072);
    }

    public Integer getModifierKeyFromString(String keyName) {
        Integer keyModifierInt = this.modifierKeysMap.get(keyName.toLowerCase());
        if (keyModifierInt == null) {
            throw new SWTLayerException("keyName for modifier key not recognized: " + keyName);
        }
        return keyModifierInt;
    }
}

