/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperLinkHandler
extends ControlHandler {
    private static HyperLinkHandler instance;

    public static HyperLinkHandler getInstance() {
        if (instance == null) {
            instance = new HyperLinkHandler();
        }
        return instance;
    }

    public void activate(final Hyperlink hyperLink) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                hyperLink.setFocus();
                HyperLinkHandler.this.notifyHyperlink(6, hyperLink);
                HyperLinkHandler.this.notifyHyperlink(3, hyperLink);
                HyperLinkHandler.this.notifyHyperlink(4, hyperLink);
            }
        });
    }

    public void notifyHyperlink(int eventType, Hyperlink widget) {
        Event event = this.createHyperlinkEvent(widget);
        this.notifyWidget(eventType, event, (Widget)widget);
    }

    private Event createHyperlinkEvent(Hyperlink widget) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = Display.getDisplay();
        event.button = 1;
        event.x = 0;
        event.y = 0;
        return event;
    }

    public String getText(final Hyperlink widget) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return widget.getText();
            }
        });
    }
}

