/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.core.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.remote.internal.proxy.server.core.commands.AbstractServerExecCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;

public class ServerExecCommand
extends AbstractServerExecCommand {
    @Override
    public Process doRun() throws IOException {
        System.err.print("exec: ");
        for (String arg : this.getCommand()) {
            System.err.print(String.valueOf(arg) + " ");
        }
        System.err.println();
        ProcessBuilder builder = new ProcessBuilder(this.getCommand());
        try {
            if (!this.isAppendEnv()) {
                builder.environment().clear();
                builder.environment().putAll(this.getEnv());
            } else {
                for (Map.Entry<String, String> entry : this.getEnv().entrySet()) {
                    String val = builder.environment().get(entry.getKey());
                    if (val != null && val.equals(entry.getValue())) continue;
                    builder.environment().put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException entry) {
            // empty catch block
        }
        File dir = new File(this.getDirectory());
        if (dir.exists() && dir.isAbsolute()) {
            builder.directory(dir);
        }
        builder.redirectErrorStream(this.isRedirect());
        return builder.start();
    }

    @Override
    protected void doKill(Process proc) {
        if (proc.isAlive()) {
            proc.destroyForcibly();
        }
    }

    @Override
    protected void doSetTerminalSize(Process proc, int cols, int rows) {
    }

    public ServerExecCommand(List<String> command, Map<String, String> env, String directory, boolean redirect, boolean appendEnv, StreamChannel cmdChan, StreamChannel ioChan, StreamChannel errChan) {
        super(command, env, directory, redirect, appendEnv, cmdChan, ioChan, errChan);
    }
}

