/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemExpansionChangeCommand;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;
import org.eclipse.sirius.tree.ui.provider.Messages;

public class ExpandDTreeItemRunnableWithProgress
implements IRunnableWithProgress {
    private final Session session;
    private final DTreeItem dTreeItem;
    private final boolean expand;

    public ExpandDTreeItemRunnableWithProgress(Session session, DTreeItem dTreeItem, boolean expand) {
        this.dTreeItem = dTreeItem;
        this.session = session;
        this.expand = expand;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            TreeRefreshContext globalContext = new TreeRefreshContext(this.session.getModelAccessor(), this.session.getInterpreter(), this.session.getSemanticResources(), this.session.getTransactionalEditingDomain());
            if (this.expand) {
                monitor.beginTask(Messages.ExpandDTreeItemRunnableWithProgress_treeItemExpanding, 1);
                CompoundCommand expandDTreeItemCmd = new CompoundCommand(MessageFormat.format(Messages.ExpandDTreeItemRunnableWithProgress_expandTreeItem, this.dTreeItem.getName()));
                expandDTreeItemCmd.append((Command)new DTreeItemExpansionChangeCommand((GlobalContext)globalContext, domain, this.dTreeItem, monitor, true));
                if (!Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null)) {
                    SiriusCommand result = new SiriusCommand(domain);
                    result.getTasks().add(new RefreshTreeElementTask((EObject)this.dTreeItem));
                    expandDTreeItemCmd.append((Command)result);
                }
                commandStack.execute((Command)expandDTreeItemCmd);
                if (commandStack.getMostRecentCommand() != expandDTreeItemCmd) {
                    throw new InterruptedException();
                }
            } else {
                monitor.beginTask(Messages.ExpandDTreeItemRunnableWithProgress_treeItemCollapsing, 1);
                DTreeItemExpansionChangeCommand collapseDTreeItemCmd = new DTreeItemExpansionChangeCommand((GlobalContext)globalContext, domain, this.dTreeItem, monitor, false);
                commandStack.execute((Command)collapseDTreeItemCmd);
            }
        }
        finally {
            monitor.done();
        }
    }
}

