/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.IgnoreResourcesDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class IgnoreAction
extends WorkspaceTraversalAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(monitor -> {
            IResource[] resources = this.getSelectedResources();
            IgnoreResourcesDialog dialog = new IgnoreResourcesDialog(this.getShell(), resources);
            if (dialog.open() != 0) {
                return;
            }
            new IgnoreOperation(this.getTargetPart(), resources, dialog).run();
        }, false, 2);
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.IgnoreAction_ignore;
    }

    @Override
    protected boolean isEnabledForManagedResources() {
        return false;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        if (super.isEnabledForCVSResource(cvsResource)) {
            CVSWorkspaceSubscriber subscriber = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
            IResource resource = cvsResource.getIResource();
            if (resource == null) {
                return false;
            }
            try {
                SyncInfo info = subscriber.getSyncInfo(resource);
                return (info.getKind() & 0xC) == 4;
            }
            catch (TeamException teamException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getId() {
        return "org.eclipse.team.cvs.ui.ignore";
    }

    class IgnoreOperation
    extends RepositoryProviderOperation {
        private final IgnoreResourcesDialog dialog;

        public IgnoreOperation(IWorkbenchPart part, IResource[] resources, IgnoreResourcesDialog dialog) {
            super(part, resources);
            this.dialog = dialog;
        }

        @Override
        protected String getTaskName(CVSTeamProvider provider) {
            return NLS.bind((String)CVSUIMessages.IgnoreAction_0, (Object[])new String[]{provider.getProject().getName()});
        }

        @Override
        protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
            try {
                try {
                    monitor.beginTask(null, resources.length);
                    IResource[] iResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        String pattern = this.dialog.getIgnorePatternFor(resource);
                        ICVSResource cvsResource = IgnoreAction.this.getCVSResourceFor(resource);
                        cvsResource.setIgnoredAs(pattern);
                        monitor.worked(1);
                        ++n2;
                    }
                }
                catch (TeamException e) {
                    this.collectStatus(e.getStatus());
                    monitor.done();
                    return;
                }
            }
            finally {
                monitor.done();
            }
            this.collectStatus(Status.OK_STATUS);
        }

        @Override
        protected String getTaskName() {
            return CVSUIMessages.IgnoreAction_1;
        }

        @Override
        public boolean consultModelsForMappings() {
            return false;
        }
    }
}

