/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.BuildScopeOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class WorkspaceTraversalAction
extends WorkspaceAction {
    protected ResourceMapping[] getCVSResourceMappings() {
        return this.getSelectedResourceMappings(CVSProviderPlugin.getTypeId());
    }

    private static ResourceTraversal[] getTraversals(IWorkbenchPart part, ISynchronizationScopeManager manager, IProgressMonitor monitor) throws CoreException {
        try {
            BuildScopeOperation op = new BuildScopeOperation(part, manager);
            op.run(monitor);
            return manager.getScope().getTraversals();
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    private static IResource[] getRootTraversalResources(ISynchronizationScopeManager manager, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals;
        HashSet<IResource> result = new HashSet<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals = WorkspaceTraversalAction.getTraversals(null, manager, monitor);
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = resources = traversal.getResources();
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) != null) {
                    result.add(resource);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected Subscriber getWorkspaceSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    public static IResource[] getResourcesToCompare(ResourceMapping[] mappings, Subscriber subscriber) throws InvocationTargetException {
        SynchronizationScopeManager manager = new SynchronizationScopeManager("", mappings, (ResourceMappingContext)SubscriberResourceMappingContext.createContext((Subscriber)subscriber), true);
        try {
            IResource[] iResourceArray = WorkspaceTraversalAction.getResourcesToCompare((ISynchronizationScopeManager)manager);
            return iResourceArray;
        }
        finally {
            manager.dispose();
        }
    }

    protected IResource[] getResourcesToCompare(Subscriber subscriber) throws InvocationTargetException {
        return WorkspaceTraversalAction.getResourcesToCompare(this.getCVSResourceMappings(), subscriber);
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    public static IResource[] getResourcesToCompare(ISynchronizationScopeManager manager) throws InvocationTargetException {
        IResource[][] resources = new IResource[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    iResourceArray[0] = WorkspaceTraversalAction.getRootTraversalResources(manager, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return resources[0];
    }

    public static IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            projects.add(resource.getProject());
            ++n2;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    @Deprecated
    public static boolean isLogicalModel(ResourceMapping[] mappings) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (!(mapping.getModelObject() instanceof IResource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IFile getSelectedFile() {
        IResource resource;
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        if (mappings.length == 1 && (resource = Utils.getResource((Object)mappings[0].getModelObject())) != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    protected boolean hasOutgoingChanges(RepositoryProviderOperation operation) throws InvocationTargetException, InterruptedException {
        boolean[] hasChange = new boolean[1];
        PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
            try {
                try {
                    monitor.beginTask(CVSUIMessages.WorkspaceTraversalAction_0, 100);
                    operation.buildScope(Policy.subMonitorFor(monitor, 50));
                    blArray[0] = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().hasLocalChanges(operation.getScope().getTraversals(), Policy.subMonitorFor(monitor, 50));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        });
        return hasChange[0];
    }

    protected ResourceTraversal[] getTraversals(IProgressMonitor monitor) throws CoreException {
        SynchronizationScopeManager scopeManager = this.getScopeManager();
        try {
            ResourceTraversal[] resourceTraversalArray = WorkspaceTraversalAction.getTraversals(this.getTargetPart(), (ISynchronizationScopeManager)scopeManager, monitor);
            return resourceTraversalArray;
        }
        finally {
            scopeManager.dispose();
        }
    }

    protected SynchronizationScopeManager getScopeManager() {
        return new SynchronizationScopeManager("", this.getCVSResourceMappings(), this.getResourceMappingContext(), true);
    }
}

