/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.flyout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.wb.core.controls.Messages;
import org.eclipse.wb.core.controls.flyout.IFlyoutMenuContributor;
import org.eclipse.wb.core.controls.flyout.IFlyoutPreferences;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ICursorConstants;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class FlyoutControlComposite
extends Composite {
    private static final int RESIZE_WIDTH = 5;
    private static final int TITLE_LINES = 30;
    private static final int TITLE_MARGIN = 5;
    private static final Font TITLE_FONT = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private static final Image PIN = FlyoutControlComposite.loadImage("icons/pin.gif");
    private static final Image ARROW_LEFT = FlyoutControlComposite.loadImage("icons/arrow_left.gif");
    private static final Image ARROW_RIGHT = FlyoutControlComposite.loadImage("icons/arrow_right.gif");
    private static final Image ARROW_TOP = FlyoutControlComposite.loadImage("icons/arrow_top.gif");
    private static final Image ARROW_BOTTOM = FlyoutControlComposite.loadImage("icons/arrow_bottom.gif");
    private final IFlyoutPreferences m_preferences;
    private final FlyoutContainer m_flyoutContainer;
    private int m_minWidth = 150;
    private int m_validDockLocations = -1;
    private final List<IFlyoutMenuContributor> m_menuContributors = new ArrayList<IFlyoutMenuContributor>();

    private static Image loadImage(String path) {
        return DrawUtils.loadImage(FlyoutControlComposite.class, path);
    }

    public FlyoutControlComposite(Composite parent, int style, IFlyoutPreferences preferences) {
        super(parent, style);
        this.m_preferences = preferences;
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (FlyoutControlComposite.this.getShell().getMinimized()) {
                    return;
                }
                FlyoutControlComposite.this.layout();
            }
        });
        this.m_flyoutContainer = new FlyoutContainer(this, 262144);
    }

    public Composite getFlyoutParent() {
        return this.m_flyoutContainer;
    }

    public Composite getClientParent() {
        return this;
    }

    public void setValidDockLocations(int validDockLocations) {
        this.m_validDockLocations = validDockLocations;
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public void setTitleText(String text) {
        this.m_flyoutContainer.setTitleText(text);
    }

    public void addMenuContributor(IFlyoutMenuContributor contributor) {
        if (!this.m_menuContributors.contains(contributor)) {
            this.m_menuContributors.add(contributor);
        }
    }

    public void layout() {
        int offset;
        int width;
        Rectangle clientArea = this.getClientArea();
        int state = this.m_preferences.getState();
        Control client = this.getChildren()[1];
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        if (this.m_flyoutContainer.getControl() == null) {
            this.m_flyoutContainer.setBounds(0, 0, 0, 0);
            client.setBounds(clientArea);
            return;
        }
        if (state == 0) {
            width = this.m_preferences.getWidth();
            width = this.isHorizontal() ? Math.min(clientArea.width / 2, width) : Math.min(clientArea.height / 2, width);
            width = Math.max(width, this.m_minWidth);
            width = Math.max(width, 2 * this.m_flyoutContainer.m_titleHeight + this.m_flyoutContainer.m_titleWidth);
            this.m_preferences.setWidth(width);
            offset = width;
        } else if (state == 2) {
            offset = this.m_flyoutContainer.m_titleHeight;
            width = this.m_preferences.getWidth();
        } else {
            offset = width = this.m_flyoutContainer.m_titleHeight;
        }
        if (this.isWest()) {
            this.m_flyoutContainer.setBounds(0, 0, width, clientArea.height);
            client.setBounds(offset, 0, clientArea.width - offset, clientArea.height);
        } else if (this.isEast()) {
            this.m_flyoutContainer.setBounds(clientArea.width - width, 0, width, clientArea.height);
            client.setBounds(0, 0, clientArea.width - offset, clientArea.height);
        } else if (this.isNorth()) {
            this.m_flyoutContainer.setBounds(0, 0, clientArea.width, width);
            client.setBounds(0, offset, clientArea.width, clientArea.height - offset);
        } else if (this.isSouth()) {
            this.m_flyoutContainer.setBounds(0, clientArea.height - width, clientArea.width, width);
            client.setBounds(0, 0, clientArea.width, clientArea.height - offset);
        }
    }

    private boolean isHorizontal() {
        return this.isWest() || this.isEast();
    }

    private boolean isWest() {
        return this.getDockLocation() == 1;
    }

    private boolean isEast() {
        return this.getDockLocation() == 2;
    }

    private boolean isNorth() {
        return this.getDockLocation() == 4;
    }

    private boolean isSouth() {
        return this.getDockLocation() == 8;
    }

    private boolean isValidDockLocation(int location) {
        return (location & this.m_validDockLocations) == location;
    }

    private int getDockLocation() {
        return this.m_preferences.getDockLocation();
    }

    private void setDockLocation(int dockLocation) {
        this.m_preferences.setDockLocation(dockLocation);
        this.layout();
    }

    private class DockAction
    extends Action {
        private final int m_location;

        public DockAction(String text, int location) {
            super(text, 8);
            this.m_location = location;
        }

        public boolean isChecked() {
            return FlyoutControlComposite.this.getDockLocation() == this.m_location;
        }

        public void run() {
            FlyoutControlComposite.this.setDockLocation(this.m_location);
        }
    }

    private final class FlyoutContainer
    extends Composite {
        private boolean m_resize;
        private boolean m_stateHover;
        private Image m_backImage;
        private int m_titleWidth;
        private int m_titleHeight;
        private Image m_titleImage;
        private Image m_titleImageRotated;

        public FlyoutContainer(Composite parent, int style) {
            super(parent, style);
            this.configureMenu();
            this.updateTitleImage(Messages.FlyoutControlComposite_title);
            this.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (FlyoutContainer.this.m_titleImage != null) {
                        FlyoutContainer.this.m_titleImage.dispose();
                        FlyoutContainer.this.m_titleImageRotated.dispose();
                        FlyoutContainer.this.m_titleImage = null;
                        FlyoutContainer.this.m_titleImageRotated = null;
                    }
                    if (FlyoutContainer.this.m_backImage != null) {
                        FlyoutContainer.this.m_backImage.dispose();
                        FlyoutContainer.this.m_backImage = null;
                    }
                }
            });
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    FlyoutContainer.this.layout();
                }
            };
            this.addListener(10, listener);
            this.addListener(11, listener);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    FlyoutContainer.this.handlePaint(event.gc);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent event) {
                    if (event.button == 1) {
                        FlyoutContainer.this.handle_mouseDown(event);
                    }
                }

                public void mouseUp(MouseEvent event) {
                    if (event.button == 1) {
                        FlyoutContainer.this.handle_mouseUp(event);
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    FlyoutContainer.this.m_stateHover = false;
                    FlyoutContainer.this.redraw();
                    FlyoutContainer.this.setCursor(null);
                }

                public void mouseHover(MouseEvent e) {
                    FlyoutContainer.this.handle_mouseHover();
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent event) {
                    FlyoutContainer.this.handle_mouseMove(event);
                }
            });
        }

        private void handle_mouseDown(MouseEvent event) {
            if (this.m_stateHover) {
                int state = FlyoutControlComposite.this.m_preferences.getState();
                state = state == 0 ? 1 : 0;
                FlyoutControlComposite.this.m_preferences.setState(state);
                this.redraw();
                FlyoutControlComposite.this.layout();
            } else if (this.getCursor() == ICursorConstants.SIZEWE || this.getCursor() == ICursorConstants.SIZENS) {
                this.m_resize = true;
            } else if (this.getCursor() == ICursorConstants.SIZEALL) {
                this.handleDocking();
            }
        }

        private void handle_mouseUp(MouseEvent event) {
            if (this.m_resize) {
                this.m_resize = false;
                this.handle_mouseMove(event);
            }
        }

        private void handle_mouseMove(MouseEvent event) {
            FlyoutControlComposite container = FlyoutControlComposite.this;
            if (this.m_resize) {
                int width = FlyoutControlComposite.this.isHorizontal() ? this.getSize().x : this.getSize().y;
                int newWidth = width;
                if (FlyoutControlComposite.this.isWest()) {
                    newWidth = event.x + 2;
                } else if (FlyoutControlComposite.this.isEast()) {
                    newWidth = width - event.x + 2;
                } else if (FlyoutControlComposite.this.isNorth()) {
                    newWidth = event.y + 2;
                } else if (FlyoutControlComposite.this.isSouth()) {
                    newWidth = width - event.y + 2;
                }
                if (newWidth != width) {
                    FlyoutControlComposite.this.m_preferences.setWidth(newWidth);
                    this.redraw();
                    container.layout();
                }
            } else {
                Rectangle clientArea = this.getClientArea();
                boolean inside = clientArea.contains(event.x, event.y);
                int x = event.x;
                int y = event.y;
                if (inside) {
                    boolean oldStateHover = this.m_stateHover;
                    if (FlyoutControlComposite.this.isEast()) {
                        this.m_stateHover = x > clientArea.width - this.m_titleHeight && y < this.m_titleHeight;
                    } else {
                        boolean bl = this.m_stateHover = x < this.m_titleHeight && y < this.m_titleHeight;
                    }
                    if (this.m_stateHover != oldStateHover) {
                        this.redraw();
                    }
                    if (this.m_stateHover) {
                        this.setCursor(null);
                        return;
                    }
                    if (this.isOpenExpanded()) {
                        if (FlyoutControlComposite.this.isWest() && x >= clientArea.width - 5) {
                            this.setCursor(ICursorConstants.SIZEWE);
                        } else if (FlyoutControlComposite.this.isEast() && x <= 5) {
                            this.setCursor(ICursorConstants.SIZEWE);
                        } else if (FlyoutControlComposite.this.isNorth() && y >= clientArea.height - 5) {
                            this.setCursor(ICursorConstants.SIZENS);
                        } else if (FlyoutControlComposite.this.isSouth() && y <= 5) {
                            this.setCursor(ICursorConstants.SIZENS);
                        } else {
                            this.setCursor(null);
                        }
                    }
                    if (this.getCursor() == null) {
                        this.setCursor(ICursorConstants.SIZEALL);
                    }
                } else {
                    this.setCursor(null);
                }
            }
        }

        private void handle_mouseHover() {
            if (FlyoutControlComposite.this.m_preferences.getState() == 1 && !this.m_stateHover) {
                FlyoutControlComposite.this.m_preferences.setState(2);
                final FlyoutControlComposite container = FlyoutControlComposite.this;
                container.layout();
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        if (event.type == 12) {
                            FlyoutContainer.this.getDisplay().removeFilter(5, (Listener)this);
                        } else {
                            Point p = ((Control)event.widget).toDisplay(event.x, event.y);
                            if (FlyoutContainer.this.m_resize) {
                                return;
                            }
                            if (FlyoutContainer.this.getClientArea().contains(FlyoutContainer.this.toControl(p.x, p.y))) {
                                return;
                            }
                            if (container.getClientArea().contains(container.toControl(p.x, p.y))) {
                                FlyoutContainer.this.getDisplay().removeFilter(5, (Listener)this);
                                if (FlyoutControlComposite.this.m_preferences.getState() == 2) {
                                    FlyoutControlComposite.this.m_preferences.setState(1);
                                    container.layout();
                                }
                            }
                        }
                    }
                };
                this.addListener(12, listener);
                this.getDisplay().addFilter(5, listener);
            }
        }

        private void handleDocking() {
            final FlyoutControlComposite container = FlyoutControlComposite.this;
            final int width = FlyoutControlComposite.this.m_preferences.getWidth();
            final int oldDockLocation = FlyoutControlComposite.this.getDockLocation();
            final int[] newDockLocation = new int[]{oldDockLocation};
            final Tracker dockingTracker = new Tracker((Composite)container, 0);
            dockingTracker.setRectangles(new Rectangle[]{this.getBounds()});
            dockingTracker.setStippled(true);
            dockingTracker.addListener(10, new Listener(){

                public void handleEvent(Event event2) {
                    Rectangle clientArea = container.getClientArea();
                    Point location = container.toControl(event2.x, event2.y);
                    int h3 = clientArea.height / 3;
                    if (location.y < h3 && FlyoutControlComposite.this.isValidDockLocation(4)) {
                        dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, 0, clientArea.width, width)});
                        newDockLocation[0] = 4;
                    } else if (location.y > 2 * h3 && FlyoutControlComposite.this.isValidDockLocation(8)) {
                        dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, clientArea.height - width, clientArea.width, width)});
                        newDockLocation[0] = 8;
                    } else if (location.x < clientArea.width / 2 && FlyoutControlComposite.this.isValidDockLocation(1)) {
                        dockingTracker.setRectangles(new Rectangle[]{new Rectangle(0, 0, width, clientArea.height)});
                        newDockLocation[0] = 1;
                    } else if (FlyoutControlComposite.this.isValidDockLocation(2)) {
                        dockingTracker.setRectangles(new Rectangle[]{new Rectangle(clientArea.width - width, 0, width, clientArea.height)});
                        newDockLocation[0] = 2;
                    } else {
                        dockingTracker.setRectangles(new Rectangle[]{FlyoutContainer.this.getBounds()});
                        newDockLocation[0] = oldDockLocation;
                    }
                }
            });
            if (dockingTracker.open()) {
                FlyoutControlComposite.this.setDockLocation(newDockLocation[0]);
            }
            dockingTracker.dispose();
        }

        private Control getControl() {
            Control[] children = this.getChildren();
            return children.length == 1 ? children[0] : null;
        }

        public void setTitleText(String text) {
            this.updateTitleImage(text);
        }

        public void layout() {
            Control control = this.getControl();
            if (control == null) {
                return;
            }
            Rectangle clientArea = this.getClientArea();
            if (this.isOpenExpanded()) {
                if (FlyoutControlComposite.this.isWest()) {
                    int y = this.m_titleHeight;
                    control.setBounds(0, y, clientArea.width - 5, clientArea.height - y);
                } else if (FlyoutControlComposite.this.isEast()) {
                    int y = this.m_titleHeight;
                    control.setBounds(5, y, clientArea.width - 5, clientArea.height - y);
                } else if (FlyoutControlComposite.this.isNorth()) {
                    int y = this.m_titleHeight;
                    control.setBounds(0, y, clientArea.width, clientArea.height - y - 5);
                } else if (FlyoutControlComposite.this.isSouth()) {
                    int y = 5 + this.m_titleHeight;
                    control.setBounds(0, y, clientArea.width, clientArea.height - y);
                }
            } else {
                control.setBounds(0, 0, 0, 0);
            }
        }

        private void handlePaint(GC paintGC) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.isEmpty()) {
                return;
            }
            if (this.m_backImage == null || !this.m_backImage.getBounds().equals((Object)clientArea)) {
                if (this.m_backImage != null) {
                    this.m_backImage.dispose();
                }
                this.m_backImage = new Image((Device)this.getDisplay(), clientArea.width, clientArea.height);
            }
            GC gc = new GC((Drawable)this.m_backImage);
            gc.setBackground(paintGC.getBackground());
            gc.setForeground(paintGC.getForeground());
            gc.fillRectangle(clientArea);
            if (this.isOpenExpanded()) {
                if (FlyoutControlComposite.this.isWest()) {
                    this.drawStateImage(gc, 0, 0);
                    gc.drawImage(this.m_titleImage, this.m_titleHeight, 0);
                } else if (FlyoutControlComposite.this.isEast()) {
                    int x = clientArea.width - this.m_titleHeight;
                    this.drawStateImage(gc, x, 0);
                    gc.drawImage(this.m_titleImage, x - this.m_titleWidth, 0);
                } else if (FlyoutControlComposite.this.isNorth()) {
                    this.drawStateImage(gc, 0, 0);
                    gc.drawImage(this.m_titleImage, this.m_titleHeight, 0);
                } else if (FlyoutControlComposite.this.isSouth()) {
                    int y = 5;
                    this.drawStateImage(gc, 0, y);
                    gc.drawImage(this.m_titleImage, this.m_titleHeight, y);
                }
                this.drawResizeBand(gc);
            } else {
                if (FlyoutControlComposite.this.isHorizontal()) {
                    this.drawStateImage(gc, 0, 0);
                    gc.drawImage(this.m_titleImageRotated, 0, this.m_titleHeight);
                } else {
                    this.drawStateImage(gc, 0, 0);
                    gc.drawImage(this.m_titleImage, this.m_titleHeight, 0);
                }
                DrawUtils.drawHighlightRectangle(gc, 0, 0, clientArea.width, clientArea.height);
            }
            gc.dispose();
            paintGC.drawImage(this.m_backImage, 0, 0);
        }

        private void drawStateImage(GC gc, int x, int y) {
            DrawUtils.drawImageCHCV(gc, this.getStateImage(), x, y, this.m_titleHeight, this.m_titleHeight);
            if (this.m_stateHover) {
                DrawUtils.drawHighlightRectangle(gc, x, y, this.m_titleHeight, this.m_titleHeight);
            }
        }

        private Image getStateImage() {
            int location = FlyoutControlComposite.this.getDockLocation();
            int state = FlyoutControlComposite.this.m_preferences.getState();
            if (state == 0) {
                switch (location) {
                    case 1: {
                        return ARROW_LEFT;
                    }
                    case 2: {
                        return ARROW_RIGHT;
                    }
                    case 4: {
                        return ARROW_TOP;
                    }
                    case 8: {
                        return ARROW_BOTTOM;
                    }
                }
            } else {
                if (state == 2) {
                    return PIN;
                }
                switch (location) {
                    case 1: {
                        return ARROW_RIGHT;
                    }
                    case 2: {
                        return ARROW_LEFT;
                    }
                    case 4: {
                        return ARROW_BOTTOM;
                    }
                    case 8: {
                        return ARROW_TOP;
                    }
                }
            }
            return null;
        }

        private void drawResizeBand(GC gc) {
            int height;
            int width;
            int y;
            int x;
            Rectangle clientArea = this.getClientArea();
            if (FlyoutControlComposite.this.isHorizontal()) {
                x = FlyoutControlComposite.this.isWest() ? clientArea.width - 5 : 0;
                y = 0;
                width = 5;
                height = clientArea.height;
            } else {
                x = 0;
                y = FlyoutControlComposite.this.isNorth() ? clientArea.height - 5 : 0;
                width = clientArea.width;
                height = 5;
            }
            DrawUtils.drawHighlightRectangle(gc, x, y, width, height);
        }

        private boolean isOpenExpanded() {
            int state = FlyoutControlComposite.this.m_preferences.getState();
            return state == 0 || state == 2;
        }

        private void updateTitleImage(String text) {
            GC gc = new GC((Drawable)this);
            gc.setFont(TITLE_FONT);
            Point textSize = gc.textExtent(text);
            gc.dispose();
            if (this.m_titleImage != null) {
                this.m_titleImage.dispose();
                this.m_titleImageRotated.dispose();
            }
            this.m_titleWidth = textSize.x + 60 + 20;
            this.m_titleHeight = textSize.y;
            this.m_titleImage = new Image((Device)this.getDisplay(), this.m_titleWidth, this.m_titleHeight);
            gc = new GC((Drawable)this.m_titleImage);
            try {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(0, 0, this.m_titleWidth, this.m_titleHeight);
                int x = 0;
                this.drawTitleLines(gc, x += 5, this.m_titleHeight, 30);
                gc.setForeground(IColorConstants.black);
                gc.setFont(TITLE_FONT);
                gc.drawText(text, x += 35, 0);
                x += textSize.x;
                this.drawTitleLines(gc, x += 5, this.m_titleHeight, 30);
            }
            finally {
                gc.dispose();
            }
            this.m_titleImageRotated = DrawUtils.createRotatedImage(this.m_titleImage);
        }

        private void drawTitleLines(GC gc, int x, int height, int width) {
            this.drawTitleLine(gc, x, height / 3, width);
            this.drawTitleLine(gc, x, 2 * height / 3, width);
        }

        private void drawTitleLine(GC gc, int x, int y, int width) {
            int right = x + 30;
            gc.setForeground(IColorConstants.buttonLightest);
            gc.drawLine(x, y, right - 2, y);
            gc.drawLine(x, y + 1, right - 2, y + 1);
            gc.setForeground(IColorConstants.buttonDarker);
            gc.drawLine(right - 2, y, right - 1, y);
            gc.drawLine(x + 2, y + 1, right - 2, y + 1);
        }

        private void configureMenu() {
            final MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuMgr) {
                    this.addDockActions();
                    for (IFlyoutMenuContributor contributor : FlyoutControlComposite.this.m_menuContributors) {
                        contributor.contribute((IMenuManager)manager);
                    }
                }

                private void addDockActions() {
                    MenuManager dockManager = new MenuManager(Messages.FlyoutControlComposite_dockManager);
                    this.addDockAction(dockManager, Messages.FlyoutControlComposite_dockLeft, 1);
                    this.addDockAction(dockManager, Messages.FlyoutControlComposite_dockRight, 2);
                    this.addDockAction(dockManager, Messages.FlyoutControlComposite_dockTop, 4);
                    this.addDockAction(dockManager, Messages.FlyoutControlComposite_dockBottom, 8);
                    manager.add((IContributionItem)dockManager);
                }

                private void addDockAction(MenuManager dockManager, String text, int location) {
                    if ((FlyoutControlComposite.this.m_validDockLocations & location) != 0) {
                        dockManager.add((IAction)new DockAction(text, location));
                    }
                }
            });
            this.setMenu(manager.createContextMenu((Control)this));
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    manager.dispose();
                }
            });
        }
    }
}

