/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.beans;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.databinding.model.IObserveDecoration;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.presentation.SimpleObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.decorate.IObserveDecorator;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.BeanPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.providers.TypeImageProvider;

public class BeanPropertyObserveInfo
extends BeanObserveInfo
implements IObserveDecoration {
    private final ObserveCreationType m_creationType;
    private final IObservePresentation m_presentation;
    private final IObserveDecorator m_decorator;

    public BeanPropertyObserveInfo(BeanSupport beanSupport, ObserveInfo parent, String text, IGenericType objectType, IReferenceProvider referenceProvider, IObserveDecorator decorator) throws Exception {
        super(beanSupport, parent instanceof BeanPropertyObserveInfo ? parent : null, objectType, referenceProvider);
        this.setBindingDecoration(1);
        this.m_creationType = List.class.isAssignableFrom(this.getObjectClass()) ? ObserveCreationType.ListProperty : ObserveCreationType.AnyProperty;
        Image beenImage = beanSupport.getBeanImage(this.getObjectClass(), null, false);
        this.m_presentation = new SimpleObservePresentation(text, text, beenImage == null ? TypeImageProvider.getImage(this.getObjectClass()) : beenImage);
        this.m_decorator = decorator;
    }

    public final void setHostedType(IGenericType objectType) {
        this.setObjectType(objectType);
        this.setProperties(null);
    }

    public ObserveType getType() {
        return null;
    }

    public ObserveCreationType getCreationType() {
        return this.m_creationType;
    }

    public boolean canShared() {
        return true;
    }

    public PropertyInfo createProperty(ObserveInfo observeObject) throws Exception {
        StringBuffer reference = new StringBuffer(this.getReference());
        ObserveInfo parent = (ObserveInfo)this.getParent();
        while (parent != null) {
            reference.insert(0, String.valueOf(parent.getReference()) + ".");
            parent = (ObserveInfo)parent.getParent();
        }
        return new BeanPropertyInfo(observeObject.getObjectType(), this.getObjectType(), null, reference.toString());
    }

    public IObservePresentation getPresentation() {
        return this.m_presentation;
    }

    public final IObserveDecorator getDecorator() {
        return this.m_decorator;
    }
}

