/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.absolute;

import java.util.List;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundProcessor;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class AbsoluteLayoutSurroundProcessor
implements ISurroundProcessor<CompositeInfo, ControlInfo> {
    public static final Object INSTANCE = new AbsoluteLayoutSurroundProcessor();

    private AbsoluteLayoutSurroundProcessor() {
    }

    public boolean filter(CompositeInfo sourceContainer, CompositeInfo targetContainer) throws Exception {
        String targetClassName = targetContainer.getDescription().getComponentClass().getName();
        boolean isComposite = targetClassName.equals("org.eclipse.swt.widgets.Composite");
        boolean isGroup = targetClassName.equals("org.eclipse.swt.widgets.Group");
        return sourceContainer.hasLayout() && sourceContainer.getLayout() instanceof AbsoluteLayoutInfo && (isComposite || isGroup);
    }

    public void move(CompositeInfo sourceContainer, CompositeInfo targetContainer, List<ControlInfo> components) throws Exception {
        AbsoluteLayoutInfo targetLayout = (AbsoluteLayoutInfo)targetContainer.getLayout();
        Rectangle targetBounds = (Rectangle)targetContainer.getArbitraryValue("SurroundSupport_BOUNDS");
        targetBounds.expand(targetContainer.getClientAreaInsets2());
        Point locationOffset = targetBounds.getLocation().getNegated();
        AbsoluteLayoutInfo sourceLayout = (AbsoluteLayoutInfo)sourceContainer.getLayout();
        sourceLayout.commandChangeBounds(targetContainer, targetBounds.getLocation(), targetBounds.getSize());
        for (ControlInfo component : components) {
            Rectangle bounds = component.getModelBounds().getTranslated(locationOffset);
            targetLayout.command_MOVE(component, null);
            targetLayout.commandChangeBounds(component, bounds.getLocation(), bounds.getSize());
        }
    }
}

