/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;

@Beta
public class AbstractCodeMiningTest
extends AbstractEditorTest {
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected ICodeMiningProvider codeMiningProvider;

    public void testCodeMining(CharSequence initialText, String expected) {
        IFile dslFile = this.dslFile(initialText);
        XtextEditor editor = this.openEditor(dslFile);
        this.codeMiningsArePresent(editor, expected);
    }

    @Override
    protected XtextEditor openEditor(IFile dslFile) {
        try {
            XtextEditor editor = super.openEditor(dslFile);
            AbstractCodeMiningTest.assertNotNull((Object)editor);
            return editor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void codeMiningsArePresent(XtextEditor editor, String expected) {
        String actual = this.insertCodeMinings(editor);
        AbstractCodeMiningTest.assertEquals((Object)expected, (Object)actual);
    }

    protected String insertCodeMinings(XtextEditor editor) {
        ISourceViewer viewer = editor.getInternalSourceViewer();
        String text = editor.getDocument().get();
        StringBuilder sb = new StringBuilder(text);
        List codeMinings = (List)Futures.getUnchecked((Future)this.codeMiningProvider.provideCodeMinings((ITextViewer)viewer, (IProgressMonitor)new NullProgressMonitor()));
        for (ICodeMining codeMining : codeMinings) {
            Futures.getUnchecked((Future)codeMining.resolve((ITextViewer)viewer, (IProgressMonitor)new NullProgressMonitor()));
            AbstractCodeMiningTest.assertTrue((String)"CodeMining is not resolved!", (boolean)codeMining.isResolved());
        }
        codeMinings.sort((cm1, cm2) -> cm2.getPosition().getOffset() - cm1.getPosition().getOffset());
        Map byPos = codeMinings.stream().collect(Collectors.groupingBy(e -> e.getPosition().getOffset(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry e2 : byPos.entrySet()) {
            int codeMiningOffset = (Integer)e2.getKey();
            List miningsAtOffset = (List)e2.getValue();
            String codeMiningsText = this.getCodeMiningsText(miningsAtOffset);
            if (this.containsLineHeaderCodeMining(miningsAtOffset)) {
                sb.insert(codeMiningOffset, ((IDocumentExtension4)editor.getDocument()).getDefaultLineDelimiter());
            }
            sb.insert(codeMiningOffset, codeMiningsText);
        }
        return sb.toString();
    }

    protected String getCodeMiningsText(List<? extends ICodeMining> codeMinings) {
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (ICodeMining iCodeMining : codeMinings) {
            String codeMiningLabel = iCodeMining.getLabel();
            if (codeMiningLabel != null) {
                if (count != 0) {
                    result.append(" | ");
                }
                result.append(codeMiningLabel);
            }
            ++count;
        }
        return result.toString();
    }

    protected boolean containsLineHeaderCodeMining(List<ICodeMining> codeMinings) {
        for (ICodeMining codeMining : codeMinings) {
            if (!(codeMining instanceof LineHeaderCodeMining)) continue;
            return true;
        }
        return false;
    }

    protected IFile dslFile(CharSequence content) {
        return this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
    }

    protected String getProjectName() {
        return "CodeMiningTestProject";
    }

    protected String getFileName() {
        return "codeMining";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }
}

