/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.session.Setup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SetupManager {
    private static SetupManager instance;
    private static final String SETUP_DEBUG = "setup.debug";
    private static final String SETUP_FILES = "setup.files";
    private static final String SETUP_OPTIONS = "setup.options";
    private static final String SETUP_OVERRIDE_ECLIPSEARGS = "setup.override.eclipseArgs";
    private static final String SETUP_OVERRIDE_SYSTEMPROPERTIES = "setup.override.systemProperties";
    private static final String SETUP_OVERRIDE_VMARGS = "setup.override.vmArgs";
    private String defaultOptionSetIds = "";
    private Map<String, Setup> setupById;
    private Collection<Setup> setups = new ArrayList<Setup>();

    private static boolean contains(Object[] set, Object element) {
        Object[] objectArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            Object setElement = objectArray[n2];
            if (element.equals(setElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static synchronized SetupManager getInstance() throws SetupException {
        if (instance != null) {
            return instance;
        }
        instance = new SetupManager();
        return instance;
    }

    public static boolean inDebugMode() {
        return Boolean.getBoolean(SETUP_DEBUG);
    }

    public static void main(String[] args) throws Exception {
        SetupManager manager = SetupManager.getInstance();
        System.out.println(manager.getDefaultSetup());
    }

    static String[] parseItems(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        if (!tokenizer.hasMoreTokens()) {
            return new String[0];
        }
        String first = tokenizer.nextToken().trim();
        if (!tokenizer.hasMoreTokens()) {
            return new String[]{first};
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(first);
        do {
            items.add(tokenizer.nextToken().trim());
        } while (tokenizer.hasMoreTokens());
        return items.toArray(new String[items.size()]);
    }

    protected SetupManager() throws SetupException {
        this.setupById = new HashMap<String, Setup>();
        try {
            this.loadSetups();
        }
        catch (SetupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException("Problems initializing SetupManager", e);
        }
    }

    public Setup buildSetup(String[] optionSets) {
        Setup defaultSetup = Setup.getDefaultSetup(this);
        for (Setup customSetup : this.setups) {
            if (customSetup.getId() != null && !SetupManager.contains(optionSets, customSetup.getId()) || !customSetup.isSatisfied(optionSets)) continue;
            defaultSetup.merge(customSetup);
        }
        defaultSetup.setEclipseArguments(SetupManager.parseOptions(System.getProperty(SETUP_OVERRIDE_ECLIPSEARGS)));
        defaultSetup.setVMArguments(SetupManager.parseOptions(System.getProperty(SETUP_OVERRIDE_VMARGS)));
        defaultSetup.setSystemProperties(SetupManager.parseOptions(System.getProperty(SETUP_OVERRIDE_SYSTEMPROPERTIES)));
        return defaultSetup;
    }

    private String getAttribute(NamedNodeMap attributes, String name) {
        Node selected = attributes.getNamedItem(name);
        return selected == null ? null : selected.getNodeValue();
    }

    private String[] getDefaultOptionSets() {
        return SetupManager.parseItems(System.getProperty(SETUP_OPTIONS, this.defaultOptionSetIds));
    }

    public Setup getDefaultSetup() {
        return this.buildSetup(this.getDefaultOptionSets());
    }

    public Setup getSetup(String id) {
        return this.setupById.get(id);
    }

    private void loadEclipseArgument(Setup newSetup, Element toParse) {
        newSetup.setEclipseArgument(toParse.getAttribute("option"), toParse.getAttribute("value"));
    }

    private void loadProperty(Setup newSetup, Element toParse) {
        newSetup.setSystemProperty(toParse.getAttribute("key"), toParse.getAttribute("value"));
    }

    private void loadSetup(Element markup) {
        NamedNodeMap attributes = markup.getAttributes();
        if (attributes == null) {
            return;
        }
        Setup newSetup = new Setup(this);
        newSetup.setId(this.getAttribute(attributes, "id"));
        newSetup.setName(this.getAttribute(attributes, "name"));
        String timeout = this.getAttribute(attributes, "timeout");
        newSetup.setBaseSetups(SetupManager.parseItems(this.getAttribute(attributes, "base")));
        newSetup.setRequiredSets(SetupManager.parseItems(this.getAttribute(attributes, "with")));
        if (timeout != null) {
            newSetup.setTimeout(Integer.parseInt(timeout));
        }
        NodeList children = markup.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            block17: {
                Node next = children.item(i);
                if (!(next instanceof Element)) break block17;
                Element toParse = (Element)next;
                switch (toParse.getTagName()) {
                    case "eclipseArg": {
                        this.loadEclipseArgument(newSetup, toParse);
                        break;
                    }
                    case "vmArg": {
                        this.loadVMArgument(newSetup, toParse);
                        break;
                    }
                    case "systemProperty": {
                        this.loadProperty(newSetup, toParse);
                        break;
                    }
                }
            }
            ++i;
        }
        this.setups.add(newSetup);
        if (newSetup.getId() != null) {
            this.setupById.put(newSetup.getId(), newSetup);
        }
    }

    private void loadSetups() throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException, SetupException {
        String setupFilesProperty = System.getProperty(SETUP_FILES);
        boolean defaultLocation = false;
        if (setupFilesProperty == null) {
            setupFilesProperty = "default-setup.xml";
            defaultLocation = true;
        }
        String[] setupFileNames = SetupManager.parseItems(setupFilesProperty);
        File[] setupFiles = new File[setupFileNames.length];
        int found = 0;
        int i = 0;
        while (i < setupFiles.length) {
            setupFiles[found] = new File(setupFileNames[i]);
            if (!setupFiles[found].isFile()) {
                if (!defaultLocation) {
                    System.out.println("No setup files found at '" + setupFiles[i].getAbsolutePath() + "'. ");
                }
            } else {
                ++found;
            }
            ++i;
        }
        if (found == 0) {
            if (Platform.isRunning()) {
                return;
            }
            throw new SetupException("No setup descriptions found. Ensure you are specifying the path for an existing setup file (e.g. -Dsetup.files=<setup-file-location1>[...,<setup-file-locationN>])");
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        int fileIndex = 0;
        while (fileIndex < found) {
            Document doc = docBuilder.parse(setupFiles[fileIndex]);
            Element root = doc.getDocumentElement();
            String setupDefaultOptionSets = root.getAttribute("default");
            if (setupDefaultOptionSets != null) {
                this.defaultOptionSetIds = this.defaultOptionSetIds == null ? setupDefaultOptionSets : String.valueOf(this.defaultOptionSetIds) + ',' + setupDefaultOptionSets;
            }
            NodeList optionSets = root.getChildNodes();
            int i2 = 0;
            while (i2 < optionSets.getLength()) {
                Element toParse;
                Node next = optionSets.item(i2);
                if (next instanceof Element && (toParse = (Element)next).getTagName().equals("optionSet")) {
                    this.loadSetup(toParse);
                }
                ++i2;
            }
            ++fileIndex;
        }
    }

    private void loadVMArgument(Setup newSetup, Element toParse) {
        newSetup.setVMArgument(toParse.getAttribute("option"), toParse.getAttribute("value"));
    }

    private static Map<String, String> parseOptions(String options) {
        if (options == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(options.trim(), ";");
        while (tokenizer.hasMoreTokens()) {
            String option = tokenizer.nextToken();
            int separatorIndex = option.indexOf(61);
            if (separatorIndex == -1 || separatorIndex == option.length() - 1) {
                result.put(option, "");
                continue;
            }
            if (!option.contains("==")) {
                String key = option.substring(0, separatorIndex);
                String value = option.substring(separatorIndex + 1);
                result.put(key, value);
                continue;
            }
            int valueStart = -1;
            StringBuilder key = new StringBuilder();
            int i = 0;
            while (i < option.length()) {
                char c = option.charAt(i);
                if (c != '=') {
                    key.append(c);
                } else {
                    if (++i >= option.length()) break;
                    char next = option.charAt(i);
                    if (next == '=') {
                        key.append('=');
                    } else {
                        valueStart = i;
                        break;
                    }
                }
                ++i;
            }
            String value = "";
            if (valueStart > -1) {
                value = option.substring(valueStart).replace("==", "=");
            }
            result.put(key.toString(), value);
        }
        return result;
    }

    public static class SetupException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SetupException(String message, Throwable cause) {
            super(message, cause);
        }

        public SetupException(String message) {
            super(message);
        }
    }
}

