/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.core.tests.session.SessionTestRunner;
import org.eclipse.core.tests.session.Setup;

public class TestDescriptor
extends TestCase {
    private String applicationId;
    private boolean crashTest;
    private String method;
    private String pluginId;
    private Setup setup;
    private Test test;
    private String testClass;
    private SessionTestRunner testRunner;

    public TestDescriptor(String testClass, String method) {
        this.testClass = testClass;
        this.method = method;
    }

    public TestDescriptor(TestCase test) {
        this.testClass = test.getClass().getName();
        this.method = test.getName();
        this.test = test;
    }

    public int countTestCases() {
        return 1;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getName() {
        return this.getTestMethod();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public Test getTest() {
        return this.test == null ? this : this.test;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getTestMethod() {
        return this.method;
    }

    public SessionTestRunner getTestRunner() {
        return this.testRunner;
    }

    public boolean isCrashTest() {
        return this.crashTest;
    }

    public void run(TestResult result) {
        Setup localSetup = (Setup)this.setup.clone();
        localSetup.setEclipseArgument("application", this.applicationId);
        localSetup.setEclipseArgument("testpluginname", this.pluginId);
        localSetup.setEclipseArgument("test", String.valueOf(this.testClass) + ':' + this.method);
        this.getTestRunner().run(this.getTest(), result, localSetup, this.crashTest);
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setCrashTest(boolean crashTest) {
        this.crashTest = crashTest;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void setSetup(Setup setup) {
        this.setup = setup == null ? null : (Setup)setup.clone();
    }

    public void setTestRunner(SessionTestRunner testRunner) {
        this.testRunner = testRunner;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.getTestClass() + ")";
    }
}

