/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SectionManager {
    private static final String __NONE = "__none";
    private Set fSections = new HashSet();
    private boolean fIsBeingManaged = false;
    private ExpansionAdapter fListener = new ExpansionAdapter(){

        public void expansionStateChanged(ExpansionEvent e) {
            ScrolledPageContent parentScrolledComposite;
            ExpandableComposite exComp;
            ExpandableComposite source = (ExpandableComposite)e.getSource();
            SectionManager.this.updateSectionStyle(source);
            if (SectionManager.this.fIsBeingManaged) {
                return;
            }
            if (e.getState()) {
                try {
                    SectionManager.this.fIsBeingManaged = true;
                    for (ExpandableComposite composite : SectionManager.this.fSections) {
                        if (composite == source) continue;
                        composite.setExpanded(false);
                    }
                }
                finally {
                    SectionManager.this.fIsBeingManaged = false;
                }
                if (SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                    SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, source.getText());
                }
            } else if (!SectionManager.this.fIsBeingManaged && SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, SectionManager.__NONE);
            }
            if ((exComp = SectionManager.this.getParentExpandableComposite((Control)source)) != null) {
                exComp.layout(true, true);
            }
            if ((parentScrolledComposite = SectionManager.this.getParentScrolledComposite((Control)source)) != null) {
                parentScrolledComposite.reflow(true);
            }
        }
    };
    private Composite fBody;
    private final String fLastOpenKey;
    private final IPreferenceStore fDialogSettingsStore;
    private ExpandableComposite fFirstChild = null;

    private final ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private boolean isNestedInScrolledComposite(Composite parent) {
        return this.getParentScrolledComposite((Control)parent) != null;
    }

    public SectionManager() {
        this(null, null);
    }

    public SectionManager(IPreferenceStore dialogSettingsStore, String lastOpenKey) {
        this.fDialogSettingsStore = dialogSettingsStore;
        this.fLastOpenKey = lastOpenKey;
    }

    private void manage(ExpandableComposite section) {
        if (section == null) {
            throw new NullPointerException();
        }
        if (this.fSections.add(section)) {
            section.addExpansionListener((IExpansionListener)this.fListener);
        }
        this.makeScrollableCompositeAware((Control)section);
    }

    public Composite createSectionComposite(Composite parent) {
        ScrolledPageContent composite;
        Assert.isTrue((this.fBody == null ? 1 : 0) != 0);
        boolean isNested = this.isNestedInScrolledComposite(parent);
        if (isNested) {
            composite = new Composite(parent, 0);
            this.fBody = composite;
        } else {
            composite = new ScrolledPageContent(parent);
            this.fBody = composite.getBody();
        }
        this.fBody.setLayout((Layout)new GridLayout());
        return composite;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected void updateSectionStyle(ExpandableComposite excomposite) {
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }

    public Composite createSection(String label) {
        Assert.isNotNull((Object)this.fBody);
        ExpandableComposite excomposite = new ExpandableComposite(this.fBody, 0, 50);
        if (this.fFirstChild == null) {
            this.fFirstChild = excomposite;
        }
        excomposite.setText(label);
        String last = null;
        if (this.fLastOpenKey != null && this.fDialogSettingsStore != null) {
            last = this.fDialogSettingsStore.getString(this.fLastOpenKey);
        }
        if (this.fFirstChild == excomposite && !__NONE.equals(last) || label.equals(last)) {
            excomposite.setExpanded(true);
            if (this.fFirstChild != excomposite) {
                this.fFirstChild.setExpanded(false);
            }
        } else {
            excomposite.setExpanded(false);
        }
        excomposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateSectionStyle(excomposite);
        this.manage(excomposite);
        Composite contents = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)contents);
        return contents;
    }
}

